/*
 * Decompiled with CFR 0.152.
 */
package j2meunit.textui;

import j2meunit.framework.AssertionFailedError;
import j2meunit.framework.Test;
import j2meunit.framework.TestCase;
import j2meunit.framework.TestFailure;
import j2meunit.framework.TestListener;
import j2meunit.framework.TestResult;
import j2meunit.util.StringUtil;
import j2meunit.util.Version;
import java.io.PrintStream;
import java.util.Enumeration;

public class TestRunner
implements TestListener {
    protected PrintStream fWriter = System.out;

    public TestRunner() {
    }

    public TestRunner(PrintStream writer) {
        this.fWriter = writer;
    }

    public synchronized void addError(Test test, Throwable t) {
        this.fWriter.print("E");
    }

    public synchronized void addFailure(Test test, AssertionFailedError e) {
        this.fWriter.print("F");
    }

    public void endTest(Test test) {
    }

    public void endTestStep(Test test) {
        this.fWriter.print(".");
    }

    public static void main(String[] args) {
        System.out.println("TestRunner.main()");
        TestRunner aTestRunner = new TestRunner();
        aTestRunner.start(args);
    }

    public synchronized void print(TestResult result) {
        this.printHeader(result);
        this.printErrors(result);
        this.printFailures(result);
    }

    public void printErrors(TestResult result) {
        if (result.errorCount() != 0) {
            if (result.errorCount() == 1) {
                this.fWriter.println("There was " + result.errorCount() + " error:");
            } else {
                this.fWriter.println("There were " + result.errorCount() + " errors:");
            }
            int i = 1;
            Enumeration e = result.errors();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                this.fWriter.println(String.valueOf(i) + ") " + failure.failedTest());
                this.fWriter.println(failure.thrownException().getMessage());
                ++i;
            }
        }
    }

    public void printFailures(TestResult result) {
        if (result.failureCount() != 0) {
            if (result.failureCount() == 1) {
                this.fWriter.println("There was " + result.failureCount() + " failure:");
            } else {
                this.fWriter.println("There were " + result.failureCount() + " failures:");
            }
            int i = 1;
            Enumeration e = result.failures();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                this.fWriter.print(String.valueOf(i) + ") " + failure.failedTest());
                Throwable t = failure.thrownException();
                if (t.getMessage() != null) {
                    this.fWriter.println(" \"" + StringUtil.truncate(t.getMessage(), 80) + "\"");
                } else {
                    this.fWriter.println();
                    this.fWriter.println(failure.thrownException().getMessage());
                }
                ++i;
            }
        }
    }

    public void printHeader(TestResult result) {
        if (result.wasSuccessful()) {
            this.fWriter.println();
            this.fWriter.print("OK");
            this.fWriter.println(" (" + result.runCount() + " tests)");
        } else {
            this.fWriter.println();
            this.fWriter.println("FAILURES!!!");
            this.fWriter.println("Test Results:");
            this.fWriter.println("Run: " + result.runCount() + " Failures: " + result.failureCount() + " Errors: " + result.errorCount());
        }
    }

    public static void run(Test suite) {
        TestRunner aTestRunner = new TestRunner();
        aTestRunner.doRun(suite);
    }

    public synchronized void startTest(Test test) {
        System.out.print(".");
    }

    protected TestResult createTestResult() {
        return new TestResult();
    }

    protected void doRun(Test suite) {
        TestResult result = this.createTestResult();
        result.addListener(this);
        long startTime = System.currentTimeMillis();
        suite.run(result);
        long endTime = System.currentTimeMillis();
        long runTime = endTime - startTime;
        this.fWriter.println();
        this.fWriter.println("Time: " + StringUtil.elapsedTimeAsString(runTime));
        this.print(result);
        this.fWriter.println();
        if (!result.wasSuccessful()) {
            System.exit(-1);
        }
        System.exit(0);
    }

    protected String processArguments(String[] args) {
        String testCase = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-v")) {
                System.out.println("J2ME Unit " + Version.id() + "by RoleModel Software, Inc. \nOriginal JUnit by Kent Beck and Erich Gamma");
            } else {
                testCase = args[i];
            }
            ++i;
        }
        if (testCase.equals("")) {
            System.out.println("Usage: TestRunner testCaseName, where name is the name of the TestCase class");
            System.exit(-1);
        }
        return testCase;
    }

    protected void start(String[] args) {
        String testCaseName = this.processArguments(args);
        try {
            Class<?> testClass = Class.forName(testCaseName);
            TestCase testCase = (TestCase)testClass.newInstance();
            Test suite = testCase.suite();
            this.doRun(suite);
        }
        catch (Exception e) {
            System.out.println("Could not create and run test suite");
            System.exit(-1);
        }
    }
}

