/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.mp.app.j2meunit.framework;

import j2meunit.framework.TestMethod;
import java.io.DataOutputStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class TestCase
extends j2meunit.framework.TestCase {
    private FileConnection logFile;
    private DataOutputStream streamLog;
    public static Hashtable allFilesCreated = new Hashtable();

    public TestCase() {
        this.initLog();
    }

    public TestCase(boolean createLog) {
        if (createLog) {
            this.initLog();
        }
    }

    public TestCase(String name) {
        super(name);
        this.initLog();
    }

    public TestCase(String name, TestMethod testMethod) {
        super(name, testMethod);
        this.initLog();
    }

    private void initLog() {
        try {
            this.logFile = (FileConnection)Connector.open((String)"file:///root1/wolf5-log/");
            if (!this.logFile.exists()) {
                this.logFile.mkdir();
            }
            this.streamLog = (DataOutputStream)allFilesCreated.get(this.getClass().getName());
            if (this.streamLog == null) {
                this.logFile = (FileConnection)Connector.open((String)("file:///root1/wolf5-log/" + this.getClass().getName() + ".log"));
                if (this.logFile.exists()) {
                    this.logFile.delete();
                }
                this.logFile.create();
                this.streamLog = this.logFile.openDataOutputStream();
                this.writeLog("************************************************************");
                this.writeLog("Class Name: " + this.getClass().getName());
                this.writeLog("************************************************************");
                allFilesCreated.put(this.getClass().getName(), this.streamLog);
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR: " + ex.getClass().getName() + " " + ex.getMessage());
        }
    }

    public void writeLogTestCase(String tcID, String methodName) {
        this.writeLog("--------------------------------------------------------");
        this.writeLog("Method Name: " + methodName);
        this.writeLog("Test Case ID: " + tcID);
        this.writeLog("--------------------------------------------------------");
    }

    public void writeLogExecTestCase(String execTcID) {
        this.writeLog("-----------------------");
        this.writeLog("Executable Test Case Id: " + execTcID);
        this.writeLog("-----------------------");
    }

    public void writeLogInput(String input) {
        this.writeLog("Input parameters: " + input);
    }

    public void writeLogExpected(String expected) {
        this.writeLog("Expected Output: " + expected);
    }

    public void writeLogCurrent(String current) {
        this.writeLog("Current Output : " + current);
    }

    public void writeLogCurrent(long current) {
        this.writeLogCurrent(String.valueOf(current));
    }

    public void writeLogCurrent(boolean current) {
        this.writeLogCurrent(String.valueOf(current));
    }

    public void writeLogCurrent(double current) {
        this.writeLogCurrent(String.valueOf(current));
    }

    public void writeLogResultPass() {
        this.writeLog("RESULT: PASS");
        this.writeLog("");
        this.writeLog("");
    }

    public void writeLogResultFail() {
        this.writeLog("RESULT: FAIL");
        this.writeLog("");
        this.writeLog("");
    }

    public void writeLogResultFail(String message) {
        if (message == null) {
            this.writeLogResultFail();
        } else {
            this.writeLog("RESULT: FAIL - " + message);
        }
        this.writeLog("");
        this.writeLog("");
    }

    public void writeLog(String strMessage, boolean closeStream) {
        try {
            this.streamLog.write((String.valueOf(strMessage) + "\r\n").getBytes("UTF-8"));
            if (closeStream) {
                this.streamLog.close();
            }
        }
        catch (Exception ex) {
            System.out.println("Error to writeLog: " + ex.getClass().getName());
        }
    }

    public void writeLog(String strMessage) {
        this.writeLog(strMessage, false);
    }

    public void fail() {
        this.writeLogResultFail();
        super.fail();
    }

    public void fail(String message) {
        this.writeLogResultFail(message);
        super.fail(message);
    }
}

