/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.beans.editor;

import com.l2fprod.common.beans.editor.AbstractPropertyEditor;
import com.l2fprod.common.beans.editor.FixedButton;
import com.l2fprod.common.swing.LookAndFeelTweaks;
import com.l2fprod.common.swing.UserPreferences;
import com.l2fprod.common.util.ResourceManager;
import java.awt.BorderLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.TransferHandler;

public class FilePropertyEditor
extends AbstractPropertyEditor {
    protected JTextField textfield;
    private JButton button;
    static /* synthetic */ Class class$com$l2fprod$common$beans$editor$FilePropertyEditor;

    public FilePropertyEditor() {
        this.editor = new JPanel(new BorderLayout(0, 0));
        this.textfield = new JTextField();
        ((JPanel)this.editor).add("Center", this.textfield);
        this.button = new FixedButton();
        ((JPanel)this.editor).add("East", this.button);
        this.textfield.setBorder(LookAndFeelTweaks.EMPTY_BORDER);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilePropertyEditor.this.selectFile();
            }
        });
        this.textfield.setTransferHandler(new FileTransferHandler());
    }

    public Object getValue() {
        if ("".equals(this.textfield.getText().trim())) {
            return null;
        }
        return new File(this.textfield.getText());
    }

    public void setValue(Object value) {
        if (value instanceof File) {
            this.textfield.setText(((File)value).getAbsolutePath());
        } else {
            this.textfield.setText("");
        }
    }

    protected void selectFile() {
        ResourceManager rm = ResourceManager.all(class$com$l2fprod$common$beans$editor$FilePropertyEditor == null ? (class$com$l2fprod$common$beans$editor$FilePropertyEditor = FilePropertyEditor.class$("com.l2fprod.common.beans.editor.FilePropertyEditor")) : class$com$l2fprod$common$beans$editor$FilePropertyEditor);
        JFileChooser chooser = UserPreferences.getDefaultFileChooser();
        chooser.setDialogTitle(rm.getString("FilePropertyEditor.dialogTitle"));
        chooser.setApproveButtonText(rm.getString("FilePropertyEditor.approveButtonText"));
        chooser.setApproveButtonMnemonic(rm.getChar("FilePropertyEditor.approveButtonMnemonic"));
        if (0 == chooser.showOpenDialog(this.editor)) {
            File oldFile = (File)this.getValue();
            File newFile = chooser.getSelectedFile();
            String text = newFile.getAbsolutePath();
            this.textfield.setText(text);
            this.firePropertyChange(oldFile, newFile);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class FileTransferHandler
    extends TransferHandler {
        FileTransferHandler() {
        }

        public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
            int c = transferFlavors.length;
            for (int i = 0; i < c; ++i) {
                if (!transferFlavors[i].equals(DataFlavor.javaFileListFlavor)) continue;
                return true;
            }
            return false;
        }

        public boolean importData(JComponent comp, Transferable t) {
            try {
                List list = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                if (list.size() > 0) {
                    File oldFile = (File)FilePropertyEditor.this.getValue();
                    File newFile = (File)list.get(0);
                    String text = newFile.getAbsolutePath();
                    FilePropertyEditor.this.textfield.setText(text);
                    FilePropertyEditor.this.firePropertyChange(oldFile, newFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
    }
}

