/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSuite;
import com.sun.net.ssl.internal.ssl.CipherSuiteConstants;
import com.sun.net.ssl.internal.ssl.CipherSuiteList;
import com.sun.net.ssl.internal.ssl.DHKeyExchange;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeHash;
import com.sun.net.ssl.internal.ssl.HandshakeInStream;
import com.sun.net.ssl.internal.ssl.HandshakeOutStream;
import com.sun.net.ssl.internal.ssl.JsseJce;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.PRF;
import com.sun.net.ssl.internal.ssl.ProtocolVersion;
import com.sun.net.ssl.internal.ssl.RSASignature;
import com.sun.net.ssl.internal.ssl.RandomCookie;
import com.sun.net.ssl.internal.ssl.SessionId;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.DigestException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;
import javax.security.auth.x500.X500Principal;

abstract class HandshakeMessage
implements CipherSuiteConstants {
    static final byte ht_hello_request = 0;
    static final byte ht_client_hello = 1;
    static final byte ht_server_hello = 2;
    static final byte ht_certificate = 11;
    static final byte ht_server_key_exchange = 12;
    static final byte ht_certificate_request = 13;
    static final byte ht_server_hello_done = 14;
    static final byte ht_certificate_verify = 15;
    static final byte ht_client_key_exchange = 16;
    static final byte ht_finished = 20;
    static final Debug debug = Debug.getInstance("ssl");

    HandshakeMessage() {
    }

    static byte[] toByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length > 1 && byArray[0] == 0) {
            int n = byArray.length - 1;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 1, byArray2, 0, n);
            byArray = byArray2;
        }
        return byArray;
    }

    public final void write(HandshakeOutStream handshakeOutStream) throws IOException {
        int n = this.messageLength();
        if (n > 0x1000000) {
            throw new SSLException("Handshake message too big, type = " + this.messageType() + ", len = " + n);
        }
        handshakeOutStream.write(this.messageType());
        handshakeOutStream.putInt24(this.messageLength());
        this.send(handshakeOutStream);
    }

    abstract int messageType();

    abstract int messageLength();

    abstract void send(HandshakeOutStream var1) throws IOException;

    abstract void print(PrintStream var1) throws IOException;

    static final class CertificateMsg
    extends HandshakeMessage {
        private X509Certificate[] chain;

        int messageType() {
            return 11;
        }

        CertificateMsg(X509Certificate[] x509CertificateArray) {
            this.chain = x509CertificateArray;
        }

        CertificateMsg(HandshakeInStream handshakeInStream) throws IOException {
            int n;
            int n2 = handshakeInStream.getInt24();
            Vector<Certificate> vector = new Vector<Certificate>(3);
            while (n2 > 0) {
                int n3;
                n = handshakeInStream.getInt24();
                byte[] byArray = new byte[n];
                n2 -= 3 + n;
                for (int i = 0; i != n; i += n3) {
                    n3 = handshakeInStream.read(byArray, i, n - i);
                    if (n3 >= 0) continue;
                    throw new SSLProtocolException("short read of certificates");
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    vector.addElement(certificateFactory.generateCertificate(new ByteArrayInputStream(byArray)));
                }
                catch (CertificateException certificateException) {
                    throw (SSLProtocolException)new SSLProtocolException(certificateException.getMessage()).initCause(certificateException);
                }
            }
            this.chain = new X509Certificate[vector.size()];
            for (n = 0; n < this.chain.length; ++n) {
                this.chain[n] = (X509Certificate)vector.elementAt(n);
            }
        }

        int messageLength() {
            int n = 3;
            try {
                for (int i = this.chain.length - 1; i >= 0; --i) {
                    n += 3 + this.chain[i].getEncoded().length;
                }
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
            return n;
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            try {
                handshakeOutStream.putInt24(this.messageLength() - 3);
                for (int i = 0; i < this.chain.length; ++i) {
                    handshakeOutStream.putBytes24(this.chain[i].getEncoded());
                }
            }
            catch (CertificateException certificateException) {
                throw (SSLProtocolException)new SSLProtocolException(certificateException.getMessage()).initCause(certificateException);
            }
        }

        void print(PrintStream printStream) throws IOException {
            printStream.println("*** Certificate chain");
            if (debug != null && Debug.isOn("verbose")) {
                for (int i = 0; i < this.chain.length; ++i) {
                    printStream.println("chain [" + i + "] = " + this.chain[i]);
                }
                printStream.println("***");
            }
        }

        public X509Certificate[] getCertificateChain() {
            return this.chain;
        }
    }

    static final class CertificateRequest
    extends HandshakeMessage {
        static final int cct_rsa_sign = 1;
        static final int cct_dss_sign = 2;
        static final int cct_rsa_fixed_dh = 3;
        static final int cct_dss_fixed_dh = 4;
        static final int cct_rsa_ephemeral_dh = 5;
        static final int cct_dss_ephemeral_dh = 6;
        private static final byte[] TYPES = new byte[]{1, 2};
        byte[] types;
        DistinguishedName[] authorities;

        int messageType() {
            return 13;
        }

        CertificateRequest(X509Certificate[] x509CertificateArray, CipherSuite.KeyExchange keyExchange) throws IOException {
            this.authorities = new DistinguishedName[x509CertificateArray.length];
            for (int i = 0; i < x509CertificateArray.length; ++i) {
                X500Principal x500Principal = x509CertificateArray[i].getSubjectX500Principal();
                this.authorities[i] = new DistinguishedName(x500Principal);
            }
            this.types = TYPES;
        }

        CertificateRequest(HandshakeInStream handshakeInStream) throws IOException {
            int n;
            DistinguishedName distinguishedName;
            this.types = handshakeInStream.getBytes8();
            ArrayList<DistinguishedName> arrayList = new ArrayList<DistinguishedName>();
            for (n = handshakeInStream.getInt16(); n >= 3; n -= distinguishedName.length()) {
                distinguishedName = new DistinguishedName(handshakeInStream);
                arrayList.add(distinguishedName);
            }
            if (n != 0) {
                throw new SSLProtocolException("Bad CertificateRequest DN length");
            }
            this.authorities = arrayList.toArray(new DistinguishedName[arrayList.size()]);
        }

        X500Principal[] getAuthorities() throws IOException {
            X500Principal[] x500PrincipalArray = new X500Principal[this.authorities.length];
            for (int i = 0; i < this.authorities.length; ++i) {
                x500PrincipalArray[i] = this.authorities[i].getX500Principal();
            }
            return x500PrincipalArray;
        }

        int messageLength() {
            int n = 1 + this.types.length + 2;
            for (int i = 0; i < this.authorities.length; ++i) {
                n += this.authorities[i].length();
            }
            return n;
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            int n;
            int n2 = 0;
            for (n = 0; n < this.authorities.length; ++n) {
                n2 += this.authorities[n].length();
            }
            handshakeOutStream.putBytes8(this.types);
            handshakeOutStream.putInt16(n2);
            for (n = 0; n < this.authorities.length; ++n) {
                this.authorities[n].send(handshakeOutStream);
            }
        }

        void print(PrintStream printStream) throws IOException {
            printStream.println("*** CertificateRequest");
            if (debug != null && Debug.isOn("verbose")) {
                int n;
                printStream.print("Cert Types: ");
                for (n = 0; n < this.types.length; ++n) {
                    switch (this.types[n]) {
                        case 1: {
                            printStream.print("RSA");
                            break;
                        }
                        case 2: {
                            printStream.print("DSS");
                            break;
                        }
                        case 3: {
                            printStream.print("Fixed DH (RSA sig)");
                            break;
                        }
                        case 4: {
                            printStream.print("Fixed DH (DSS sig)");
                            break;
                        }
                        case 5: {
                            printStream.print("Ephemeral DH (RSA sig)");
                            break;
                        }
                        case 6: {
                            printStream.print("Ephemeral DH (DSS sig)");
                            break;
                        }
                        default: {
                            printStream.print("Type-" + this.types[n]);
                        }
                    }
                    if (n == this.types.length) continue;
                    printStream.print(", ");
                }
                printStream.println();
                printStream.println("Cert Authorities:");
                for (n = 0; n < this.authorities.length; ++n) {
                    this.authorities[n].print(printStream);
                }
            }
        }
    }

    static final class CertificateVerify
    extends HandshakeMessage {
        private byte[] signature;

        int messageType() {
            return 15;
        }

        CertificateVerify(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, PrivateKey privateKey, byte[] byArray, SecureRandom secureRandom) throws GeneralSecurityException {
            String string = privateKey.getAlgorithm();
            Signature signature = CertificateVerify.getSignature(protocolVersion, string);
            signature.initSign(privateKey, secureRandom);
            CertificateVerify.updateSignature(signature, protocolVersion, handshakeHash, string, byArray);
            this.signature = signature.sign();
        }

        CertificateVerify(HandshakeInStream handshakeInStream) throws IOException {
            this.signature = handshakeInStream.getBytes16();
        }

        boolean verify(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, PublicKey publicKey, byte[] byArray) throws GeneralSecurityException {
            String string = publicKey.getAlgorithm();
            Signature signature = CertificateVerify.getSignature(protocolVersion, string);
            signature.initVerify(publicKey);
            CertificateVerify.updateSignature(signature, protocolVersion, handshakeHash, string, byArray);
            return signature.verify(this.signature);
        }

        private static Signature getSignature(ProtocolVersion protocolVersion, String string) throws GeneralSecurityException {
            if (string.equals("RSA")) {
                return RSASignature.getInternalInstance();
            }
            if (string.equals("DSA")) {
                String string2 = protocolVersion.v >= ProtocolVersion.TLS10.v ? "RawDSA" : "DSA";
                return JsseJce.getSignature(string2);
            }
            throw new SignatureException("Unrecognized algorithm: " + string);
        }

        private static void updateSignature(Signature signature, ProtocolVersion protocolVersion, HandshakeHash handshakeHash, String string, byte[] byArray) throws SignatureException {
            boolean bl;
            MessageDigest messageDigest = handshakeHash.getMD5Clone();
            MessageDigest messageDigest2 = handshakeHash.getSHAClone();
            boolean bl2 = bl = protocolVersion.v >= ProtocolVersion.TLS10.v;
            if (string.equals("RSA")) {
                if (!bl) {
                    CertificateVerify.updateDigest(messageDigest, MAC.MD5_pad1, MAC.MD5_pad2, byArray);
                    CertificateVerify.updateDigest(messageDigest2, MAC.SHA_pad1, MAC.SHA_pad2, byArray);
                }
                RSASignature.setHashes(signature, messageDigest, messageDigest2);
            } else if (bl) {
                signature.update(messageDigest2.digest());
            } else {
                messageDigest2.update(byArray);
                messageDigest2.update(MAC.SHA_pad1);
                byte[] byArray2 = messageDigest2.digest();
                signature.update(byArray);
                signature.update(MAC.SHA_pad2);
                signature.update(byArray2);
            }
        }

        static void updateDigest(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            messageDigest.update(byArray3);
            messageDigest.update(byArray);
            byte[] byArray4 = messageDigest.digest();
            messageDigest.update(byArray3);
            messageDigest.update(byArray2);
            messageDigest.update(byArray4);
        }

        int messageLength() {
            return 2 + this.signature.length;
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.signature);
        }

        void print(PrintStream printStream) throws IOException {
            printStream.println("*** CertificateVerify");
        }
    }

    static final class ClientHello
    extends HandshakeMessage {
        ProtocolVersion protocolVersion;
        RandomCookie clnt_random;
        SessionId sessionId;
        CipherSuiteList cipherSuites;
        byte[] compression_methods;
        private static final byte[] NULL_COMPRESSION = new byte[]{0};

        int messageType() {
            return 1;
        }

        ClientHello(SecureRandom secureRandom, ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            this.clnt_random = new RandomCookie(secureRandom);
            this.compression_methods = NULL_COMPRESSION;
        }

        int messageLength() {
            return 38 + this.sessionId.length() + this.cipherSuites.size() * 2 + this.compression_methods.length;
        }

        ClientHello(HandshakeInStream handshakeInStream) throws IOException {
            this.protocolVersion = ProtocolVersion.valueOf(handshakeInStream.getInt8(), handshakeInStream.getInt8());
            this.clnt_random = new RandomCookie(handshakeInStream);
            this.sessionId = new SessionId(handshakeInStream.getBytes8());
            this.cipherSuites = new CipherSuiteList(handshakeInStream);
            this.compression_methods = handshakeInStream.getBytes8();
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(this.protocolVersion.major);
            handshakeOutStream.putInt8(this.protocolVersion.minor);
            this.clnt_random.send(handshakeOutStream);
            handshakeOutStream.putBytes8(this.sessionId.getId());
            this.cipherSuites.send(handshakeOutStream);
            handshakeOutStream.putBytes8(this.compression_methods);
        }

        void print(PrintStream printStream) throws IOException {
            printStream.println("*** ClientHello, " + this.protocolVersion);
            if (debug != null && Debug.isOn("verbose")) {
                printStream.print("RandomCookie:  ");
                this.clnt_random.print(printStream);
                printStream.print("Session ID:  ");
                printStream.println(this.sessionId);
                printStream.println("Cipher Suites: " + this.cipherSuites);
                Debug.println(printStream, "Compression Methods", this.compression_methods);
                printStream.println("***");
            }
        }
    }

    static final class DH_ServerKeyExchange
    extends ServerKeyExchange {
        private static final boolean dhKeyExchangeFix = Debug.getBooleanProperty("com.sun.net.ssl.dhKeyExchangeFix", true);
        private byte[] dh_p;
        private byte[] dh_g;
        private byte[] dh_Ys;
        private byte[] signature;

        public BigInteger getModulus() {
            return new BigInteger(1, this.dh_p);
        }

        public BigInteger getBase() {
            return new BigInteger(1, this.dh_g);
        }

        public BigInteger getServerPublicKey() {
            return new BigInteger(1, this.dh_Ys);
        }

        private void updateSignature(Signature signature, byte[] byArray, byte[] byArray2) throws SignatureException {
            signature.update(byArray);
            signature.update(byArray2);
            int n = this.dh_p.length;
            signature.update((byte)(n >> 8));
            signature.update((byte)(n & 0xFF));
            signature.update(this.dh_p);
            n = this.dh_g.length;
            signature.update((byte)(n >> 8));
            signature.update((byte)(n & 0xFF));
            signature.update(this.dh_g);
            n = this.dh_Ys.length;
            signature.update((byte)(n >> 8));
            signature.update((byte)(n & 0xFF));
            signature.update(this.dh_Ys);
        }

        DH_ServerKeyExchange(DHKeyExchange dHKeyExchange) {
            this.getValues(dHKeyExchange);
            this.signature = null;
        }

        DH_ServerKeyExchange(DHKeyExchange dHKeyExchange, PrivateKey privateKey, byte[] byArray, byte[] byArray2, SecureRandom secureRandom) throws GeneralSecurityException {
            this.getValues(dHKeyExchange);
            Signature signature = privateKey.getAlgorithm().equals("DSA") ? JsseJce.getSignature("DSA") : RSASignature.getInstance();
            signature.initSign(privateKey, secureRandom);
            this.updateSignature(signature, byArray, byArray2);
            this.signature = signature.sign();
        }

        private void getValues(DHKeyExchange dHKeyExchange) {
            this.dh_p = DH_ServerKeyExchange.toByteArray(dHKeyExchange.getModulus());
            this.dh_g = DH_ServerKeyExchange.toByteArray(dHKeyExchange.getBase());
            this.dh_Ys = DH_ServerKeyExchange.toByteArray(dHKeyExchange.getPublicKey());
        }

        DH_ServerKeyExchange(HandshakeInStream handshakeInStream) throws IOException {
            this.dh_p = handshakeInStream.getBytes16();
            this.dh_g = handshakeInStream.getBytes16();
            this.dh_Ys = handshakeInStream.getBytes16();
            this.signature = null;
        }

        DH_ServerKeyExchange(HandshakeInStream handshakeInStream, PublicKey publicKey, byte[] byArray, byte[] byArray2, int n) throws IOException, GeneralSecurityException {
            Signature signature;
            byte[] byArray3;
            this.dh_p = handshakeInStream.getBytes16();
            this.dh_g = handshakeInStream.getBytes16();
            this.dh_Ys = handshakeInStream.getBytes16();
            if (dhKeyExchangeFix) {
                byArray3 = handshakeInStream.getBytes16();
            } else {
                n -= this.dh_p.length + 2;
                n -= this.dh_g.length + 2;
                byArray3 = new byte[n -= this.dh_Ys.length + 2];
                handshakeInStream.read(byArray3);
            }
            String string = publicKey.getAlgorithm();
            if (string.equals("DSA")) {
                signature = JsseJce.getSignature("DSA");
            } else if (string.equals("RSA")) {
                signature = RSASignature.getInstance();
            } else {
                throw new SSLKeyException("neither an RSA or a DSA key");
            }
            signature.initVerify(publicKey);
            this.updateSignature(signature, byArray, byArray2);
            if (!signature.verify(byArray3)) {
                throw new SSLKeyException("Server D-H key verification failed");
            }
        }

        int messageLength() {
            int n = 6;
            n += this.dh_p.length;
            n += this.dh_g.length;
            n += this.dh_Ys.length;
            if (this.signature != null) {
                n += this.signature.length;
                if (dhKeyExchangeFix) {
                    n += 2;
                }
            }
            return n;
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.dh_p);
            handshakeOutStream.putBytes16(this.dh_g);
            handshakeOutStream.putBytes16(this.dh_Ys);
            if (this.signature != null) {
                if (dhKeyExchangeFix) {
                    handshakeOutStream.putBytes16(this.signature);
                } else {
                    handshakeOutStream.write(this.signature);
                }
            }
        }

        void print(PrintStream printStream) throws IOException {
            printStream.println("*** Diffie-Hellman ServerKeyExchange");
            if (debug != null && Debug.isOn("verbose")) {
                Debug.println(printStream, "DH Modulus", this.dh_p);
                Debug.println(printStream, "DH Base", this.dh_g);
                Debug.println(printStream, "Server DH Public Key", this.dh_Ys);
                if (this.signature == null) {
                    printStream.println("Anonymous");
                } else {
                    printStream.println("Signed with a DSA or RSA public key");
                }
            }
        }
    }

    static final class DistinguishedName {
        byte[] name;

        DistinguishedName(HandshakeInStream handshakeInStream) throws IOException {
            this.name = handshakeInStream.getBytes16();
        }

        DistinguishedName(X500Principal x500Principal) {
            this.name = x500Principal.getEncoded();
        }

        X500Principal getX500Principal() throws IOException {
            try {
                return new X500Principal(this.name);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw (SSLProtocolException)new SSLProtocolException(illegalArgumentException.getMessage()).initCause(illegalArgumentException);
            }
        }

        int length() {
            return 2 + this.name.length;
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.name);
        }

        void print(PrintStream printStream) throws IOException {
            X500Principal x500Principal = new X500Principal(this.name);
            printStream.println("<" + x500Principal.toString() + ">");
        }
    }

    static final class Finished
    extends HandshakeMessage {
        static final int CLIENT = 1;
        static final int SERVER = 2;
        private static final byte[] SSL_CLIENT = new byte[]{67, 76, 78, 84};
        private static final byte[] SSL_SERVER = new byte[]{83, 82, 86, 82};
        private byte[] verifyData;

        int messageType() {
            return 20;
        }

        Finished(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, int n, byte[] byArray) {
            this.verifyData = Finished.getFinished(protocolVersion, handshakeHash, n, byArray);
        }

        Finished(ProtocolVersion protocolVersion, HandshakeInStream handshakeInStream) throws IOException {
            int n = protocolVersion.v >= ProtocolVersion.TLS10.v ? 12 : 36;
            this.verifyData = new byte[n];
            handshakeInStream.read(this.verifyData);
        }

        boolean verify(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, int n, byte[] byArray) {
            byte[] byArray2 = Finished.getFinished(protocolVersion, handshakeHash, n, byArray);
            return Arrays.equals(byArray2, this.verifyData);
        }

        private static byte[] getFinished(ProtocolVersion protocolVersion, HandshakeHash handshakeHash, int n, byte[] byArray) {
            byte[] byArray2;
            byte[] byArray3;
            if (n == 1) {
                byArray3 = SSL_CLIENT;
                byArray2 = PRF.LABEL_CLIENT_FINISHED;
            } else if (n == 2) {
                byArray3 = SSL_SERVER;
                byArray2 = PRF.LABEL_SERVER_FINISHED;
            } else {
                throw new RuntimeException("Invalid sender: " + n);
            }
            MessageDigest messageDigest = handshakeHash.getMD5Clone();
            MessageDigest messageDigest2 = handshakeHash.getSHAClone();
            if (protocolVersion.v >= ProtocolVersion.TLS10.v) {
                byte[] byArray4 = new byte[12];
                byte[] byArray5 = messageDigest.digest();
                byte[] byArray6 = messageDigest2.digest();
                PRF.compute(messageDigest, messageDigest2, byArray, byArray2, byArray5, byArray6, byArray4);
                return byArray4;
            }
            Finished.updateDigest(messageDigest, byArray3, MAC.MD5_pad1, MAC.MD5_pad2, byArray);
            Finished.updateDigest(messageDigest2, byArray3, MAC.SHA_pad1, MAC.SHA_pad2, byArray);
            byte[] byArray7 = new byte[36];
            try {
                messageDigest.digest(byArray7, 0, 16);
                messageDigest2.digest(byArray7, 16, 20);
            }
            catch (DigestException digestException) {
                throw new RuntimeException("Digest failed", digestException);
            }
            return byArray7;
        }

        private static void updateDigest(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
            messageDigest.update(byArray);
            CertificateVerify.updateDigest(messageDigest, byArray2, byArray3, byArray4);
        }

        int messageLength() {
            return this.verifyData.length;
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.write(this.verifyData);
        }

        void print(PrintStream printStream) throws IOException {
            printStream.println("*** Finished");
            if (debug != null && Debug.isOn("verbose")) {
                Debug.println(printStream, "verify_data", this.verifyData);
                printStream.println("***");
            }
        }
    }

    static final class HelloRequest
    extends HandshakeMessage {
        int messageType() {
            return 0;
        }

        HelloRequest() {
        }

        HelloRequest(HandshakeInStream handshakeInStream) throws IOException {
        }

        int messageLength() {
            return 0;
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
        }

        void print(PrintStream printStream) throws IOException {
            printStream.println("*** HelloRequest (empty)");
        }
    }

    static final class RSA_ServerKeyExchange
    extends ServerKeyExchange {
        private byte[] rsa_modulus;
        private byte[] rsa_exponent;
        private Signature signature;
        private byte[] signatureBytes;

        private void updateSignature(byte[] byArray, byte[] byArray2) throws SignatureException {
            this.signature.update(byArray);
            this.signature.update(byArray2);
            int n = this.rsa_modulus.length;
            this.signature.update((byte)(n >> 8));
            this.signature.update((byte)(n & 0xFF));
            this.signature.update(this.rsa_modulus);
            n = this.rsa_exponent.length;
            this.signature.update((byte)(n >> 8));
            this.signature.update((byte)(n & 0xFF));
            this.signature.update(this.rsa_exponent);
        }

        RSA_ServerKeyExchange(PublicKey publicKey, PrivateKey privateKey, RandomCookie randomCookie, RandomCookie randomCookie2, SecureRandom secureRandom) throws GeneralSecurityException {
            RSAPublicKeySpec rSAPublicKeySpec = JsseJce.getRSAPublicKeySpec(publicKey);
            this.rsa_modulus = RSA_ServerKeyExchange.toByteArray(rSAPublicKeySpec.getModulus());
            this.rsa_exponent = RSA_ServerKeyExchange.toByteArray(rSAPublicKeySpec.getPublicExponent());
            this.signature = RSASignature.getInstance();
            this.signature.initSign(privateKey, secureRandom);
            this.updateSignature(randomCookie.random_bytes, randomCookie2.random_bytes);
            this.signatureBytes = this.signature.sign();
        }

        RSA_ServerKeyExchange(HandshakeInStream handshakeInStream, int n) throws IOException, NoSuchAlgorithmException {
            this.signature = RSASignature.getInstance();
            this.rsa_modulus = handshakeInStream.getBytes16();
            this.rsa_exponent = handshakeInStream.getBytes16();
            this.signatureBytes = handshakeInStream.getBytes16();
        }

        PublicKey getPublicKey() {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(1, this.rsa_modulus), new BigInteger(1, this.rsa_exponent));
                return keyFactory.generatePublic(rSAPublicKeySpec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        boolean verify(PublicKey publicKey, RandomCookie randomCookie, RandomCookie randomCookie2) throws GeneralSecurityException {
            this.signature.initVerify(publicKey);
            this.updateSignature(randomCookie.random_bytes, randomCookie2.random_bytes);
            return this.signature.verify(this.signatureBytes);
        }

        int messageLength() {
            return 6 + this.rsa_modulus.length + this.rsa_exponent.length + this.signatureBytes.length;
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.rsa_modulus);
            handshakeOutStream.putBytes16(this.rsa_exponent);
            handshakeOutStream.putBytes16(this.signatureBytes);
        }

        void print(PrintStream printStream) throws IOException {
            printStream.println("*** RSA ServerKeyExchange");
            if (debug != null && Debug.isOn("verbose")) {
                Debug.println(printStream, "RSA Modulus", this.rsa_modulus);
                Debug.println(printStream, "RSA Public Exponent", this.rsa_exponent);
            }
        }
    }

    static final class ServerHello
    extends HandshakeMessage {
        ProtocolVersion protocolVersion;
        RandomCookie svr_random;
        SessionId sessionId;
        CipherSuite cipherSuite;
        byte compression_method;

        int messageType() {
            return 2;
        }

        ServerHello() {
        }

        ServerHello(HandshakeInStream handshakeInStream) throws IOException {
            this.protocolVersion = ProtocolVersion.valueOf(handshakeInStream.getInt8(), handshakeInStream.getInt8());
            this.svr_random = new RandomCookie(handshakeInStream);
            this.sessionId = new SessionId(handshakeInStream.getBytes8());
            this.cipherSuite = CipherSuite.valueOf(handshakeInStream.getInt8(), handshakeInStream.getInt8());
            this.compression_method = (byte)handshakeInStream.getInt8();
        }

        int messageLength() {
            return 38 + this.sessionId.length();
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putInt8(this.protocolVersion.major);
            handshakeOutStream.putInt8(this.protocolVersion.minor);
            this.svr_random.send(handshakeOutStream);
            handshakeOutStream.putBytes8(this.sessionId.getId());
            handshakeOutStream.putInt8(this.cipherSuite.id >> 8);
            handshakeOutStream.putInt8(this.cipherSuite.id & 0xFF);
            handshakeOutStream.putInt8(this.compression_method);
        }

        void print(PrintStream printStream) throws IOException {
            printStream.println("*** ServerHello, " + this.protocolVersion);
            if (debug != null && Debug.isOn("verbose")) {
                printStream.print("RandomCookie:  ");
                this.svr_random.print(printStream);
                printStream.print("Session ID:  ");
                printStream.println(this.sessionId);
                printStream.println("Cipher Suite: " + this.cipherSuite);
                printStream.println("Compression Method: " + this.compression_method);
                printStream.println("***");
            }
        }
    }

    static final class ServerHelloDone
    extends HandshakeMessage {
        int messageType() {
            return 14;
        }

        ServerHelloDone() {
        }

        ServerHelloDone(HandshakeInStream handshakeInStream) {
        }

        int messageLength() {
            return 0;
        }

        void send(HandshakeOutStream handshakeOutStream) throws IOException {
        }

        void print(PrintStream printStream) throws IOException {
            printStream.println("*** ServerHelloDone");
        }
    }

    static abstract class ServerKeyExchange
    extends HandshakeMessage {
        ServerKeyExchange() {
        }

        int messageType() {
            return 12;
        }
    }
}

