/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;
import java.text.BreakIterator;
import java.util.Enumeration;
import java.util.Vector;

public class TextWrapper
implements Serializable {
    private static final long serialVersionUID = 200L;
    int alignment;
    FontMetrics fontMetrics;
    BreakIterator textBoundary;
    Font font;
    String[] lines;
    int[] length;
    String text;
    int hintWidth;
    int lineCount;
    int charHeight;
    int maxAscent;
    Dimension size;

    TextWrapper(Font font, String text, int alignment, int hintWidth) {
        this.alignment = alignment;
        this.font = font;
        this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        this.textBoundary = BreakIterator.getWordInstance();
        this.text = text;
        this.hintWidth = hintWidth;
        this.charHeight = this.fontMetrics.getHeight();
        this.maxAscent = this.fontMetrics.getMaxAscent();
    }

    public Dimension getSize(Graphics g2) {
        if (this.size == null) {
            this.calcSize(g2);
        }
        return this.size;
    }

    protected void calcSize(Graphics g2) {
        Vector<String> words = new Vector<String>();
        this.textBoundary.setText(this.text);
        int start = this.textBoundary.first();
        int end = this.textBoundary.next();
        while (end != -1) {
            words.addElement(this.text.substring(start, end));
            start = end;
            end = this.textBoundary.next();
        }
        this.lines = new String[words.size()];
        this.length = new int[words.size()];
        this.lineCount = 0;
        boolean l = false;
        int curLine = 0;
        int width = 0;
        int height = 0;
        Enumeration enumerator = words.elements();
        while (enumerator.hasMoreElements()) {
            boolean isLF;
            String w = (String)enumerator.nextElement();
            int wl = this.fontMetrics.stringWidth(w);
            int newLength = this.length[curLine] + wl;
            boolean isCR = w.charAt(0) == '\r';
            boolean bl = isLF = w.charAt(0) == '\n';
            if (isCR) continue;
            if (!isLF && newLength <= this.hintWidth) {
                if (this.lines[curLine] == null) {
                    this.lines[curLine] = w;
                    this.length[curLine] = wl;
                    l = false;
                    ++this.lineCount;
                    height += this.charHeight;
                    if (newLength <= width) continue;
                    width = newLength;
                    continue;
                }
                this.lines[curLine] = String.valueOf(String.valueOf(this.lines[curLine])).concat(String.valueOf(String.valueOf(w)));
                this.length[curLine] = newLength;
                if (newLength <= width) continue;
                width = newLength;
                continue;
            }
            if (isLF) {
                wl = 0;
                w = w.substring(1);
            }
            if (wl > width) {
                width = wl;
            }
            if (this.length[curLine] == 0) {
                this.lines[curLine] = w;
                this.length[curLine] = wl;
                ++this.lineCount;
                ++curLine;
            } else {
                ++this.lineCount;
                this.lines[++curLine] = w;
                this.length[curLine] = wl;
            }
            l = false;
            height += this.charHeight;
        }
        this.size = new Dimension(width, height);
    }

    public void paint(Graphics g2, int x, int y, int maxWidth, int maxHeight) {
        int stop = y + maxHeight + this.charHeight;
        int hAlign = this.alignment & 0xF;
        int vAlign = this.alignment & 0xF0;
        y -= this.charHeight - this.maxAscent;
        switch (vAlign) {
            case 32: {
                y += (maxHeight - this.lineCount * this.charHeight) / 2;
                break;
            }
            case 48: {
                y += maxHeight - this.lineCount * this.charHeight;
            }
        }
        for (int i2 = 0; i2 < this.lineCount; ++i2) {
            int dx = 0;
            switch (hAlign) {
                case 2: {
                    dx = (maxWidth - this.length[i2]) / 2;
                    break;
                }
                case 3: {
                    dx = maxWidth - this.length[i2];
                }
            }
            if (this.lines[i2] != null) {
                g2.drawString(this.lines[i2], x + dx, y + this.charHeight);
            }
            if ((y += this.charHeight) <= stop) continue;
            return;
        }
    }

    static {
        serialVersionUID = 200L;
    }
}

