/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthArrowButton;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthSplitPaneUI;
import sun.swing.DefaultLookup;

class SynthSplitPaneDivider
extends BasicSplitPaneDivider {
    public SynthSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        super(basicSplitPaneUI);
    }

    protected void setMouseOver(boolean bl2) {
        if (this.isMouseOver() != bl2) {
            this.repaint();
        }
        super.setMouseOver(bl2);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        if (propertyChangeEvent.getSource() == this.splitPane && propertyChangeEvent.getPropertyName() == "orientation") {
            if (this.leftButton instanceof SynthArrowButton) {
                ((SynthArrowButton)this.leftButton).setDirection(this.mapDirection(true));
            }
            if (this.rightButton instanceof SynthArrowButton) {
                ((SynthArrowButton)this.rightButton).setDirection(this.mapDirection(false));
            }
        }
    }

    public void paint(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        SynthContext synthContext = ((SynthSplitPaneUI)this.splitPaneUI).getContext((JComponent)this.splitPane, Region.SPLIT_PANE_DIVIDER);
        Rectangle rectangle = this.getBounds();
        rectangle.y = 0;
        rectangle.x = 0;
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
        synthContext.getPainter().paintSplitPaneDividerBackground(synthContext, graphics, 0, 0, rectangle.width, rectangle.height);
        Object var5_5 = null;
        synthContext.getPainter().paintSplitPaneDividerForeground(synthContext, graphics, 0, 0, this.getWidth(), this.getHeight(), this.splitPane.getOrientation());
        synthContext.dispose();
        for (int i2 = 0; i2 < this.getComponentCount(); ++i2) {
            Component component = this.getComponent(i2);
            Rectangle rectangle2 = component.getBounds();
            Graphics graphics3 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            component.paint(graphics3);
            graphics3.dispose();
        }
        graphics2.dispose();
    }

    private int mapDirection(boolean bl2) {
        if (bl2) {
            if (this.splitPane.getOrientation() == 1) {
                return 7;
            }
            return 1;
        }
        if (this.splitPane.getOrientation() == 1) {
            return 3;
        }
        return 5;
    }

    protected JButton createLeftOneTouchButton() {
        SynthArrowButton synthArrowButton = new SynthArrowButton(1);
        int n2 = this.lookupOneTouchSize();
        synthArrowButton.setName("SplitPaneDivider.leftOneTouchButton");
        synthArrowButton.setMinimumSize(new Dimension(n2, n2));
        synthArrowButton.setCursor(Cursor.getPredefinedCursor(0));
        synthArrowButton.setFocusPainted(false);
        synthArrowButton.setBorderPainted(false);
        synthArrowButton.setRequestFocusEnabled(false);
        synthArrowButton.setDirection(this.mapDirection(true));
        return synthArrowButton;
    }

    private int lookupOneTouchSize() {
        return DefaultLookup.getInt(this.splitPaneUI.getSplitPane(), this.splitPaneUI, "SplitPaneDivider.oneTouchButtonSize", 6);
    }

    protected JButton createRightOneTouchButton() {
        SynthArrowButton synthArrowButton = new SynthArrowButton(1);
        int n2 = this.lookupOneTouchSize();
        synthArrowButton.setName("SplitPaneDivider.rightOneTouchButton");
        synthArrowButton.setMinimumSize(new Dimension(n2, n2));
        synthArrowButton.setCursor(Cursor.getPredefinedCursor(0));
        synthArrowButton.setFocusPainted(false);
        synthArrowButton.setBorderPainted(false);
        synthArrowButton.setRequestFocusEnabled(false);
        synthArrowButton.setDirection(this.mapDirection(false));
        return synthArrowButton;
    }
}

