/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandomSpi;
import java.util.List;
import java.util.Random;
import sun.security.jca.GetInstance;
import sun.security.jca.Providers;
import sun.security.provider.Sun;

public class SecureRandom
extends Random {
    private Provider provider = null;
    private SecureRandomSpi secureRandomSpi = null;
    private String algorithm;
    private static SecureRandom seedGenerator = null;
    static final long serialVersionUID = 4940670005562187L;
    private byte[] state;
    private MessageDigest digest = null;
    private byte[] randomBytes;
    private int randomBytesUsed;
    private long counter;

    public SecureRandom() {
        super(0L);
        this.getDefaultPRNG(false, null);
    }

    public SecureRandom(byte[] byArray) {
        super(0L);
        this.getDefaultPRNG(true, byArray);
    }

    private void getDefaultPRNG(boolean bl2, byte[] byArray) {
        String string = SecureRandom.getPrngAlgorithm();
        if (string == null) {
            string = "SHA1PRNG";
            this.secureRandomSpi = new sun.security.provider.SecureRandom();
            this.provider = new Sun();
            if (bl2) {
                this.secureRandomSpi.engineSetSeed(byArray);
            }
        } else {
            try {
                SecureRandom secureRandom = SecureRandom.getInstance(string);
                this.secureRandomSpi = secureRandom.getSecureRandomSpi();
                this.provider = secureRandom.getProvider();
                if (bl2) {
                    this.secureRandomSpi.engineSetSeed(byArray);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        if (this.getClass() == SecureRandom.class) {
            this.algorithm = string;
        }
    }

    protected SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider) {
        this(secureRandomSpi, provider, null);
    }

    private SecureRandom(SecureRandomSpi secureRandomSpi, Provider provider, String string) {
        super(0L);
        this.secureRandomSpi = secureRandomSpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static SecureRandom getInstance(String string) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("SecureRandom", SecureRandomSpi.class, string);
        return new SecureRandom((SecureRandomSpi)instance.impl, instance.provider, string);
    }

    public static SecureRandom getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        GetInstance.Instance instance = GetInstance.getInstance("SecureRandom", SecureRandomSpi.class, string, string2);
        return new SecureRandom((SecureRandomSpi)instance.impl, instance.provider, string);
    }

    public static SecureRandom getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        GetInstance.Instance instance = GetInstance.getInstance("SecureRandom", SecureRandomSpi.class, string, provider);
        return new SecureRandom((SecureRandomSpi)instance.impl, instance.provider, string);
    }

    SecureRandomSpi getSecureRandomSpi() {
        return this.secureRandomSpi;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public String getAlgorithm() {
        return this.algorithm != null ? this.algorithm : "unknown";
    }

    public synchronized void setSeed(byte[] byArray) {
        this.secureRandomSpi.engineSetSeed(byArray);
    }

    public void setSeed(long l2) {
        if (l2 != 0L) {
            this.secureRandomSpi.engineSetSeed(SecureRandom.longToByteArray(l2));
        }
    }

    public synchronized void nextBytes(byte[] byArray) {
        this.secureRandomSpi.engineNextBytes(byArray);
    }

    protected final int next(int n2) {
        int n3 = (n2 + 7) / 8;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        this.nextBytes(byArray);
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 = (n4 << 8) + (byArray[i2] & 0xFF);
        }
        return n4 >>> n3 * 8 - n2;
    }

    public static byte[] getSeed(int n2) {
        if (seedGenerator == null) {
            seedGenerator = new SecureRandom();
        }
        return seedGenerator.generateSeed(n2);
    }

    public byte[] generateSeed(int n2) {
        return this.secureRandomSpi.engineGenerateSeed(n2);
    }

    private static byte[] longToByteArray(long l2) {
        byte[] byArray = new byte[8];
        for (int i2 = 0; i2 < 8; ++i2) {
            byArray[i2] = (byte)l2;
            l2 >>= 8;
        }
        return byArray;
    }

    private static String getPrngAlgorithm() {
        List<Provider> list = Providers.getProviderList().providers();
        for (Provider provider : list) {
            for (Provider.Service service : provider.getServices()) {
                if (!service.getType().equals("SecureRandom")) continue;
                return service.getAlgorithm();
            }
        }
        return null;
    }
}

