/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.CharBuffer;

public abstract class Reader
implements Readable,
Closeable {
    protected Object lock;
    private static final int maxSkipBufferSize = 8192;
    private char[] skipBuffer = null;

    protected Reader() {
        this.lock = this;
    }

    protected Reader(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        this.lock = object;
    }

    public int read(CharBuffer charBuffer) throws IOException {
        int n2 = charBuffer.remaining();
        char[] cArray = new char[n2];
        int n3 = this.read(cArray, 0, n2);
        if (n3 > 0) {
            charBuffer.put(cArray, 0, n3);
        }
        return n3;
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        if (this.read(cArray, 0, 1) == -1) {
            return -1;
        }
        return cArray[0];
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public abstract int read(char[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long skip(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        int n2 = (int)Math.min(l2, 8192L);
        Object object = this.lock;
        synchronized (object) {
            long l3;
            int n3;
            if (this.skipBuffer == null || this.skipBuffer.length < n2) {
                this.skipBuffer = new char[n2];
            }
            for (l3 = l2; l3 > 0L && (n3 = this.read(this.skipBuffer, 0, (int)Math.min(l3, (long)n2))) != -1; l3 -= (long)n3) {
            }
            return l2 - l3;
        }
    }

    public boolean ready() throws IOException {
        return false;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n2) throws IOException {
        throw new IOException("mark() not supported");
    }

    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    public abstract void close() throws IOException;
}

