/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.PackedColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;

public class DirectColorModel
extends PackedColorModel {
    private int red_mask;
    private int green_mask;
    private int blue_mask;
    private int alpha_mask;
    private int red_offset;
    private int green_offset;
    private int blue_offset;
    private int alpha_offset;
    private int red_scale;
    private int green_scale;
    private int blue_scale;
    private int alpha_scale;
    private boolean is_LinearRGB;
    private int lRGBprecision;
    private byte[] tosRGB8LUT;
    private byte[] fromsRGB8LUT8;
    private short[] fromsRGB8LUT16;

    public DirectColorModel(int n2, int n3, int n4, int n5) {
        this(n2, n3, n4, n5, 0);
    }

    public DirectColorModel(int n2, int n3, int n4, int n5, int n6) {
        super(ColorSpace.getInstance(1000), n2, n3, n4, n5, n6, false, n6 == 0 ? 1 : 3, ColorModel.getDefaultTransferType(n2));
        this.setFields();
    }

    public DirectColorModel(ColorSpace colorSpace, int n2, int n3, int n4, int n5, int n6, boolean bl2, int n7) {
        super(colorSpace, n2, n3, n4, n5, n6, bl2, n6 == 0 ? 1 : 3, n7);
        if (ColorModel.isLinearRGBspace(this.colorSpace)) {
            this.is_LinearRGB = true;
            if (this.maxBits <= 8) {
                this.lRGBprecision = 8;
                this.tosRGB8LUT = ColorModel.getLinearRGB8TosRGB8LUT();
                this.fromsRGB8LUT8 = ColorModel.getsRGB8ToLinearRGB8LUT();
            } else {
                this.lRGBprecision = 16;
                this.tosRGB8LUT = ColorModel.getLinearRGB16TosRGB8LUT();
                this.fromsRGB8LUT16 = ColorModel.getsRGB8ToLinearRGB16LUT();
            }
        } else if (!this.is_sRGB) {
            for (int i2 = 0; i2 < 3; ++i2) {
                if (colorSpace.getMinValue(i2) == 0.0f && colorSpace.getMaxValue(i2) == 1.0f) continue;
                throw new IllegalArgumentException("Illegal min/max RGB component value");
            }
        }
        this.setFields();
    }

    public final int getRedMask() {
        return this.maskArray[0];
    }

    public final int getGreenMask() {
        return this.maskArray[1];
    }

    public final int getBlueMask() {
        return this.maskArray[2];
    }

    public final int getAlphaMask() {
        if (this.supportsAlpha) {
            return this.maskArray[3];
        }
        return 0;
    }

    private float[] getDefaultRGBComponents(int n2) {
        int[] nArray = this.getComponents(n2, (int[])null, 0);
        float[] fArray = this.getNormalizedComponents(nArray, 0, null, 0);
        return this.colorSpace.toRGB(fArray);
    }

    private int getsRGBComponentFromsRGB(int n2, int n3) {
        int n4 = (n2 & this.maskArray[n3]) >>> this.maskOffsets[n3];
        if (this.isAlphaPremultiplied) {
            int n5 = (n2 & this.maskArray[3]) >>> this.maskOffsets[3];
            n4 = n5 == 0 ? 0 : (int)((float)n4 * this.scaleFactors[n3] * 255.0f / ((float)n5 * this.scaleFactors[3]) + 0.5f);
        } else if (this.scaleFactors[n3] != 1.0f) {
            n4 = (int)((float)n4 * this.scaleFactors[n3] + 0.5f);
        }
        return n4;
    }

    private int getsRGBComponentFromLinearRGB(int n2, int n3) {
        int n4 = (n2 & this.maskArray[n3]) >>> this.maskOffsets[n3];
        if (this.isAlphaPremultiplied) {
            float f2 = (1 << this.lRGBprecision) - 1;
            int n5 = (n2 & this.maskArray[3]) >>> this.maskOffsets[3];
            n4 = n5 == 0 ? 0 : (int)((float)n4 * this.scaleFactors[n3] * f2 / ((float)n5 * this.scaleFactors[3]) + 0.5f);
        } else if (this.nBits[n3] != this.lRGBprecision) {
            n4 = this.lRGBprecision == 16 ? (int)((float)n4 * this.scaleFactors[n3] * 257.0f + 0.5f) : (int)((float)n4 * this.scaleFactors[n3] + 0.5f);
        }
        return this.tosRGB8LUT[n4] & 0xFF;
    }

    public final int getRed(int n2) {
        if (this.is_sRGB) {
            return this.getsRGBComponentFromsRGB(n2, 0);
        }
        if (this.is_LinearRGB) {
            return this.getsRGBComponentFromLinearRGB(n2, 0);
        }
        float[] fArray = this.getDefaultRGBComponents(n2);
        return (int)(fArray[0] * 255.0f + 0.5f);
    }

    public final int getGreen(int n2) {
        if (this.is_sRGB) {
            return this.getsRGBComponentFromsRGB(n2, 1);
        }
        if (this.is_LinearRGB) {
            return this.getsRGBComponentFromLinearRGB(n2, 1);
        }
        float[] fArray = this.getDefaultRGBComponents(n2);
        return (int)(fArray[1] * 255.0f + 0.5f);
    }

    public final int getBlue(int n2) {
        if (this.is_sRGB) {
            return this.getsRGBComponentFromsRGB(n2, 2);
        }
        if (this.is_LinearRGB) {
            return this.getsRGBComponentFromLinearRGB(n2, 2);
        }
        float[] fArray = this.getDefaultRGBComponents(n2);
        return (int)(fArray[2] * 255.0f + 0.5f);
    }

    public final int getAlpha(int n2) {
        if (!this.supportsAlpha) {
            return 255;
        }
        int n3 = (n2 & this.maskArray[3]) >>> this.maskOffsets[3];
        if (this.scaleFactors[3] != 1.0f) {
            n3 = (int)((float)n3 * this.scaleFactors[3] + 0.5f);
        }
        return n3;
    }

    public final int getRGB(int n2) {
        if (this.is_sRGB || this.is_LinearRGB) {
            return this.getAlpha(n2) << 24 | this.getRed(n2) << 16 | this.getGreen(n2) << 8 | this.getBlue(n2) << 0;
        }
        float[] fArray = this.getDefaultRGBComponents(n2);
        return this.getAlpha(n2) << 24 | (int)(fArray[0] * 255.0f + 0.5f) << 16 | (int)(fArray[1] * 255.0f + 0.5f) << 8 | (int)(fArray[2] * 255.0f + 0.5f) << 0;
    }

    public int getRed(Object object) {
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n2 = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getRed(n2);
    }

    public int getGreen(Object object) {
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n2 = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getGreen(n2);
    }

    public int getBlue(Object object) {
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n2 = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getBlue(n2);
    }

    public int getAlpha(Object object) {
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n2 = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getAlpha(n2);
    }

    public int getRGB(Object object) {
        int n2 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n2 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n2 = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n2 = nArray[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getRGB(n2);
    }

    public Object getDataElements(int n2, Object object) {
        int[] nArray = null;
        if (this.transferType == 3 && object != null) {
            nArray = (int[])object;
            nArray[0] = 0;
        } else {
            nArray = new int[1];
        }
        ColorModel colorModel = ColorModel.getRGBdefault();
        if (this == colorModel || this.equals(colorModel)) {
            nArray[0] = n2;
            return nArray;
        }
        int n3 = n2 >> 16 & 0xFF;
        int n4 = n2 >> 8 & 0xFF;
        int n5 = n2 & 0xFF;
        if (this.is_sRGB || this.is_LinearRGB) {
            float f2;
            int n6;
            if (this.is_LinearRGB) {
                if (this.lRGBprecision == 8) {
                    n3 = this.fromsRGB8LUT8[n3] & 0xFF;
                    n4 = this.fromsRGB8LUT8[n4] & 0xFF;
                    n5 = this.fromsRGB8LUT8[n5] & 0xFF;
                    n6 = 8;
                    f2 = 0.003921569f;
                } else {
                    n3 = this.fromsRGB8LUT16[n3] & 0xFFFF;
                    n4 = this.fromsRGB8LUT16[n4] & 0xFFFF;
                    n5 = this.fromsRGB8LUT16[n5] & 0xFFFF;
                    n6 = 16;
                    f2 = 1.5259022E-5f;
                }
            } else {
                n6 = 8;
                f2 = 0.003921569f;
            }
            if (this.supportsAlpha) {
                int n7 = n2 >> 24 & 0xFF;
                if (this.isAlphaPremultiplied) {
                    f2 *= (float)n7 * 0.003921569f;
                    n6 = -1;
                }
                if (this.nBits[3] != 8 && (n7 = (int)((float)n7 * 0.003921569f * (float)((1 << this.nBits[3]) - 1) + 0.5f)) > (1 << this.nBits[3]) - 1) {
                    n7 = (1 << this.nBits[3]) - 1;
                }
                nArray[0] = n7 << this.maskOffsets[3];
            }
            if (this.nBits[0] != n6) {
                n3 = (int)((float)n3 * f2 * (float)((1 << this.nBits[0]) - 1) + 0.5f);
            }
            if (this.nBits[1] != n6) {
                n4 = (int)((float)n4 * f2 * (float)((1 << this.nBits[1]) - 1) + 0.5f);
            }
            if (this.nBits[2] != n6) {
                n5 = (int)((float)n5 * f2 * (float)((1 << this.nBits[2]) - 1) + 0.5f);
            }
        } else {
            float[] fArray = new float[3];
            float f3 = 0.003921569f;
            fArray[0] = (float)n3 * f3;
            fArray[1] = (float)n4 * f3;
            fArray[2] = (float)n5 * f3;
            fArray = this.colorSpace.fromRGB(fArray);
            if (this.supportsAlpha) {
                int n8 = n2 >> 24 & 0xFF;
                if (this.isAlphaPremultiplied) {
                    f3 *= (float)n8;
                    int n9 = 0;
                    while (n9 < 3) {
                        int n10 = n9++;
                        fArray[n10] = fArray[n10] * f3;
                    }
                }
                if (this.nBits[3] != 8 && (n8 = (int)((float)n8 * 0.003921569f * (float)((1 << this.nBits[3]) - 1) + 0.5f)) > (1 << this.nBits[3]) - 1) {
                    n8 = (1 << this.nBits[3]) - 1;
                }
                nArray[0] = n8 << this.maskOffsets[3];
            }
            n3 = (int)(fArray[0] * (float)((1 << this.nBits[0]) - 1) + 0.5f);
            n4 = (int)(fArray[1] * (float)((1 << this.nBits[1]) - 1) + 0.5f);
            n5 = (int)(fArray[2] * (float)((1 << this.nBits[2]) - 1) + 0.5f);
        }
        if (this.maxBits > 23) {
            if (n3 > (1 << this.nBits[0]) - 1) {
                n3 = (1 << this.nBits[0]) - 1;
            }
            if (n4 > (1 << this.nBits[1]) - 1) {
                n4 = (1 << this.nBits[1]) - 1;
            }
            if (n5 > (1 << this.nBits[2]) - 1) {
                n5 = (1 << this.nBits[2]) - 1;
            }
        }
        nArray[0] = nArray[0] | (n3 << this.maskOffsets[0] | n4 << this.maskOffsets[1] | n5 << this.maskOffsets[2]);
        switch (this.transferType) {
            case 0: {
                byte[] byArray = object == null ? new byte[1] : (byte[])object;
                byArray[0] = (byte)(0xFF & nArray[0]);
                return byArray;
            }
            case 1: {
                short[] sArray = object == null ? new short[1] : (short[])object;
                sArray[0] = (short)(nArray[0] & 0xFFFF);
                return sArray;
            }
            case 3: {
                return nArray;
            }
        }
        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
    }

    public final int[] getComponents(int n2, int[] nArray, int n3) {
        if (nArray == null) {
            nArray = new int[n3 + this.numComponents];
        }
        for (int i2 = 0; i2 < this.numComponents; ++i2) {
            nArray[n3 + i2] = (n2 & this.maskArray[i2]) >>> this.maskOffsets[i2];
        }
        return nArray;
    }

    public final int[] getComponents(Object object, int[] nArray, int n2) {
        int n3 = 0;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n3 = byArray[0] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n3 = sArray[0] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray2 = (int[])object;
                n3 = nArray2[0];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return this.getComponents(n3, nArray, n2);
    }

    public final WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        int[] nArray;
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException("Width (" + n2 + ") and height (" + n3 + ") cannot be <= 0");
        }
        if (this.supportsAlpha) {
            nArray = new int[4];
            nArray[3] = this.alpha_mask;
        } else {
            nArray = new int[]{this.red_mask, this.green_mask, this.blue_mask};
        }
        if (this.pixel_bits > 16) {
            return Raster.createPackedRaster(3, n2, n3, nArray, null);
        }
        if (this.pixel_bits > 8) {
            return Raster.createPackedRaster(1, n2, n3, nArray, null);
        }
        return Raster.createPackedRaster(0, n2, n3, nArray, null);
    }

    public int getDataElement(int[] nArray, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.numComponents; ++i2) {
            n3 |= nArray[n2 + i2] << this.maskOffsets[i2] & this.maskArray[i2];
        }
        return n3;
    }

    public Object getDataElements(int[] nArray, int n2, Object object) {
        int n3 = 0;
        for (int i2 = 0; i2 < this.numComponents; ++i2) {
            n3 |= nArray[n2 + i2] << this.maskOffsets[i2] & this.maskArray[i2];
        }
        switch (this.transferType) {
            case 0: {
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    byArray[0] = (byte)(n3 & 0xFF);
                    return byArray;
                }
                byte[] byArray = new byte[]{(byte)(n3 & 0xFF)};
                return byArray;
            }
            case 1: {
                if (object instanceof short[]) {
                    short[] sArray = (short[])object;
                    sArray[0] = (short)(n3 & 0xFFFF);
                    return sArray;
                }
                short[] sArray = new short[]{(short)(n3 & 0xFFFF)};
                return sArray;
            }
            case 3: {
                if (object instanceof int[]) {
                    int[] nArray2 = (int[])object;
                    nArray2[0] = n3;
                    return nArray2;
                }
                int[] nArray3 = new int[]{n3};
                return nArray3;
            }
        }
        throw new ClassCastException("This method has not been implemented for transferType " + this.transferType);
    }

    public final ColorModel coerceData(WritableRaster writableRaster, boolean bl2) {
        block42: {
            int[] nArray;
            int n2;
            int n3;
            float f2;
            int n4;
            int n5;
            int n6;
            block41: {
                if (!this.supportsAlpha || this.isAlphaPremultiplied() == bl2) {
                    return this;
                }
                n6 = writableRaster.getWidth();
                n5 = writableRaster.getHeight();
                n4 = this.numColorComponents;
                f2 = 1.0f / (float)((1 << this.nBits[n4]) - 1);
                n3 = writableRaster.getMinX();
                n2 = writableRaster.getMinY();
                nArray = null;
                int[] nArray2 = null;
                if (!bl2) break block41;
                switch (this.transferType) {
                    case 0: {
                        int n7 = 0;
                        while (n7 < n5) {
                            int n8 = n3;
                            int n9 = 0;
                            while (n9 < n6) {
                                float f3 = (float)(nArray = writableRaster.getPixel(n8, n2, nArray))[n4] * f2;
                                if (f3 != 0.0f) {
                                    for (int i2 = 0; i2 < n4; ++i2) {
                                        nArray[i2] = (int)((float)nArray[i2] * f3 + 0.5f);
                                    }
                                    writableRaster.setPixel(n8, n2, nArray);
                                } else {
                                    if (nArray2 == null) {
                                        nArray2 = new int[this.numComponents];
                                        Arrays.fill(nArray2, 0);
                                    }
                                    writableRaster.setPixel(n8, n2, nArray2);
                                }
                                ++n9;
                                ++n8;
                            }
                            ++n7;
                            ++n2;
                        }
                        break block42;
                    }
                    case 1: {
                        int n10 = 0;
                        while (n10 < n5) {
                            int n11 = n3;
                            int n12 = 0;
                            while (n12 < n6) {
                                float f4 = (float)(nArray = writableRaster.getPixel(n11, n2, nArray))[n4] * f2;
                                if (f4 != 0.0f) {
                                    for (int i3 = 0; i3 < n4; ++i3) {
                                        nArray[i3] = (int)((float)nArray[i3] * f4 + 0.5f);
                                    }
                                    writableRaster.setPixel(n11, n2, nArray);
                                } else {
                                    if (nArray2 == null) {
                                        nArray2 = new int[this.numComponents];
                                        Arrays.fill(nArray2, 0);
                                    }
                                    writableRaster.setPixel(n11, n2, nArray2);
                                }
                                ++n12;
                                ++n11;
                            }
                            ++n10;
                            ++n2;
                        }
                        break block42;
                    }
                    case 3: {
                        int n13 = 0;
                        while (n13 < n5) {
                            int n14 = n3;
                            int n15 = 0;
                            while (n15 < n6) {
                                float f5 = (float)(nArray = writableRaster.getPixel(n14, n2, nArray))[n4] * f2;
                                if (f5 != 0.0f) {
                                    for (int i4 = 0; i4 < n4; ++i4) {
                                        nArray[i4] = (int)((float)nArray[i4] * f5 + 0.5f);
                                    }
                                    writableRaster.setPixel(n14, n2, nArray);
                                } else {
                                    if (nArray2 == null) {
                                        nArray2 = new int[this.numComponents];
                                        Arrays.fill(nArray2, 0);
                                    }
                                    writableRaster.setPixel(n14, n2, nArray2);
                                }
                                ++n15;
                                ++n14;
                            }
                            ++n13;
                            ++n2;
                        }
                        break block42;
                    }
                    default: {
                        throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                    }
                }
            }
            switch (this.transferType) {
                case 0: {
                    int n16 = 0;
                    while (n16 < n5) {
                        int n17 = n3;
                        int n18 = 0;
                        while (n18 < n6) {
                            float f6 = (float)(nArray = writableRaster.getPixel(n17, n2, nArray))[n4] * f2;
                            if (f6 != 0.0f) {
                                float f7 = 1.0f / f6;
                                for (int i5 = 0; i5 < n4; ++i5) {
                                    nArray[i5] = (int)((float)nArray[i5] * f7 + 0.5f);
                                }
                                writableRaster.setPixel(n17, n2, nArray);
                            }
                            ++n18;
                            ++n17;
                        }
                        ++n16;
                        ++n2;
                    }
                    break;
                }
                case 1: {
                    int n19 = 0;
                    while (n19 < n5) {
                        int n20 = n3;
                        int n21 = 0;
                        while (n21 < n6) {
                            float f8 = (float)(nArray = writableRaster.getPixel(n20, n2, nArray))[n4] * f2;
                            if (f8 != 0.0f) {
                                float f9 = 1.0f / f8;
                                for (int i6 = 0; i6 < n4; ++i6) {
                                    nArray[i6] = (int)((float)nArray[i6] * f9 + 0.5f);
                                }
                                writableRaster.setPixel(n20, n2, nArray);
                            }
                            ++n21;
                            ++n20;
                        }
                        ++n19;
                        ++n2;
                    }
                    break;
                }
                case 3: {
                    int n22 = 0;
                    while (n22 < n5) {
                        int n23 = n3;
                        int n24 = 0;
                        while (n24 < n6) {
                            float f10 = (float)(nArray = writableRaster.getPixel(n23, n2, nArray))[n4] * f2;
                            if (f10 != 0.0f) {
                                float f11 = 1.0f / f10;
                                for (int i7 = 0; i7 < n4; ++i7) {
                                    nArray[i7] = (int)((float)nArray[i7] * f11 + 0.5f);
                                }
                                writableRaster.setPixel(n23, n2, nArray);
                            }
                            ++n24;
                            ++n23;
                        }
                        ++n22;
                        ++n2;
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
                }
            }
        }
        return new DirectColorModel(this.colorSpace, this.pixel_bits, this.maskArray[0], this.maskArray[1], this.maskArray[2], this.maskArray[3], bl2, this.transferType);
    }

    public boolean isCompatibleRaster(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        if (!(sampleModel instanceof SinglePixelPackedSampleModel)) {
            return false;
        }
        SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
        if (singlePixelPackedSampleModel.getNumBands() != this.getNumComponents()) {
            return false;
        }
        int[] nArray = singlePixelPackedSampleModel.getBitMasks();
        for (int i2 = 0; i2 < this.numComponents; ++i2) {
            if (nArray[i2] == this.maskArray[i2]) continue;
            return false;
        }
        return raster.getTransferType() == this.transferType;
    }

    private void setFields() {
        this.red_mask = this.maskArray[0];
        this.red_offset = this.maskOffsets[0];
        this.green_mask = this.maskArray[1];
        this.green_offset = this.maskOffsets[1];
        this.blue_mask = this.maskArray[2];
        this.blue_offset = this.maskOffsets[2];
        if (this.nBits[0] < 8) {
            this.red_scale = (1 << this.nBits[0]) - 1;
        }
        if (this.nBits[1] < 8) {
            this.green_scale = (1 << this.nBits[1]) - 1;
        }
        if (this.nBits[2] < 8) {
            this.blue_scale = (1 << this.nBits[2]) - 1;
        }
        if (this.supportsAlpha) {
            this.alpha_mask = this.maskArray[3];
            this.alpha_offset = this.maskOffsets[3];
            if (this.nBits[3] < 8) {
                this.alpha_scale = (1 << this.nBits[3]) - 1;
            }
        }
    }

    public String toString() {
        return new String("DirectColorModel: rmask=" + Integer.toHexString(this.red_mask) + " gmask=" + Integer.toHexString(this.green_mask) + " bmask=" + Integer.toHexString(this.blue_mask) + " amask=" + Integer.toHexString(this.alpha_mask));
    }
}

