/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.util;

import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import java.util.ArrayList;
import java.util.HashMap;

public class ParserConfigurationSettings
implements XMLComponentManager {
    protected static final String PARSER_SETTINGS = "http://apache.org/xml/features/internal/parser-settings";
    protected ArrayList fRecognizedProperties;
    protected HashMap fProperties;
    protected ArrayList fRecognizedFeatures = new ArrayList();
    protected HashMap fFeatures;
    protected XMLComponentManager fParentSettings;

    public ParserConfigurationSettings() {
        this(null);
    }

    public ParserConfigurationSettings(XMLComponentManager xMLComponentManager) {
        this.fRecognizedProperties = new ArrayList();
        this.fFeatures = new HashMap();
        this.fProperties = new HashMap();
        this.fParentSettings = xMLComponentManager;
    }

    public void addRecognizedFeatures(String[] stringArray) {
        int n2 = stringArray != null ? stringArray.length : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (this.fRecognizedFeatures.contains(string)) continue;
            this.fRecognizedFeatures.add(string);
        }
    }

    public void setFeature(String string, boolean bl2) throws XMLConfigurationException {
        this.checkFeature(string);
        this.fFeatures.put(string, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addRecognizedProperties(String[] stringArray) {
        int n2 = stringArray != null ? stringArray.length : 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = stringArray[i2];
            if (this.fRecognizedProperties.contains(string)) continue;
            this.fRecognizedProperties.add(string);
        }
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        this.checkProperty(string);
        if (object == null) {
            this.fProperties.remove(string);
        } else {
            this.fProperties.put(string, object);
        }
    }

    public boolean getFeature(String string) throws XMLConfigurationException {
        Boolean bl2 = (Boolean)this.fFeatures.get(string);
        if (bl2 == null) {
            this.checkFeature(string);
            return false;
        }
        return bl2;
    }

    public Object getProperty(String string) throws XMLConfigurationException {
        Object v2 = this.fProperties.get(string);
        if (v2 == null) {
            this.checkProperty(string);
        }
        return v2;
    }

    protected void checkFeature(String string) throws XMLConfigurationException {
        if (!this.fRecognizedFeatures.contains(string)) {
            if (this.fParentSettings != null) {
                this.fParentSettings.getFeature(string);
            } else {
                short s2 = 0;
                throw new XMLConfigurationException(s2, string);
            }
        }
    }

    protected void checkProperty(String string) throws XMLConfigurationException {
        if (!this.fRecognizedProperties.contains(string)) {
            if (this.fParentSettings != null) {
                this.fParentSettings.getProperty(string);
            } else {
                short s2 = 0;
                throw new XMLConfigurationException(s2, string);
            }
        }
    }
}

