/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.oa.poa;

import com.sun.corba.se.impl.oa.poa.AOMEntry;
import com.sun.corba.se.impl.oa.poa.MultipleObjectMap;
import com.sun.corba.se.impl.oa.poa.POAImpl;
import com.sun.corba.se.impl.oa.poa.SingleObjectMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.omg.PortableServer.Servant;

public abstract class ActiveObjectMap {
    protected POAImpl poa;
    private Map keyToEntry = new HashMap();
    private Map entryToServant = new HashMap();
    private Map servantToEntry = new HashMap();

    protected ActiveObjectMap(POAImpl pOAImpl) {
        this.poa = pOAImpl;
    }

    public static ActiveObjectMap create(POAImpl pOAImpl, boolean bl2) {
        if (bl2) {
            return new MultipleObjectMap(pOAImpl);
        }
        return new SingleObjectMap(pOAImpl);
    }

    public final boolean contains(Servant servant) {
        return this.servantToEntry.containsKey(servant);
    }

    public final boolean containsKey(Key key) {
        return this.keyToEntry.containsKey(key);
    }

    public final AOMEntry get(Key key) {
        AOMEntry aOMEntry = (AOMEntry)this.keyToEntry.get(key);
        if (aOMEntry == null) {
            aOMEntry = new AOMEntry(this.poa);
            this.putEntry(key, aOMEntry);
        }
        return aOMEntry;
    }

    public final Servant getServant(AOMEntry aOMEntry) {
        return (Servant)this.entryToServant.get(aOMEntry);
    }

    public abstract Key getKey(AOMEntry var1) throws WrongPolicy;

    public Key getKey(Servant servant) throws WrongPolicy {
        AOMEntry aOMEntry = (AOMEntry)this.servantToEntry.get(servant);
        return this.getKey(aOMEntry);
    }

    protected void putEntry(Key key, AOMEntry aOMEntry) {
        this.keyToEntry.put(key, aOMEntry);
    }

    public final void putServant(Servant servant, AOMEntry aOMEntry) {
        this.entryToServant.put(aOMEntry, servant);
        this.servantToEntry.put(servant, aOMEntry);
    }

    protected abstract void removeEntry(AOMEntry var1, Key var2);

    public final void remove(Key key) {
        AOMEntry aOMEntry = (AOMEntry)this.keyToEntry.remove(key);
        Servant servant = (Servant)this.entryToServant.remove(aOMEntry);
        if (servant != null) {
            this.servantToEntry.remove(servant);
        }
        this.removeEntry(aOMEntry, key);
    }

    public abstract boolean hasMultipleIDs(AOMEntry var1);

    protected void clear() {
        this.keyToEntry.clear();
    }

    public final Set keySet() {
        return this.keyToEntry.keySet();
    }

    public static class Key {
        public byte[] id;

        Key(byte[] byArray) {
            this.id = byArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < this.id.length; ++i2) {
                stringBuffer.append(Integer.toString(this.id[i2], 16));
                if (i2 == this.id.length - 1) continue;
                stringBuffer.append(":");
            }
            return stringBuffer.toString();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Key)) {
                return false;
            }
            Key key = (Key)object;
            if (key.id.length != this.id.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.id.length; ++i2) {
                if (this.id[i2] == key.id[i2]) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int n2 = 0;
            for (int i2 = 0; i2 < this.id.length; ++i2) {
                n2 = 31 * n2 + this.id[i2];
            }
            return n2;
        }
    }
}

