/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import net.sf.jazzlib.DeflaterPending;

class DeflaterHuffman {
    private static final int _$13086 = 16384;
    private static final int _$13087 = 286;
    private static final int _$13088 = 30;
    private static final int _$13089 = 19;
    private static final int _$13090 = 16;
    private static final int _$13091 = 17;
    private static final int _$13092 = 18;
    private static final int _$13093 = 256;
    private static final int[] _$13094 = new int[]{16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15};
    private static final String _$13095 = "\u0000\b\u0004\f\u0002\n\u0006\u000e\u0001\t\u0005\r\u0003\u000b\u0007\u000f";
    DeflaterPending pending;
    private Tree _$13142;
    private Tree _$9526;
    private Tree _$13136;
    private short[] _$13143;
    private byte[] _$13144;
    private int _$13145;
    private int _$13146;
    private static short[] _$13147 = new short[286];
    private static byte[] _$13148 = new byte[286];
    private static short[] _$13149;
    private static byte[] _$13150;

    static short bitReverse(int n) {
        return (short)(_$13095.charAt(n & 0xF) << 12 | _$13095.charAt(n >> 4 & 0xF) << 8 | _$13095.charAt(n >> 8 & 0xF) << 4 | _$13095.charAt(n >> 12));
    }

    public DeflaterHuffman(DeflaterPending deflaterPending) {
        this.pending = deflaterPending;
        this._$13142 = new Tree(286, 257, 15);
        this._$9526 = new Tree(30, 1, 15);
        this._$13136 = new Tree(19, 4, 7);
        this._$13143 = new short[16384];
        this._$13144 = new byte[16384];
    }

    public final void reset() {
        this._$13145 = 0;
        this._$13146 = 0;
        this._$13142.reset();
        this._$9526.reset();
        this._$13136.reset();
    }

    private final int _$13151(int n) {
        if (n == 255) {
            return 285;
        }
        int n2 = 257;
        while (n >= 8) {
            n2 += 4;
            n >>= 1;
        }
        return n2 + n;
    }

    private final int _$13152(int n) {
        int n2 = 0;
        while (n >= 4) {
            n2 += 2;
            n >>= 1;
        }
        return n2 + n;
    }

    public void sendAllTrees(int n) {
        this._$13136.buildCodes();
        this._$13142.buildCodes();
        this._$9526.buildCodes();
        this.pending.writeBits(this._$13142.numCodes - 257, 5);
        this.pending.writeBits(this._$9526.numCodes - 1, 5);
        this.pending.writeBits(n - 4, 4);
        for (int i = 0; i < n; ++i) {
            this.pending.writeBits(this._$13136.length[_$13094[i]], 3);
        }
        this._$13142.writeTree(this._$13136);
        this._$9526.writeTree(this._$13136);
    }

    public void compressBlock() {
        for (int i = 0; i < this._$13145; ++i) {
            int n = this._$13144[i] & 0xFF;
            int n2 = this._$13143[i];
            if (n2-- != 0) {
                int n3 = this._$13151(n);
                this._$13142.writeSymbol(n3);
                int n4 = (n3 - 261) / 4;
                if (n4 > 0 && n4 <= 5) {
                    this.pending.writeBits(n & (1 << n4) - 1, n4);
                }
                int n5 = this._$13152(n2);
                this._$9526.writeSymbol(n5);
                n4 = n5 / 2 - 1;
                if (n4 <= 0) continue;
                this.pending.writeBits(n2 & (1 << n4) - 1, n4);
                continue;
            }
            this._$13142.writeSymbol(n);
        }
        this._$13142.writeSymbol(256);
    }

    public void flushStoredBlock(byte[] byArray, int n, int n2, boolean bl) {
        this.pending.writeBits(0 + (bl ? 1 : 0), 3);
        this.pending.alignToByte();
        this.pending.writeShort(n2);
        this.pending.writeShort(~n2);
        this.pending.writeBlock(byArray, n, n2);
        this.reset();
    }

    public void flushBlock(byte[] byArray, int n, int n2, boolean bl) {
        int n3;
        int n4;
        this._$13142.freqs[256] = (short)(this._$13142.freqs[256] + 1);
        this._$13142.buildTree();
        this._$9526.buildTree();
        this._$13142.calcBLFreq(this._$13136);
        this._$9526.calcBLFreq(this._$13136);
        this._$13136.buildTree();
        int n5 = 4;
        for (n4 = 18; n4 > n5; --n4) {
            if (this._$13136.length[_$13094[n4]] <= 0) continue;
            n5 = n4 + 1;
        }
        n4 = 14 + n5 * 3 + this._$13136.getEncodedLength() + this._$13142.getEncodedLength() + this._$9526.getEncodedLength() + this._$13146;
        int n6 = this._$13146;
        for (n3 = 0; n3 < 286; ++n3) {
            n6 += this._$13142.freqs[n3] * _$13148[n3];
        }
        for (n3 = 0; n3 < 30; ++n3) {
            n6 += this._$9526.freqs[n3] * _$13150[n3];
        }
        if (n4 >= n6) {
            n4 = n6;
        }
        if (n >= 0 && n2 + 4 < n4 >> 3) {
            this.flushStoredBlock(byArray, n, n2, bl);
        } else if (n4 == n6) {
            this.pending.writeBits(2 + (bl ? 1 : 0), 3);
            this._$13142.setStaticCodes(_$13147, _$13148);
            this._$9526.setStaticCodes(_$13149, _$13150);
            this.compressBlock();
            this.reset();
        } else {
            this.pending.writeBits(4 + (bl ? 1 : 0), 3);
            this.sendAllTrees(n5);
            this.compressBlock();
            this.reset();
        }
    }

    public final boolean isFull() {
        return this._$13145 == 16384;
    }

    public final boolean tallyLit(int n) {
        this._$13143[this._$13145] = 0;
        this._$13144[this._$13145++] = (byte)n;
        int n2 = n;
        this._$13142.freqs[n2] = (short)(this._$13142.freqs[n2] + 1);
        return this._$13145 == 16384;
    }

    public final boolean tallyDist(int n, int n2) {
        int n3;
        int n4;
        this._$13143[this._$13145] = (short)n;
        this._$13144[this._$13145++] = (byte)(n2 - 3);
        int n5 = n4 = this._$13151(n2 - 3);
        this._$13142.freqs[n5] = (short)(this._$13142.freqs[n5] + 1);
        if (n4 >= 265 && n4 < 285) {
            this._$13146 += (n4 - 261) / 4;
        }
        int n6 = n3 = this._$13152(n - 1);
        this._$9526.freqs[n6] = (short)(this._$9526.freqs[n6] + 1);
        if (n3 >= 4) {
            this._$13146 += n3 / 2 - 1;
        }
        return this._$13145 == 16384;
    }

    static {
        int n = 0;
        while (n < 144) {
            DeflaterHuffman._$13147[n] = DeflaterHuffman.bitReverse(48 + n << 8);
            DeflaterHuffman._$13148[n++] = 8;
        }
        while (n < 256) {
            DeflaterHuffman._$13147[n] = DeflaterHuffman.bitReverse(256 + n << 7);
            DeflaterHuffman._$13148[n++] = 9;
        }
        while (n < 280) {
            DeflaterHuffman._$13147[n] = DeflaterHuffman.bitReverse(-256 + n << 9);
            DeflaterHuffman._$13148[n++] = 7;
        }
        while (n < 286) {
            DeflaterHuffman._$13147[n] = DeflaterHuffman.bitReverse(-88 + n << 8);
            DeflaterHuffman._$13148[n++] = 8;
        }
        _$13149 = new short[30];
        _$13150 = new byte[30];
        for (n = 0; n < 30; ++n) {
            DeflaterHuffman._$13149[n] = DeflaterHuffman.bitReverse(n << 11);
            DeflaterHuffman._$13150[n] = 5;
        }
    }

    class Tree {
        short[] freqs;
        short[] codes;
        byte[] length;
        int[] bl_counts;
        int minNumCodes;
        int numCodes;
        int maxLength;

        Tree(int n, int n2, int n3) {
            this.minNumCodes = n2;
            this.maxLength = n3;
            this.freqs = new short[n];
            this.bl_counts = new int[n3];
        }

        void reset() {
            for (int i = 0; i < this.freqs.length; ++i) {
                this.freqs[i] = 0;
            }
            this.codes = null;
            this.length = null;
        }

        final void writeSymbol(int n) {
            DeflaterHuffman.this.pending.writeBits(this.codes[n] & 0xFFFF, this.length[n]);
        }

        final void checkEmpty() {
            boolean bl = true;
            for (int i = 0; i < this.freqs.length; ++i) {
                if (this.freqs[i] == 0) continue;
                System.err.println("freqs[" + i + "] == " + this.freqs[i]);
                bl = false;
            }
            if (!bl) {
                throw new InternalError();
            }
            System.err.println("checkEmpty suceeded!");
        }

        void setStaticCodes(short[] sArray, byte[] byArray) {
            this.codes = sArray;
            this.length = byArray;
        }

        public void buildCodes() {
            int n;
            int[] nArray = new int[this.maxLength];
            int n2 = 0;
            this.codes = new short[this.freqs.length];
            for (n = 0; n < this.maxLength; ++n) {
                nArray[n] = n2;
                n2 += this.bl_counts[n] << 15 - n;
            }
            for (n = 0; n < this.numCodes; ++n) {
                byte by = this.length[n];
                if (by <= 0) continue;
                this.codes[n] = DeflaterHuffman.bitReverse(nArray[by - 1]);
                int n3 = by - 1;
                nArray[n3] = nArray[n3] + (1 << 16 - by);
            }
        }

        private void _$13112(int[] nArray) {
            int n;
            int n2;
            this.length = new byte[this.freqs.length];
            int n3 = nArray.length / 2;
            int n4 = (n3 + 1) / 2;
            int n5 = 0;
            for (int i = 0; i < this.maxLength; ++i) {
                this.bl_counts[i] = 0;
            }
            int[] nArray2 = new int[n3];
            nArray2[n3 - 1] = 0;
            for (n2 = n3 - 1; n2 >= 0; --n2) {
                if (nArray[2 * n2 + 1] != -1) {
                    n = nArray2[n2] + 1;
                    if (n > this.maxLength) {
                        n = this.maxLength;
                        ++n5;
                    }
                    int n6 = n;
                    nArray2[nArray[2 * n2 + 1]] = n6;
                    nArray2[nArray[2 * n2]] = n6;
                    continue;
                }
                n = nArray2[n2];
                int n7 = n - 1;
                this.bl_counts[n7] = this.bl_counts[n7] + 1;
                this.length[nArray[2 * n2]] = (byte)nArray2[n2];
            }
            if (n5 == 0) {
                return;
            }
            n2 = this.maxLength - 1;
            while (true) {
                if (this.bl_counts[--n2] == 0) {
                    continue;
                }
                do {
                    int n8 = n2++;
                    this.bl_counts[n8] = this.bl_counts[n8] - 1;
                    int n9 = n2;
                    this.bl_counts[n9] = this.bl_counts[n9] + 1;
                } while ((n5 -= 1 << this.maxLength - 1 - n2) > 0 && n2 < this.maxLength - 1);
                if (n5 <= 0) break;
            }
            int n10 = this.maxLength - 1;
            this.bl_counts[n10] = this.bl_counts[n10] + n5;
            int n11 = this.maxLength - 2;
            this.bl_counts[n11] = this.bl_counts[n11] - n5;
            n = 2 * n4;
            for (int i = this.maxLength; i != 0; --i) {
                int n12 = this.bl_counts[i - 1];
                while (n12 > 0) {
                    int n13;
                    if (nArray[(n13 = 2 * nArray[n++]) + 1] != -1) continue;
                    this.length[nArray[n13]] = (byte)i;
                    --n12;
                }
            }
        }

        void buildTree() {
            int n;
            int n2;
            int n3;
            int n4;
            int n5 = this.freqs.length;
            int[] nArray = new int[n5];
            int n6 = 0;
            int n7 = 0;
            for (n4 = 0; n4 < n5; ++n4) {
                short s = this.freqs[n4];
                if (s == 0) continue;
                int n8 = n6++;
                while (n8 > 0 && this.freqs[nArray[n3 = (n8 - 1) / 2]] > s) {
                    nArray[n8] = nArray[n3];
                    n8 = n3;
                }
                nArray[n8] = n4;
                n7 = n4;
            }
            while (n6 < 2) {
                n4 = n7 < 2 ? ++n7 : 0;
                nArray[n6++] = n4;
            }
            this.numCodes = Math.max(n7 + 1, this.minNumCodes);
            n4 = n6;
            int[] nArray2 = new int[4 * n6 - 2];
            int[] nArray3 = new int[2 * n6 - 1];
            n3 = n4;
            for (n2 = 0; n2 < n6; ++n2) {
                nArray2[2 * n2] = n = nArray[n2];
                nArray2[2 * n2 + 1] = -1;
                nArray3[n2] = this.freqs[n] << 8;
                nArray[n2] = n2;
            }
            do {
                n2 = nArray[0];
                n = nArray[--n6];
                int n9 = 0;
                int n10 = 1;
                while (n10 < n6) {
                    if (n10 + 1 < n6 && nArray3[nArray[n10]] > nArray3[nArray[n10 + 1]]) {
                        ++n10;
                    }
                    nArray[n9] = nArray[n10];
                    n9 = n10;
                    n10 = n10 * 2 + 1;
                }
                int n11 = nArray3[n];
                while ((n10 = n9) > 0 && nArray3[nArray[n9 = (n10 - 1) / 2]] > n11) {
                    nArray[n10] = nArray[n9];
                }
                nArray[n10] = n;
                int n12 = nArray[0];
                n = n3++;
                nArray2[2 * n] = n2;
                nArray2[2 * n + 1] = n12;
                int n13 = Math.min(nArray3[n2] & 0xFF, nArray3[n12] & 0xFF);
                nArray3[n] = n11 = nArray3[n2] + nArray3[n12] - n13 + 1;
                n9 = 0;
                n10 = 1;
                while (n10 < n6) {
                    if (n10 + 1 < n6 && nArray3[nArray[n10]] > nArray3[nArray[n10 + 1]]) {
                        ++n10;
                    }
                    nArray[n9] = nArray[n10];
                    n9 = n10;
                    n10 = n9 * 2 + 1;
                }
                while ((n10 = n9) > 0 && nArray3[nArray[n9 = (n10 - 1) / 2]] > n11) {
                    nArray[n10] = nArray[n9];
                }
                nArray[n10] = n;
            } while (n6 > 1);
            if (nArray[0] != nArray2.length / 2 - 1) {
                throw new RuntimeException("Weird!");
            }
            this._$13112(nArray2);
        }

        int getEncodedLength() {
            int n = 0;
            for (int i = 0; i < this.freqs.length; ++i) {
                n += this.freqs[i] * this.length[i];
            }
            return n;
        }

        void calcBLFreq(Tree tree) {
            byte by = -1;
            int n = 0;
            while (n < this.numCodes) {
                int n2;
                int n3;
                int n4 = 1;
                byte by2 = this.length[n];
                if (by2 == 0) {
                    n3 = 138;
                    n2 = 3;
                } else {
                    n3 = 6;
                    n2 = 3;
                    if (by != by2) {
                        byte by3 = by2;
                        tree.freqs[by3] = (short)(tree.freqs[by3] + 1);
                        n4 = 0;
                    }
                }
                by = by2;
                ++n;
                while (n < this.numCodes && by == this.length[n]) {
                    ++n;
                    if (++n4 < n3) continue;
                }
                if (n4 < n2) {
                    byte by4 = by;
                    tree.freqs[by4] = (short)(tree.freqs[by4] + n4);
                    continue;
                }
                if (by != 0) {
                    tree.freqs[16] = (short)(tree.freqs[16] + 1);
                    continue;
                }
                if (n4 <= 10) {
                    tree.freqs[17] = (short)(tree.freqs[17] + 1);
                    continue;
                }
                tree.freqs[18] = (short)(tree.freqs[18] + 1);
            }
        }

        void writeTree(Tree tree) {
            byte by = -1;
            int n = 0;
            while (n < this.numCodes) {
                int n2;
                int n3;
                int n4 = 1;
                byte by2 = this.length[n];
                if (by2 == 0) {
                    n3 = 138;
                    n2 = 3;
                } else {
                    n3 = 6;
                    n2 = 3;
                    if (by != by2) {
                        tree.writeSymbol(by2);
                        n4 = 0;
                    }
                }
                by = by2;
                ++n;
                while (n < this.numCodes && by == this.length[n]) {
                    ++n;
                    if (++n4 < n3) continue;
                }
                if (n4 < n2) {
                    while (n4-- > 0) {
                        tree.writeSymbol(by);
                    }
                    continue;
                }
                if (by != 0) {
                    tree.writeSymbol(16);
                    DeflaterHuffman.this.pending.writeBits(n4 - 3, 2);
                    continue;
                }
                if (n4 <= 10) {
                    tree.writeSymbol(17);
                    DeflaterHuffman.this.pending.writeBits(n4 - 3, 3);
                    continue;
                }
                tree.writeSymbol(18);
                DeflaterHuffman.this.pending.writeBits(n4 - 11, 7);
            }
        }
    }
}

