/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.SingletonModel;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonModelMulticaster;
import com.borland.jbcl.model.WritableSingletonModel;
import com.borland.jbcl.view.SingletonModelView;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ChoiceView
extends Choice
implements SingletonModelView,
SingletonModelListener,
KeyListener,
Serializable {
    private static final long serialVersionUID = 200L;
    private boolean autoAdd = true;
    private transient SingletonModel model;
    private transient WritableSingletonModel writeModel;
    private transient SingletonModelMulticaster modelAdapter = new SingletonModelMulticaster();
    private boolean readOnly;

    public ChoiceView() {
        this.enableEvents(512L);
        this.addKeyListener(this);
    }

    public synchronized String[] getItems() {
        int c2 = this.getItemCount();
        String[] s = new String[c2];
        for (int i2 = 0; i2 < c2; ++i2) {
            s[i2] = this.getItem(i2);
        }
        return s;
    }

    public synchronized void setItems(String[] items) {
        this.removeAll();
        if (items != null) {
            for (int i2 = 0; i2 < items.length; ++i2) {
                super.addItem(items[i2]);
            }
        }
        if (this.model.get() != null) {
            this.updateSelection();
        } else if (!this.isReadOnly() && this.writeModel.canSet(true) && items != null && items.length > 0) {
            this.writeModel.set(items[0]);
        }
        if (items != null && this.getPeer() != null) {
            this.addNotify();
        }
    }

    public SingletonModel getModel() {
        return this.model;
    }

    public WritableSingletonModel getWriteModel() {
        return this.readOnly ? null : this.writeModel;
    }

    public void setModel(SingletonModel p) {
        if (this.model != null) {
            this.model.removeModelListener(this);
        }
        this.model = p;
        WritableSingletonModel writableSingletonModel = this.writeModel = p instanceof WritableSingletonModel ? (WritableSingletonModel)p : null;
        if (this.model != null) {
            this.model.addModelListener(this);
            this.modelContentChanged(null);
        }
        this.setEnabled(!this.isReadOnly());
    }

    public void addModelListener(SingletonModelListener listener) {
        this.model.addModelListener(listener);
    }

    public void removeModelListener(SingletonModelListener listener) {
        this.model.removeModelListener(listener);
    }

    public boolean isReadOnly() {
        return this.readOnly ? true : this.writeModel == null;
    }

    public void setReadOnly(boolean ro) {
        this.readOnly = ro;
        this.setEnabled(!this.readOnly);
    }

    public void modelContentChanged(SingletonModelEvent e2) {
        this.updateSelection();
    }

    public void select(String s) {
        if (!this.isReadOnly() && this.writeModel.canSet(true)) {
            super.select(s);
            String selected = this.getSelectedItem();
            this.writeModel.set(selected);
        }
    }

    public void setAutoAdd(boolean autoAdd) {
        this.autoAdd = autoAdd;
    }

    public boolean isAutoAdd() {
        return this.autoAdd;
    }

    protected void updateSelection() {
        Object data = this.model.get();
        String text = data != null ? data.toString() : "";
        for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
            if (!text.equals(this.getItem(i2))) continue;
            super.select(text);
            return;
        }
        if (this.autoAdd && data != null) {
            super.addItem(text);
            super.select(text);
        }
    }

    protected void processItemEvent(ItemEvent e2) {
        if (!this.isReadOnly() && this.writeModel.canSet(true)) {
            String selected = this.getSelectedItem();
            this.writeModel.set(selected);
        }
        super.processItemEvent(e2);
    }

    public void keyPressed(KeyEvent e2) {
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void keyTyped(KeyEvent e2) {
        if (this.isReadOnly() || !this.writeModel.canSet(false) || e2.isAltDown()) {
            return;
        }
        char c2 = e2.getKeyChar();
        String item = this.getSelectedItem();
        if (item == null) {
            return;
        }
        char s = (item = item.toLowerCase()).length() > 0 ? (char)item.charAt(0) : (char)'\uffff';
        int[] matches = new int[]{};
        if (c2 != '\uffff') {
            for (int i2 = 0; i2 < this.getItemCount(); ++i2) {
                String value = this.getItem(i2).toLowerCase();
                if (value.length() <= 0 || value.charAt(0) != c2) continue;
                if (s != c2) {
                    this.writeModel.set(this.getItem(i2));
                    return;
                }
                int[] old = matches;
                matches = new int[old.length + 1];
                System.arraycopy(old, 0, matches, 0, old.length);
                matches[matches.length - 1] = i2;
            }
            if (matches.length > 0) {
                int sel = this.getSelectedIndex();
                for (int i3 = 0; i3 < matches.length; ++i3) {
                    if (matches[i3] > sel) {
                        this.writeModel.set(this.getItem(matches[i3]));
                        return;
                    }
                    if (i3 != matches.length - 1 || matches[i3] != sel) continue;
                    this.writeModel.set(this.getItem(matches[0]));
                    return;
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.model instanceof Serializable ? this.model : null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof SingletonModel) {
            this.model = (SingletonModel)data;
        }
        if (this.model instanceof WritableSingletonModel) {
            this.writeModel = (WritableSingletonModel)this.model;
        }
    }

    static {
        serialVersionUID = 200L;
    }
}

