/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.view;

import com.borland.jbcl.model.ItemPaintSite;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.view.BorderItemPainter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ButtonItemPainter
implements ItemPainter,
Serializable {
    private static final long serialVersionUID = 200L;
    static final int margin = 3;
    protected transient ItemPainter painter;
    protected boolean showRollover = false;
    protected BorderItemPainter upBorder = new BorderItemPainter(6, 15, 2048);
    protected BorderItemPainter dnBorder = new BorderItemPainter(7, 15, 2048);

    public ButtonItemPainter() {
    }

    public ButtonItemPainter(ItemPainter painter) {
        this.painter = painter;
    }

    public ButtonItemPainter(ItemPainter painter, boolean showRollover) {
        this.painter = painter;
        this.showRollover = showRollover;
    }

    public ItemPainter getPainter() {
        return this.painter;
    }

    public void setPainter(ItemPainter v) {
        this.painter = v;
    }

    public void setShowRollover(boolean showRollover) {
        this.showRollover = showRollover;
    }

    public boolean isShowRollover() {
        return this.showRollover;
    }

    public Dimension getPreferredSize(Object data, Graphics g2, int state, ItemPaintSite site) {
        if (this.painter != null) {
            Dimension painterDim = this.painter.getPreferredSize(data, g2, state, site);
            return new Dimension(painterDim.width + 3 + 3, painterDim.height + 3 + 3);
        }
        return new Dimension(6, 6);
    }

    public void paint(Object data, Graphics g2, Rectangle rect, int state, ItemPaintSite site) {
        boolean trans;
        boolean bl = trans = site != null ? site.isTransparent() : false;
        if (!trans) {
            g2.setColor(SystemColor.control);
            g2.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.showRollover) {
            if ((state & 4) != 0) {
                this.dnBorder.paint(null, g2, rect, 0, site);
            } else if ((state & 0x40) != 0) {
                this.upBorder.paint(null, g2, rect, 0, site);
            }
        } else if ((state & 4) == 0) {
            this.upBorder.paint(null, g2, rect, 0, site);
        } else {
            this.dnBorder.paint(null, g2, rect, 0, site);
        }
        if (this.painter != null) {
            Rectangle faceRect = (state & 4) == 0 ? new Rectangle(rect.x + 3, rect.y + 3, rect.width - 6, rect.height - 6) : new Rectangle(rect.x + 3 + 1, rect.y + 3 + 1, rect.width - 6 - 1, rect.height - 6 - 1);
            this.painter.paint(data, g2, faceRect, state, site);
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.painter instanceof Serializable ? this.painter : null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof ItemPainter) {
            this.painter = (ItemPainter)data;
        }
    }

    static {
        serialVersionUID = 200L;
        margin = 3;
    }
}

