/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.dx.dataset.Column;
import com.borland.dx.dataset.DataChangeEvent;
import com.borland.dx.dataset.DataChangeListener;
import com.borland.dx.dataset.DataSet;
import com.borland.dx.dataset.NavigationEvent;
import com.borland.dx.dataset.NavigationListener;
import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jb.util.ExceptionHandler;
import com.borland.jbcl.model.DataSetModel;
import com.borland.jbcl.model.ItemEditor;
import com.borland.jbcl.model.ItemPainter;
import com.borland.jbcl.model.SingletonModelEvent;
import com.borland.jbcl.model.SingletonModelListener;
import com.borland.jbcl.model.SingletonViewManager;
import com.borland.jbcl.model.WritableSingletonModel;
import java.awt.Component;
import java.util.EventListener;

public class SingletonDataSetManager
implements WritableSingletonModel,
SingletonViewManager,
NavigationListener,
DataChangeListener,
ExceptionHandler {
    private DataSet dataSet;
    private DataSetModel dataSetModel;
    private boolean events = true;
    private SingletonModelEvent singletonModelEvent = new SingletonModelEvent(this);
    private transient EventMulticaster modelListeners = new EventMulticaster();

    public SingletonDataSetManager(DataSet dataSet, Column column) {
        this(dataSet, column, null);
    }

    public SingletonDataSetManager(DataSet dataSet, Column column, Component component) {
        this.dataSet = dataSet;
        this.dataSetModel = new DataSetModel(dataSet, column, component);
    }

    public Object get() {
        return this.dataSetModel.get();
    }

    public void addModelListener(SingletonModelListener listener) {
        this.modelListeners.add((EventListener)listener);
        if (this.modelListeners.getListenerCount() == 1) {
            this.dataSet.addDataChangeListener((DataChangeListener)this);
            this.dataSet.addNavigationListener((NavigationListener)this);
        }
    }

    public void removeModelListener(SingletonModelListener listener) {
        this.modelListeners.remove((EventListener)listener);
        if (this.modelListeners.getListenerCount() == 0) {
            this.dataSet.removeDataChangeListener((DataChangeListener)this);
            this.dataSet.removeNavigationListener((NavigationListener)this);
        }
    }

    public boolean canSet(boolean startEdit) {
        return this.dataSetModel.canSet(startEdit);
    }

    public void set(Object data) {
        this.dataSetModel.set(data);
        this.processModelEvent();
    }

    public void touched() {
        this.processModelEvent();
    }

    public void enableModelEvents(boolean enable) {
        if (this.events != enable) {
            this.events = enable;
            if (enable) {
                this.processModelEvent();
            }
        }
    }

    public ItemPainter getPainter(Object value, int state) {
        return this.dataSetModel.getPainter(value);
    }

    public ItemEditor getEditor(Object value, int state) {
        return this.dataSetModel.getEditor();
    }

    private void processModelEvent() {
        if (this.events && this.modelListeners.hasListeners()) {
            this.modelListeners.dispatch((DispatchableEvent)this.singletonModelEvent);
        }
    }

    public void dataChanged(DataChangeEvent e2) {
        this.processModelEvent();
    }

    public void postRow(DataChangeEvent e2) throws Exception {
    }

    public void navigated(NavigationEvent event) {
        this.processModelEvent();
    }

    public void handleException(Exception x) {
        this.dataSetModel.handleThisException(x);
    }
}

