/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.editors;

import com.borland.jb.util.VetoException;
import com.borland.jbcl.control.ButtonControl;
import com.borland.jbcl.control.TreeControl;
import com.borland.jbcl.editors.Res;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.borland.jbcl.model.BasicTreeContainer;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphSubfocusEvent;
import com.borland.jbcl.model.GraphSubfocusListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TreeItemsEditorPanel
extends JComponent
implements ActionListener,
GraphSubfocusListener {
    TreeControl tree = new TreeControl();
    JPanel butPan = new JPanel();
    ButtonControl add = new ButtonControl();
    ButtonControl remove = new ButtonControl();
    ButtonControl up = new ButtonControl();
    ButtonControl down = new ButtonControl();

    public TreeItemsEditorPanel() {
        this.butPan.setLayout(new VerticalFlowLayout());
        this.butPan.add(this.add);
        this.butPan.add(this.remove);
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)this.tree, "Center");
        this.add((Component)this.butPan, "East");
        this.tree.setExpandByDefault(true);
        this.tree.setShowRollover(true);
        this.tree.addSubfocusListener(this);
        this.up.setLabel(Res._MoveNodeUp);
        this.up.addActionListener(this);
        this.down.setLabel(Res._MoveNodeDown);
        this.down.addActionListener(this);
        this.add.setLabel(Res._AddChild);
        this.add.addActionListener(this);
        this.remove.setLabel(Res._RemoveNode);
        this.remove.addActionListener(this);
        this.checkButtons();
    }

    public void actionPerformed(ActionEvent e2) {
        Object target = e2.getSource();
        if (target == this.remove) {
            if (this.tree.getSubfocus() != this.tree.getRoot()) {
                this.tree.remove(this.tree.getSubfocus());
            }
        } else if (target == this.add) {
            this.tree.addChild(this.tree.getSubfocus(), Res._NewChild);
        } else if (target == this.down) {
            GraphLocation parent = this.tree.getSubfocus().getParent();
            GraphLocation[] children = parent.getChildren();
            BasicTreeContainer temp = new BasicTreeContainer(this.tree.getSubfocus());
            for (int i2 = 0; i2 < children.length; ++i2) {
                if (children[i2] != this.tree.getSubfocus()) continue;
                this.tree.remove(this.tree.getSubfocus());
                if (i2 > 0 && i2 == children.length - 1) {
                    this.tree.addChild(parent, children[0], temp.getRoot());
                    continue;
                }
                if (i2 == children.length - 2) {
                    this.tree.addChild(parent, temp.getRoot());
                    continue;
                }
                if (i2 >= children.length - 2) continue;
                this.tree.addChild(parent, children[i2 + 2], temp.getRoot());
            }
            this.tree.setSubfocus(this.tree.getSubfocus());
        } else if (target == this.up) {
            GraphLocation parent = this.tree.getSubfocus().getParent();
            GraphLocation[] children = parent.getChildren();
            BasicTreeContainer temp = new BasicTreeContainer(this.tree.getSubfocus());
            for (int i3 = 0; i3 < children.length; ++i3) {
                if (children[i3] != this.tree.getSubfocus()) continue;
                this.tree.remove(this.tree.getSubfocus());
                if (i3 > 0) {
                    this.tree.addChild(parent, children[i3 - 1], temp.getRoot());
                    continue;
                }
                this.tree.addChild(parent, temp.getRoot());
            }
            this.tree.setSubfocus(this.tree.getSubfocus());
        }
        this.checkButtons();
    }

    public Insets getInsets() {
        return new Insets(10, 10, 5, 10);
    }

    void checkButtons() {
        GraphLocation root;
        GraphLocation sf = this.tree.getSubfocus();
        this.remove.setEnabled(sf != (root = this.tree.getRoot()));
        this.up.setEnabled(sf != root);
    }

    public void subfocusChanging(GraphSubfocusEvent e2) throws VetoException {
    }

    public void subfocusChanged(GraphSubfocusEvent e2) {
        this.checkButtons();
    }
}

