/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public final class SkinToolTipUI
extends BasicToolTipUI {
    static SkinToolTipUI sharedInstance = new SkinToolTipUI();
    private Font smallFont;
    private JToolTip tip;
    public static final int padSpaceBetweenStrings = 12;
    private String acceleratorDelimiter;

    public static ComponentUI createUI(JComponent c) {
        return sharedInstance;
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.tip = (JToolTip)c;
        Font f = c.getFont();
        this.smallFont = new Font(f.getName(), f.getStyle(), f.getSize() - 2);
        this.acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this.acceleratorDelimiter == null) {
            this.acceleratorDelimiter = "-";
        }
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        Font font = c.getFont();
        FontMetrics metrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        String keyText = this.getAcceleratorString();
        String tipText = ((JToolTip)c).getTipText();
        if (tipText == null) {
            tipText = "";
        }
        if (!keyText.equals("")) {
            g.setFont(this.smallFont);
            g.setColor(c.getForeground());
            g.drawString(keyText, metrics.stringWidth(tipText) + 12, 2 + metrics.getAscent());
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        String key = this.getAcceleratorString();
        if (!key.equals("")) {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(this.smallFont);
            d.width += fm.stringWidth(key) + 12;
        }
        return d;
    }

    public String getAcceleratorString() {
        int mnemonic;
        JComponent comp = this.tip.getComponent();
        if (comp == null) {
            return "";
        }
        KeyStroke[] keys = comp.getRegisteredKeyStrokes();
        String controlKeyStr = "";
        for (int i = 0; i < keys.length; ++i) {
            int mod = keys[i].getModifiers();
            int condition = comp.getConditionForKeyStroke(keys[i]);
            if (condition != 2 || (mod & 8) == 0 && (mod & 2) == 0 && (mod & 1) == 0 && (mod & 4) == 0) continue;
            controlKeyStr = KeyEvent.getKeyModifiersText(mod) + this.acceleratorDelimiter + (char)keys[i].getKeyCode();
            break;
        }
        if (controlKeyStr.equals("") && comp instanceof JMenuItem && (mnemonic = ((JMenuItem)comp).getMnemonic()) != 0) {
            controlKeyStr = "Alt" + this.acceleratorDelimiter + (char)mnemonic;
        }
        return controlKeyStr;
    }
}

