/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.model;

import com.borland.jb.util.DispatchableEvent;
import com.borland.jb.util.EventMulticaster;
import com.borland.jbcl.model.GraphLocation;
import com.borland.jbcl.model.GraphSelectionEvent;
import com.borland.jbcl.model.GraphSelectionListener;
import com.borland.jbcl.model.WritableGraphSelection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;

public class SingleGraphSelection
implements WritableGraphSelection,
Serializable {
    private static final long serialVersionUID = 200L;
    private transient GraphLocation item;
    private transient EventMulticaster selectionListeners = new EventMulticaster();
    private boolean events = true;

    public SingleGraphSelection() {
    }

    public SingleGraphSelection(GraphLocation newItem) {
        this.item = newItem;
    }

    public boolean contains(GraphLocation location) {
        return location.equals(this.item);
    }

    public int getCount() {
        return this.item != null ? 1 : 0;
    }

    public GraphLocation[] getAll() {
        GraphLocation[] contents = new GraphLocation[this.item != null ? 1 : 0];
        if (this.item != null) {
            contents[0] = this.item;
        }
        return contents;
    }

    public void addSelectionListener(GraphSelectionListener listener) {
        this.selectionListeners.add((EventListener)listener);
    }

    public void removeSelectionListener(GraphSelectionListener listener) {
        this.selectionListeners.remove((EventListener)listener);
    }

    public void set(GraphLocation[] locations) {
        this.add(locations);
    }

    public void add(GraphLocation location) {
        if (!location.equals(this.item)) {
            this.item = location;
            this.processSelectionEvent(new GraphSelectionEvent(this, 12290));
        }
    }

    public void add(GraphLocation[] locations) {
        if (locations.length > 0 && !locations[0].equals(this.item)) {
            this.item = locations[0];
            this.processSelectionEvent(new GraphSelectionEvent(this, 12290));
        }
    }

    public void remove(GraphLocation location) {
        if (location.equals(this.item)) {
            this.item = null;
            this.processSelectionEvent(new GraphSelectionEvent(this, 12289));
        }
    }

    public void remove(GraphLocation[] locations) {
        for (int i2 = 0; i2 < locations.length; ++i2) {
            if (!locations[i2].equals(this.item)) continue;
            this.item = null;
            this.processSelectionEvent(new GraphSelectionEvent(this, 12289));
            return;
        }
    }

    public void removeAll() {
        if (this.item != null) {
            this.item = null;
            this.processSelectionEvent(new GraphSelectionEvent(this, 12289));
        }
    }

    public void enableSelectionEvents(boolean enable) {
        this.events = enable;
        if (this.events) {
            this.processSelectionEvent(new GraphSelectionEvent(this, 12290));
        }
    }

    protected void processSelectionEvent(GraphSelectionEvent e2) {
        if (this.events && this.selectionListeners.hasListeners()) {
            this.selectionListeners.dispatch((DispatchableEvent)e2);
        }
    }

    public final String toString() {
        String cn = this.getClass().getName();
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(cn.substring(cn.lastIndexOf(46) + 1)))).append("[").append(this.paramString()).append("]")));
    }

    protected String paramString() {
        return "item=".concat(String.valueOf(String.valueOf(this.item)));
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.item instanceof Serializable ? this.item : null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        Object data = s.readObject();
        if (data instanceof GraphLocation) {
            this.item = (GraphLocation)data;
        }
    }

    static {
        serialVersionUID = 200L;
    }
}

