/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.resources.ResourceManager;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.SmartSecurityDialog;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.ExtendedService;
import javax.jnlp.FileContents;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class ExtendedServiceImpl
implements ExtendedService {
    private static ExtendedServiceImpl _sharedInstance = null;
    private static int DEFAULT_FILESIZE = Integer.MAX_VALUE;

    private ExtendedServiceImpl() {
    }

    public static synchronized ExtendedServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new ExtendedServiceImpl();
        }
        return _sharedInstance;
    }

    public FileContents openFile(final File file) throws IOException {
        if (!this.askUser(file.getPath())) {
            return null;
        }
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return new FileContentsImpl(file, DEFAULT_FILESIZE);
                }
                catch (IOException iOException) {
                    return iOException;
                }
            }
        });
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        return (FileContents)t;
    }

    synchronized boolean askUser(String string) {
        SmartSecurityDialog smartSecurityDialog = new SmartSecurityDialog();
        JTextArea jTextArea = new JTextArea(4, 30);
        jTextArea.setFont(ResourceManager.getUIFont());
        jTextArea.setEditable(false);
        jTextArea.append(string);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        String string2 = ResourceManager.getString((String)"APIImpl.extended.fileOpen.message1");
        String string3 = ResourceManager.getString((String)"APIImpl.extended.fileOpen.message2");
        Object[] objectArray = new Object[]{string2, jScrollPane, string3};
        return smartSecurityDialog.showDialog(objectArray);
    }

    public FileContents[] openFiles(final File[] fileArray) throws IOException {
        if (fileArray == null || fileArray.length <= 0) {
            return null;
        }
        String string = "";
        for (int i = 0; i < fileArray.length; ++i) {
            string = string + fileArray[i].getPath() + "\n";
        }
        if (!this.askUser(string)) {
            return null;
        }
        Object[] objectArray = (Object[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileContents[] fileContentsArray = new FileContents[fileArray.length];
                try {
                    for (int i = 0; i < fileArray.length; ++i) {
                        fileContentsArray[i] = new FileContentsImpl(fileArray[i], DEFAULT_FILESIZE);
                    }
                }
                catch (IOException iOException) {
                    fileContentsArray[0] = iOException;
                }
                return fileContentsArray;
            }
        });
        if (objectArray[0] instanceof IOException) {
            throw (IOException)objectArray[0];
        }
        return (FileContents[])objectArray;
    }
}

