/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import sun.awt.image.GifFrame;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFetcher;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.NativeLibLoader;

public class GifImageDecoder
extends ImageDecoder {
    private static final boolean verbose = false;
    private static final int IMAGESEP = 44;
    private static final int EXBLOCK = 33;
    private static final int EX_GRAPHICS_CONTROL = 249;
    private static final int EX_COMMENT = 254;
    private static final int EX_APPLICATION = 255;
    private static final int TERMINATOR = 59;
    private static final int TRANSPARENCYMASK = 1;
    private static final int INTERLACEMASK = 64;
    private static final int COLORMAPMASK = 128;
    int num_global_colors;
    byte[] global_colormap;
    int trans_pixel = -1;
    IndexColorModel global_model;
    Hashtable props = new Hashtable();
    byte[] saved_image;
    IndexColorModel saved_model;
    int global_width;
    int global_height;
    int global_bgpixel;
    GifFrame curframe;
    private static final int normalflags = 30;
    private static final int interlaceflags = 29;
    private short[] prefix = new short[4096];
    private byte[] suffix = new byte[4096];
    private byte[] outCode = new byte[4097];

    public GifImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) {
        super(inputStreamImageSource, inputStream);
    }

    private static void error(String string) throws ImageFormatException {
        throw new ImageFormatException(string);
    }

    private int readBytes(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            try {
                int n4 = this.input.read(byArray, n2, n3);
                if (n4 < 0) break;
                n2 += n4;
                n3 -= n4;
            }
            catch (IOException iOException) {
                break;
            }
        }
        return n3;
    }

    private static final int ExtractByte(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF;
    }

    private static final int ExtractWord(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void produceImage() throws IOException, ImageFormatException {
        try {
            this.readHeader();
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            int n6 = -1;
            boolean bl2 = false;
            boolean bl3 = false;
            while (!this.aborted) {
                int n7 = this.input.read();
                switch (n7) {
                    case 33: {
                        n7 = this.input.read();
                        switch (n7) {
                            case 249: {
                                byte[] byArray = new byte[6];
                                if (this.readBytes(byArray, 0, 6) != 0) {
                                    return;
                                }
                                if (byArray[0] != 4 || byArray[5] != 0) {
                                    return;
                                }
                                n6 = GifImageDecoder.ExtractWord(byArray, 2) * 10;
                                if (n6 > 0 && !bl3) {
                                    bl3 = true;
                                    ImageFetcher.startingAnimation();
                                }
                                n5 = byArray[1] >> 2 & 7;
                                if ((byArray[1] & 1) != 0) {
                                    this.trans_pixel = GifImageDecoder.ExtractByte(byArray, 4);
                                    break;
                                }
                                this.trans_pixel = -1;
                                break;
                            }
                            default: {
                                int n8;
                                boolean bl4 = false;
                                String string = "";
                                while ((n8 = this.input.read()) > 0) {
                                    byte[] byArray = new byte[n8];
                                    if (this.readBytes(byArray, 0, n8) != 0) {
                                        return;
                                    }
                                    if (n7 == 254) {
                                        string = string + new String(byArray, 0);
                                        continue;
                                    }
                                    if (n7 != 255) continue;
                                    if (bl4) {
                                        if (n8 == 3 && byArray[0] == 1) {
                                            if (bl2) {
                                                GifImageDecoder.ExtractWord(byArray, 1);
                                            } else {
                                                n4 = GifImageDecoder.ExtractWord(byArray, 1);
                                                bl2 = true;
                                            }
                                        } else {
                                            bl4 = false;
                                        }
                                    }
                                    if (!"NETSCAPE2.0".equals(new String(byArray, 0))) continue;
                                    bl4 = true;
                                }
                                if (n7 == 254) {
                                    this.props.put("comment", string);
                                }
                                if (!bl4 || bl3) break;
                                bl3 = true;
                                ImageFetcher.startingAnimation();
                                break;
                            }
                            case -1: {
                                return;
                            }
                        }
                        break;
                    }
                    case 44: {
                        if (!bl3) {
                            this.input.mark(0);
                        }
                        try {
                            if (!this.readImage(n2 == 0, n5, n6)) {
                                return;
                            }
                        }
                        catch (Exception exception) {
                            return;
                        }
                        ++n3;
                        ++n2;
                        break;
                    }
                    default: {
                        if (n3 == 0) {
                            return;
                        }
                    }
                    case 59: {
                        if (n4 == 0 || n4-- >= 0) {
                            try {
                                if (this.curframe != null) {
                                    this.curframe.dispose();
                                    this.curframe = null;
                                }
                                this.input.reset();
                                this.saved_image = null;
                                this.saved_model = null;
                                n3 = 0;
                                break;
                            }
                            catch (IOException iOException) {
                                this.close();
                                return;
                            }
                        }
                        this.imageComplete(3, true);
                        return;
                    }
                }
            }
        }
        finally {
            this.close();
        }
    }

    private void readHeader() throws IOException, ImageFormatException {
        byte[] byArray = new byte[13];
        if (this.readBytes(byArray, 0, 13) != 0) {
            throw new IOException();
        }
        if (byArray[0] != 71 || byArray[1] != 73 || byArray[2] != 70) {
            GifImageDecoder.error("not a GIF file.");
        }
        this.global_width = GifImageDecoder.ExtractWord(byArray, 6);
        this.global_height = GifImageDecoder.ExtractWord(byArray, 8);
        int n2 = GifImageDecoder.ExtractByte(byArray, 10);
        if ((n2 & 0x80) == 0) {
            this.num_global_colors = 2;
            this.global_bgpixel = 0;
            this.global_colormap = new byte[6];
            this.global_colormap[2] = 0;
            this.global_colormap[1] = 0;
            this.global_colormap[0] = 0;
            this.global_colormap[5] = -1;
            this.global_colormap[4] = -1;
            this.global_colormap[3] = -1;
        } else {
            this.num_global_colors = 1 << (n2 & 7) + 1;
            this.global_bgpixel = GifImageDecoder.ExtractByte(byArray, 11);
            if (byArray[12] != 0) {
                this.props.put("aspectratio", "" + (double)(GifImageDecoder.ExtractByte(byArray, 12) + 15) / 64.0);
            }
            this.global_colormap = new byte[this.num_global_colors * 3];
            if (this.readBytes(this.global_colormap, 0, this.num_global_colors * 3) != 0) {
                throw new IOException();
            }
        }
        this.input.mark(Integer.MAX_VALUE);
    }

    private static native void initIDs();

    private native boolean parseImage(int var1, int var2, int var3, int var4, boolean var5, int var6, byte[] var7, byte[] var8, IndexColorModel var9);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int sendPixels(int n2, int n3, int n4, int n5, byte[] byArray, ColorModel colorModel) {
        boolean bl2;
        int n6;
        int n7;
        if (n3 < 0) {
            n5 += n3;
            n3 = 0;
        }
        if (n3 + n5 > this.global_height) {
            n5 = this.global_height - n3;
        }
        if (n5 <= 0) {
            return 1;
        }
        if (n2 < 0) {
            n7 = -n2;
            n4 += n2;
            n6 = 0;
        } else {
            n7 = 0;
            n6 = n2;
        }
        if (n6 + n4 > this.global_width) {
            n4 = this.global_width - n6;
        }
        if (n4 <= 0) {
            return 1;
        }
        int n8 = n7 + n4;
        int n9 = n3 * this.global_width + n6;
        boolean bl3 = bl2 = this.curframe.disposal_method == 1;
        if (this.trans_pixel >= 0 && !this.curframe.initialframe) {
            if (this.saved_image != null && this.saved_model == colorModel) {
                int n10 = n7;
                while (n10 < n8) {
                    byte by = byArray[n10];
                    if ((by & 0xFF) == this.trans_pixel) {
                        byArray[n10] = this.saved_image[n9];
                    } else if (bl2) {
                        this.saved_image[n9] = by;
                    }
                    ++n10;
                    ++n9;
                }
                return this.setPixels(n6, n3, n4, n5, colorModel, byArray, n7, 0);
            }
            int n11 = -1;
            int n12 = 1;
            int n13 = n7;
            while (n13 < n8) {
                byte by = byArray[n13];
                if ((by & 0xFF) == this.trans_pixel) {
                    if (n11 >= 0 && (n12 = this.setPixels(n2 + n11, n3, n13 - n11, n5, colorModel, byArray, n11, 0)) == 0) break;
                    n11 = -1;
                } else {
                    if (n11 < 0) {
                        n11 = n13;
                    }
                    if (bl2) {
                        this.saved_image[n9] = by;
                    }
                }
                ++n13;
                ++n9;
            }
            if (n11 < 0) return n12;
            return this.setPixels(n2 + n11, n3, n8 - n11, n5, colorModel, byArray, n11, 0);
        }
        if (!bl2) return this.setPixels(n6, n3, n4, n5, colorModel, byArray, n7, 0);
        System.arraycopy(byArray, n7, this.saved_image, n9, n4);
        return this.setPixels(n6, n3, n4, n5, colorModel, byArray, n7, 0);
    }

    private boolean readImage(boolean bl2, int n2, int n3) throws IOException {
        int n4;
        byte[] byArray;
        int n5;
        if (this.curframe != null && !this.curframe.dispose()) {
            this.abort();
            return false;
        }
        long l2 = 0L;
        byte[] byArray2 = new byte[259];
        if (this.readBytes(byArray2, 0, 10) != 0) {
            throw new IOException();
        }
        int n6 = GifImageDecoder.ExtractWord(byArray2, 0);
        int n7 = GifImageDecoder.ExtractWord(byArray2, 2);
        int n8 = GifImageDecoder.ExtractWord(byArray2, 4);
        int n9 = GifImageDecoder.ExtractWord(byArray2, 6);
        boolean bl3 = (byArray2[8] & 0x40) != 0;
        IndexColorModel indexColorModel = this.global_model;
        if ((byArray2[8] & 0x80) != 0) {
            n5 = 1 << (byArray2[8] & 7) + 1;
            byArray = new byte[n5 * 3];
            byArray[0] = byArray2[9];
            if (this.readBytes(byArray, 1, n5 * 3 - 1) != 0) {
                throw new IOException();
            }
            if (this.readBytes(byArray2, 9, 1) != 0) {
                throw new IOException();
            }
            if (this.trans_pixel >= n5) {
                n5 = this.trans_pixel + 1;
                byArray = GifImageDecoder.grow_colormap(byArray, n5);
            }
            indexColorModel = new IndexColorModel(8, n5, byArray, 0, false, this.trans_pixel);
        } else if (indexColorModel == null || this.trans_pixel != indexColorModel.getTransparentPixel()) {
            if (this.trans_pixel >= this.num_global_colors) {
                this.num_global_colors = this.trans_pixel + 1;
                this.global_colormap = GifImageDecoder.grow_colormap(this.global_colormap, this.num_global_colors);
            }
            this.global_model = indexColorModel = new IndexColorModel(8, this.num_global_colors, this.global_colormap, 0, false, this.trans_pixel);
        }
        if (bl2) {
            if (this.global_width == 0) {
                this.global_width = n8;
            }
            if (this.global_height == 0) {
                this.global_height = n9;
            }
            this.setDimensions(this.global_width, this.global_height);
            this.setProperties(this.props);
            this.setColorModel(indexColorModel);
            this.headerComplete();
        }
        if (n2 == 1 && this.saved_image == null) {
            this.saved_image = new byte[this.global_width * this.global_height];
            if (n9 < this.global_height && indexColorModel != null && (n5 = (int)((byte)indexColorModel.getTransparentPixel())) >= 0) {
                byArray = new byte[this.global_width];
                for (n4 = 0; n4 < this.global_width; n4 += 1) {
                    byArray[n4] = n5;
                }
                this.setPixels(0, 0, this.global_width, n7, (ColorModel)indexColorModel, byArray, 0, 0);
                this.setPixels(0, n7 + n9, this.global_width, this.global_height - n9 - n7, (ColorModel)indexColorModel, byArray, 0, 0);
            }
        }
        n5 = bl3 ? 29 : 30;
        this.setHints(n5);
        this.curframe = new GifFrame(this, n2, n3, this.curframe == null, indexColorModel, n6, n7, n8, n9);
        byArray = new byte[n8];
        n4 = this.parseImage(n6, n7, n8, n9, bl3, GifImageDecoder.ExtractByte(byArray2, 9), byArray2, byArray, indexColorModel) ? 1 : 0;
        if (!n4) {
            this.abort();
        }
        return n4 != 0;
    }

    public static byte[] grow_colormap(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2 * 3];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    static {
        NativeLibLoader.loadLibraries();
        GifImageDecoder.initIDs();
    }
}

