/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.io.IOException;
import java.io.Reader;

class CSSParser {
    private static final int IDENTIFIER = 1;
    private static final int BRACKET_OPEN = 2;
    private static final int BRACKET_CLOSE = 3;
    private static final int BRACE_OPEN = 4;
    private static final int BRACE_CLOSE = 5;
    private static final int PAREN_OPEN = 6;
    private static final int PAREN_CLOSE = 7;
    private static final int END = -1;
    private static final char[] charMapping = new char[]{'\u0000', '\u0000', '[', ']', '{', '}', '(', ')', '\u0000'};
    private boolean didPushChar;
    private int pushedChar;
    private StringBuffer unitBuffer;
    private int[] unitStack = new int[2];
    private int stackCount;
    private Reader reader;
    private boolean encounteredRuleSet;
    private CSSParserCallback callback;
    private char[] tokenBuffer = new char[80];
    private int tokenBufferLength;
    private boolean readWS;

    CSSParser() {
        this.unitBuffer = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(Reader reader, CSSParserCallback cSSParserCallback, boolean bl2) throws IOException {
        this.callback = cSSParserCallback;
        this.tokenBufferLength = 0;
        this.stackCount = 0;
        this.reader = reader;
        this.encounteredRuleSet = false;
        try {
            if (bl2) {
                this.parseDeclarationBlock();
            } else {
                while (this.getNextStatement()) {
                }
            }
        }
        finally {
            cSSParserCallback = null;
            reader = null;
        }
    }

    private boolean getNextStatement() throws IOException {
        this.unitBuffer.setLength(0);
        int n2 = this.nextToken('\u0000');
        switch (n2) {
            case 1: {
                if (this.tokenBufferLength > 0) {
                    if (this.tokenBuffer[0] == '@') {
                        this.parseAtRule();
                    } else {
                        this.encounteredRuleSet = true;
                        this.parseRuleSet();
                    }
                }
                return true;
            }
            case 2: 
            case 4: 
            case 6: {
                this.parseTillClosed(n2);
                return true;
            }
            case 3: 
            case 5: 
            case 7: {
                throw new RuntimeException("Unexpected top level block close");
            }
            case -1: {
                return false;
            }
        }
        return true;
    }

    private void parseAtRule() throws IOException {
        boolean bl2 = false;
        boolean bl3 = this.tokenBufferLength == 7 && this.tokenBuffer[0] == '@' && this.tokenBuffer[1] == 'i' && this.tokenBuffer[2] == 'm' && this.tokenBuffer[3] == 'p' && this.tokenBuffer[4] == 'o' && this.tokenBuffer[5] == 'r' && this.tokenBuffer[6] == 't';
        this.unitBuffer.setLength(0);
        block7: while (!bl2) {
            int n2 = this.nextToken(';');
            switch (n2) {
                case 1: {
                    if (this.tokenBufferLength > 0 && this.tokenBuffer[this.tokenBufferLength - 1] == ';') {
                        --this.tokenBufferLength;
                        bl2 = true;
                    }
                    if (this.tokenBufferLength <= 0) break;
                    if (this.unitBuffer.length() > 0 && this.readWS) {
                        this.unitBuffer.append(' ');
                    }
                    this.unitBuffer.append(this.tokenBuffer, 0, this.tokenBufferLength);
                    break;
                }
                case 4: {
                    if (this.unitBuffer.length() > 0 && this.readWS) {
                        this.unitBuffer.append(' ');
                    }
                    this.unitBuffer.append(charMapping[n2]);
                    this.parseTillClosed(n2);
                    bl2 = true;
                    int n3 = this.readWS();
                    if (n3 == -1 || n3 == 59) continue block7;
                    this.pushChar(n3);
                    break;
                }
                case 2: 
                case 6: {
                    this.unitBuffer.append(charMapping[n2]);
                    this.parseTillClosed(n2);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    throw new RuntimeException("Unexpected close in @ rule");
                }
                case -1: {
                    bl2 = true;
                }
            }
        }
        if (bl3 && !this.encounteredRuleSet) {
            this.callback.handleImport(this.unitBuffer.toString());
        }
    }

    private void parseRuleSet() throws IOException {
        if (this.parseSelectors()) {
            this.callback.startRule();
            this.parseDeclarationBlock();
            this.callback.endRule();
        }
    }

    private boolean parseSelectors() throws IOException {
        if (this.tokenBufferLength > 0) {
            this.callback.handleSelector(new String(this.tokenBuffer, 0, this.tokenBufferLength));
        }
        this.unitBuffer.setLength(0);
        while (true) {
            int n2;
            if ((n2 = this.nextToken('\u0000')) == 1) {
                if (this.tokenBufferLength <= 0) continue;
                this.callback.handleSelector(new String(this.tokenBuffer, 0, this.tokenBufferLength));
                continue;
            }
            switch (n2) {
                case 4: {
                    return true;
                }
                case 2: 
                case 6: {
                    this.parseTillClosed(n2);
                    this.unitBuffer.setLength(0);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    throw new RuntimeException("Unexpected block close in selector");
                }
                case -1: {
                    return false;
                }
            }
        }
    }

    private void parseDeclarationBlock() throws IOException {
        while (true) {
            int n2 = this.parseDeclaration();
            switch (n2) {
                case -1: 
                case 5: {
                    return;
                }
                case 3: 
                case 7: {
                    throw new RuntimeException("Unexpected close in declaration block");
                }
            }
        }
    }

    private int parseDeclaration() throws IOException {
        int n2 = this.parseIdentifiers(':', false);
        if (n2 != 1) {
            return n2;
        }
        for (int i2 = this.unitBuffer.length() - 1; i2 >= 0; --i2) {
            this.unitBuffer.setCharAt(i2, Character.toLowerCase(this.unitBuffer.charAt(i2)));
        }
        this.callback.handleProperty(this.unitBuffer.toString());
        n2 = this.parseIdentifiers(';', true);
        this.callback.handleValue(this.unitBuffer.toString());
        return n2;
    }

    private int parseIdentifiers(char c2, boolean bl2) throws IOException {
        this.unitBuffer.setLength(0);
        while (true) {
            int n2 = this.nextToken(c2);
            switch (n2) {
                case 1: {
                    if (this.tokenBufferLength <= 0) break;
                    if (this.tokenBuffer[this.tokenBufferLength - 1] == c2) {
                        if (--this.tokenBufferLength > 0) {
                            if (this.readWS && this.unitBuffer.length() > 0) {
                                this.unitBuffer.append(' ');
                            }
                            this.unitBuffer.append(this.tokenBuffer, 0, this.tokenBufferLength);
                        }
                        return 1;
                    }
                    if (this.readWS && this.unitBuffer.length() > 0) {
                        this.unitBuffer.append(' ');
                    }
                    this.unitBuffer.append(this.tokenBuffer, 0, this.tokenBufferLength);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    int n3 = this.unitBuffer.length();
                    if (bl2) {
                        this.unitBuffer.append(charMapping[n2]);
                    }
                    this.parseTillClosed(n2);
                    if (bl2) break;
                    this.unitBuffer.setLength(n3);
                    break;
                }
                case -1: 
                case 3: 
                case 5: 
                case 7: {
                    return n2;
                }
            }
        }
    }

    private void parseTillClosed(int n2) throws IOException {
        boolean bl2 = false;
        this.startBlock(n2);
        while (!bl2) {
            int n3 = this.nextToken('\u0000');
            switch (n3) {
                case 1: {
                    if (this.unitBuffer.length() > 0 && this.readWS) {
                        this.unitBuffer.append(' ');
                    }
                    if (this.tokenBufferLength <= 0) break;
                    this.unitBuffer.append(this.tokenBuffer, 0, this.tokenBufferLength);
                    break;
                }
                case 2: 
                case 4: 
                case 6: {
                    if (this.unitBuffer.length() > 0 && this.readWS) {
                        this.unitBuffer.append(' ');
                    }
                    this.unitBuffer.append(charMapping[n3]);
                    this.startBlock(n3);
                    break;
                }
                case 3: 
                case 5: 
                case 7: {
                    if (this.unitBuffer.length() > 0 && this.readWS) {
                        this.unitBuffer.append(' ');
                    }
                    this.unitBuffer.append(charMapping[n3]);
                    this.endBlock(n3);
                    if (this.inBlock()) break;
                    bl2 = true;
                    break;
                }
                case -1: {
                    throw new RuntimeException("Unclosed block");
                }
            }
        }
    }

    private int nextToken(char c2) throws IOException {
        this.readWS = false;
        int n2 = this.readWS();
        switch (n2) {
            case 39: {
                this.readTill('\'');
                if (this.tokenBufferLength > 0) {
                    --this.tokenBufferLength;
                }
                return 1;
            }
            case 34: {
                this.readTill('\"');
                if (this.tokenBufferLength > 0) {
                    --this.tokenBufferLength;
                }
                return 1;
            }
            case 91: {
                return 2;
            }
            case 93: {
                return 3;
            }
            case 123: {
                return 4;
            }
            case 125: {
                return 5;
            }
            case 40: {
                return 6;
            }
            case 41: {
                return 7;
            }
            case -1: {
                return -1;
            }
        }
        this.pushChar(n2);
        this.getIdentifier(c2);
        return 1;
    }

    private boolean getIdentifier(char c2) throws IOException {
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = 0;
        char c3 = c2;
        int n4 = 0;
        this.tokenBufferLength = 0;
        while (!bl3) {
            int n5;
            int n6 = this.readChar();
            switch (n6) {
                case 92: {
                    n5 = 1;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    n5 = 2;
                    n4 = n6 - 48;
                    break;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    n5 = 2;
                    n4 = n6 - 97 + 10;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    n5 = 2;
                    n4 = n6 - 65 + 10;
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 34: 
                case 39: 
                case 40: 
                case 41: 
                case 91: 
                case 93: 
                case 123: 
                case 125: {
                    n5 = 3;
                    break;
                }
                case 47: {
                    n5 = 4;
                    break;
                }
                case -1: {
                    bl3 = true;
                    n5 = 0;
                    break;
                }
                default: {
                    n5 = 0;
                }
            }
            if (bl2) {
                if (n5 == 2) {
                    n3 = n3 * 16 + n4;
                    if (++n2 != 4) continue;
                    bl2 = false;
                    this.append((char)n3);
                    continue;
                }
                bl2 = false;
                if (n2 > 0) {
                    this.append((char)n3);
                    this.pushChar(n6);
                    continue;
                }
                if (bl3) continue;
                this.append((char)n6);
                continue;
            }
            if (bl3) continue;
            if (n5 == 1) {
                bl2 = true;
                n2 = 0;
                n3 = 0;
                continue;
            }
            if (n5 == 3) {
                bl3 = true;
                this.pushChar(n6);
                continue;
            }
            if (n5 == 4) {
                n6 = this.readChar();
                if (n6 == 42) {
                    bl3 = true;
                    this.readComment();
                    this.readWS = true;
                    continue;
                }
                this.append('/');
                if (n6 == -1) {
                    bl3 = true;
                    continue;
                }
                this.pushChar(n6);
                continue;
            }
            this.append((char)n6);
            if (n6 != c3) continue;
            bl3 = true;
        }
        return this.tokenBufferLength > 0;
    }

    private void readTill(char c2) throws IOException {
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = false;
        char c3 = c2;
        int n4 = 0;
        this.tokenBufferLength = 0;
        while (!bl3) {
            int n5;
            int n6 = this.readChar();
            switch (n6) {
                case 92: {
                    n5 = 1;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    n5 = 2;
                    n4 = n6 - 48;
                    break;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    n5 = 2;
                    n4 = n6 - 97 + 10;
                    break;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    n5 = 2;
                    n4 = n6 - 65 + 10;
                    break;
                }
                case -1: {
                    throw new RuntimeException("Unclosed " + c2);
                }
                default: {
                    n5 = 0;
                }
            }
            if (bl2) {
                if (n5 == 2) {
                    n3 = n3 * 16 + n4;
                    if (++n2 != 4) continue;
                    bl2 = false;
                    this.append((char)n3);
                    continue;
                }
                if (n2 > 0) {
                    this.append((char)n3);
                    if (n5 == 1) {
                        bl2 = true;
                        n2 = 0;
                        n3 = 0;
                        continue;
                    }
                    if (n6 == c3) {
                        bl3 = true;
                    }
                    this.append((char)n6);
                    bl2 = false;
                    continue;
                }
                this.append((char)n6);
                bl2 = false;
                continue;
            }
            if (n5 == 1) {
                bl2 = true;
                n2 = 0;
                n3 = 0;
                continue;
            }
            if (n6 == c3) {
                bl3 = true;
            }
            this.append((char)n6);
        }
    }

    private void append(char c2) {
        if (this.tokenBufferLength == this.tokenBuffer.length) {
            char[] cArray = new char[this.tokenBuffer.length * 2];
            System.arraycopy(this.tokenBuffer, 0, cArray, 0, this.tokenBuffer.length);
            this.tokenBuffer = cArray;
        }
        this.tokenBuffer[this.tokenBufferLength++] = c2;
    }

    private void readComment() throws IOException {
        block4: while (true) {
            int n2 = this.readChar();
            switch (n2) {
                case -1: {
                    throw new RuntimeException("Unclosed comment");
                }
                case 42: {
                    n2 = this.readChar();
                    if (n2 == 47) {
                        return;
                    }
                    if (n2 == -1) {
                        throw new RuntimeException("Unclosed comment");
                    }
                    this.pushChar(n2);
                    continue block4;
                }
            }
        }
    }

    private void startBlock(int n2) {
        if (this.stackCount == this.unitStack.length) {
            int[] nArray = new int[this.stackCount * 2];
            System.arraycopy(this.unitStack, 0, nArray, 0, this.stackCount);
            this.unitStack = nArray;
        }
        this.unitStack[this.stackCount++] = n2;
    }

    private void endBlock(int n2) {
        int n3;
        switch (n2) {
            case 3: {
                n3 = 2;
                break;
            }
            case 5: {
                n3 = 4;
                break;
            }
            case 7: {
                n3 = 6;
                break;
            }
            default: {
                n3 = -1;
            }
        }
        if (this.stackCount > 0 && this.unitStack[this.stackCount - 1] == n3) {
            --this.stackCount;
        } else {
            throw new RuntimeException("Unmatched block");
        }
    }

    private boolean inBlock() {
        return this.stackCount > 0;
    }

    private int readWS() throws IOException {
        int n2;
        while ((n2 = this.readChar()) != -1 && Character.isWhitespace((char)n2)) {
            this.readWS = true;
        }
        return n2;
    }

    private int readChar() throws IOException {
        if (this.didPushChar) {
            this.didPushChar = false;
            return this.pushedChar;
        }
        return this.reader.read();
    }

    private void pushChar(int n2) {
        if (this.didPushChar) {
            throw new RuntimeException("Can not handle look ahead of more than one character");
        }
        this.didPushChar = true;
        this.pushedChar = n2;
    }

    static interface CSSParserCallback {
        public void handleImport(String var1);

        public void handleSelector(String var1);

        public void startRule();

        public void handleProperty(String var1);

        public void handleValue(String var1);

        public void endRule();
    }
}

