/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import com.sun.media.sound.MidiUtils;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Patch;
import javax.sound.midi.Track;

public class Sequence {
    public static final float PPQ = 0.0f;
    public static final float SMPTE_24 = 24.0f;
    public static final float SMPTE_25 = 25.0f;
    public static final float SMPTE_30DROP = 29.97f;
    public static final float SMPTE_30 = 30.0f;
    protected float divisionType;
    protected int resolution;
    protected Vector<Track> tracks = new Vector();

    public Sequence(float f2, int n2) throws InvalidMidiDataException {
        if (f2 == 0.0f) {
            this.divisionType = 0.0f;
        } else if (f2 == 24.0f) {
            this.divisionType = 24.0f;
        } else if (f2 == 25.0f) {
            this.divisionType = 25.0f;
        } else if (f2 == 29.97f) {
            this.divisionType = 29.97f;
        } else if (f2 == 30.0f) {
            this.divisionType = 30.0f;
        } else {
            throw new InvalidMidiDataException("Unsupported division type: " + f2);
        }
        this.resolution = n2;
    }

    public Sequence(float f2, int n2, int n3) throws InvalidMidiDataException {
        if (f2 == 0.0f) {
            this.divisionType = 0.0f;
        } else if (f2 == 24.0f) {
            this.divisionType = 24.0f;
        } else if (f2 == 25.0f) {
            this.divisionType = 25.0f;
        } else if (f2 == 29.97f) {
            this.divisionType = 29.97f;
        } else if (f2 == 30.0f) {
            this.divisionType = 30.0f;
        } else {
            throw new InvalidMidiDataException("Unsupported division type: " + f2);
        }
        this.resolution = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            this.tracks.addElement(new Track());
        }
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public Track createTrack() {
        Track track = new Track();
        this.tracks.addElement(track);
        return track;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTrack(Track track) {
        Vector<Track> vector = this.tracks;
        synchronized (vector) {
            return this.tracks.removeElement(track);
        }
    }

    public Track[] getTracks() {
        return this.tracks.toArray(new Track[this.tracks.size()]);
    }

    public long getMicrosecondLength() {
        return MidiUtils.tick2microsecond(this, this.getTickLength(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTickLength() {
        long l2 = 0L;
        Vector<Track> vector = this.tracks;
        synchronized (vector) {
            for (int i2 = 0; i2 < this.tracks.size(); ++i2) {
                long l3 = this.tracks.elementAt(i2).ticks();
                if (l3 <= l2) continue;
                l2 = l3;
            }
            return l2;
        }
    }

    public Patch[] getPatchList() {
        return new Patch[0];
    }
}

