/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import java.util.regex.MatchResult;
import java.util.regex.Pattern;

public final class Matcher
implements MatchResult {
    Pattern parentPattern;
    int[] groups;
    int from;
    int to;
    CharSequence text;
    static final int ENDANCHOR = 1;
    static final int NOANCHOR = 0;
    int acceptMode = 0;
    int first = -1;
    int last = 0;
    int oldLast = -1;
    int lastAppendPosition = 0;
    int[] locals;
    boolean hitEnd;
    boolean requireEnd;
    boolean transparentBounds = false;
    boolean anchoringBounds = true;

    Matcher() {
    }

    Matcher(Pattern pattern, CharSequence charSequence) {
        this.parentPattern = pattern;
        this.text = charSequence;
        int n2 = Math.max(pattern.capturingGroupCount, 10);
        this.groups = new int[n2 * 2];
        this.locals = new int[pattern.localCount];
        this.reset();
    }

    public Pattern pattern() {
        return this.parentPattern;
    }

    public MatchResult toMatchResult() {
        Matcher matcher = new Matcher(this.parentPattern, ((Object)this.text).toString());
        matcher.first = this.first;
        matcher.last = this.last;
        matcher.groups = (int[])this.groups.clone();
        return matcher;
    }

    public Matcher usePattern(Pattern pattern) {
        int n2;
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern cannot be null");
        }
        this.parentPattern = pattern;
        int n3 = Math.max(pattern.capturingGroupCount, 10);
        this.groups = new int[n3 * 2];
        this.locals = new int[pattern.localCount];
        for (n2 = 0; n2 < this.groups.length; ++n2) {
            this.groups[n2] = -1;
        }
        for (n2 = 0; n2 < this.locals.length; ++n2) {
            this.locals[n2] = -1;
        }
        return this;
    }

    public Matcher reset() {
        int n2;
        this.first = -1;
        this.last = 0;
        this.oldLast = -1;
        for (n2 = 0; n2 < this.groups.length; ++n2) {
            this.groups[n2] = -1;
        }
        for (n2 = 0; n2 < this.locals.length; ++n2) {
            this.locals[n2] = -1;
        }
        this.lastAppendPosition = 0;
        this.from = 0;
        this.to = this.getTextLength();
        return this;
    }

    public Matcher reset(CharSequence charSequence) {
        this.text = charSequence;
        return this.reset();
    }

    public int start() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.first;
    }

    public int start(int n2) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (n2 > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + n2);
        }
        return this.groups[n2 * 2];
    }

    public int end() {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        return this.last;
    }

    public int end(int n2) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        if (n2 > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + n2);
        }
        return this.groups[n2 * 2 + 1];
    }

    public String group() {
        return this.group(0);
    }

    public String group(int n2) {
        if (this.first < 0) {
            throw new IllegalStateException("No match found");
        }
        if (n2 < 0 || n2 > this.groupCount()) {
            throw new IndexOutOfBoundsException("No group " + n2);
        }
        if (this.groups[n2 * 2] == -1 || this.groups[n2 * 2 + 1] == -1) {
            return null;
        }
        return ((Object)this.getSubSequence(this.groups[n2 * 2], this.groups[n2 * 2 + 1])).toString();
    }

    public int groupCount() {
        return this.parentPattern.capturingGroupCount - 1;
    }

    public boolean matches() {
        return this.match(this.from, 1);
    }

    public boolean find() {
        int n2 = this.last;
        if (n2 == this.first) {
            ++n2;
        }
        if (n2 < this.from) {
            n2 = this.from;
        }
        if (n2 > this.to) {
            for (int i2 = 0; i2 < this.groups.length; ++i2) {
                this.groups[i2] = -1;
            }
            return false;
        }
        return this.search(n2);
    }

    public boolean find(int n2) {
        int n3 = this.getTextLength();
        if (n2 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException("Illegal start index");
        }
        this.reset();
        return this.search(n2);
    }

    public boolean lookingAt() {
        return this.match(this.from, 0);
    }

    public static String quoteReplacement(String string) {
        if (string.indexOf(92) == -1 && string.indexOf(36) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append('\\');
                continue;
            }
            if (c2 == '$') {
                stringBuffer.append('\\');
                stringBuffer.append('$');
                continue;
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public Matcher appendReplacement(StringBuffer stringBuffer, String string) {
        if (this.first < 0) {
            throw new IllegalStateException("No match available");
        }
        int n2 = 0;
        String string2 = string;
        StringBuffer stringBuffer2 = new StringBuffer();
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 == '\\') {
                c2 = string.charAt(++n2);
                stringBuffer2.append(c2);
                ++n2;
                continue;
            }
            if (c2 == '$') {
                int n3;
                int n4;
                if ((n4 = string.charAt(++n2) - 48) < 0 || n4 > 9) {
                    throw new IllegalArgumentException("Illegal group reference");
                }
                ++n2;
                boolean bl2 = false;
                while (!bl2 && n2 < string.length() && (n3 = string.charAt(n2) - 48) >= 0 && n3 <= 9) {
                    int n5 = n4 * 10 + n3;
                    if (this.groupCount() < n5) {
                        bl2 = true;
                        continue;
                    }
                    n4 = n5;
                    ++n2;
                }
                if (this.group(n4) == null) continue;
                stringBuffer2.append(this.group(n4));
                continue;
            }
            stringBuffer2.append(c2);
            ++n2;
        }
        stringBuffer.append(this.getSubSequence(this.lastAppendPosition, this.first));
        stringBuffer.append(stringBuffer2.toString());
        this.lastAppendPosition = this.last;
        return this;
    }

    public StringBuffer appendTail(StringBuffer stringBuffer) {
        stringBuffer.append(((Object)this.getSubSequence(this.lastAppendPosition, this.getTextLength())).toString());
        return stringBuffer;
    }

    public String replaceAll(String string) {
        this.reset();
        boolean bl2 = this.find();
        if (bl2) {
            StringBuffer stringBuffer = new StringBuffer();
            do {
                this.appendReplacement(stringBuffer, string);
            } while (bl2 = this.find());
            this.appendTail(stringBuffer);
            return stringBuffer.toString();
        }
        return ((Object)this.text).toString();
    }

    public String replaceFirst(String string) {
        if (string == null) {
            throw new NullPointerException("replacement");
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.reset();
        if (this.find()) {
            this.appendReplacement(stringBuffer, string);
        }
        this.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public Matcher region(int n2, int n3) {
        if (n2 < 0 || n2 > this.getTextLength()) {
            throw new IndexOutOfBoundsException("start");
        }
        if (n3 < 0 || n3 > this.getTextLength()) {
            throw new IndexOutOfBoundsException("end");
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("start > end");
        }
        this.reset();
        this.from = n2;
        this.to = n3;
        return this;
    }

    public int regionStart() {
        return this.from;
    }

    public int regionEnd() {
        return this.to;
    }

    public boolean hasTransparentBounds() {
        return this.transparentBounds;
    }

    public Matcher useTransparentBounds(boolean bl2) {
        this.transparentBounds = bl2;
        return this;
    }

    public boolean hasAnchoringBounds() {
        return this.anchoringBounds;
    }

    public Matcher useAnchoringBounds(boolean bl2) {
        this.anchoringBounds = bl2;
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("java.util.regex.Matcher");
        stringBuffer.append("[pattern=" + this.pattern());
        stringBuffer.append(" region=");
        stringBuffer.append(this.regionStart() + "," + this.regionEnd());
        stringBuffer.append(" lastmatch=");
        if (this.first >= 0 && this.group() != null) {
            stringBuffer.append(this.group());
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean hitEnd() {
        return this.hitEnd;
    }

    public boolean requireEnd() {
        return this.requireEnd;
    }

    boolean search(int n2) {
        boolean bl2;
        this.hitEnd = false;
        this.requireEnd = false;
        this.first = n2 = n2 < 0 ? 0 : n2;
        this.oldLast = this.oldLast < 0 ? n2 : this.oldLast;
        for (bl2 = false; bl2 < this.groups.length; bl2 += 1) {
            this.groups[bl2] = -1;
        }
        this.acceptMode = 0;
        bl2 = this.parentPattern.root.match(this, n2, this.text);
        if (!bl2) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return bl2;
    }

    boolean match(int n2, int n3) {
        boolean bl2;
        this.hitEnd = false;
        this.requireEnd = false;
        this.first = n2 = n2 < 0 ? 0 : n2;
        this.oldLast = this.oldLast < 0 ? n2 : this.oldLast;
        for (bl2 = false; bl2 < this.groups.length; bl2 += 1) {
            this.groups[bl2] = -1;
        }
        this.acceptMode = n3;
        bl2 = this.parentPattern.matchRoot.match(this, n2, this.text);
        if (!bl2) {
            this.first = -1;
        }
        this.oldLast = this.last;
        return bl2;
    }

    int getTextLength() {
        return this.text.length();
    }

    CharSequence getSubSequence(int n2, int n3) {
        return this.text.subSequence(n2, n3);
    }

    char charAt(int n2) {
        return this.text.charAt(n2);
    }
}

