/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import sun.security.action.GetPropertyAction;
import sun.text.resources.LocaleData;

public final class Locale
implements Cloneable,
Serializable {
    public static final Locale ENGLISH = new Locale("en", "", "");
    public static final Locale FRENCH = new Locale("fr", "", "");
    public static final Locale GERMAN = new Locale("de", "", "");
    public static final Locale ITALIAN = new Locale("it", "", "");
    public static final Locale JAPANESE = new Locale("ja", "", "");
    public static final Locale KOREAN = new Locale("ko", "", "");
    public static final Locale CHINESE = new Locale("zh", "", "");
    public static final Locale SIMPLIFIED_CHINESE = new Locale("zh", "CN", "");
    public static final Locale TRADITIONAL_CHINESE = new Locale("zh", "TW", "");
    public static final Locale FRANCE = new Locale("fr", "FR", "");
    public static final Locale GERMANY = new Locale("de", "DE", "");
    public static final Locale ITALY = new Locale("it", "IT", "");
    public static final Locale JAPAN = new Locale("ja", "JP", "");
    public static final Locale KOREA = new Locale("ko", "KR", "");
    public static final Locale CHINA = new Locale("zh", "CN", "");
    public static final Locale PRC = new Locale("zh", "CN", "");
    public static final Locale TAIWAN = new Locale("zh", "TW", "");
    public static final Locale UK = new Locale("en", "GB", "");
    public static final Locale US = new Locale("en", "US", "");
    public static final Locale CANADA = new Locale("en", "CA", "");
    public static final Locale CANADA_FRENCH = new Locale("fr", "CA", "");
    static final long serialVersionUID = 9149081749638150636L;
    private final String language;
    private final String country;
    private final String variant;
    private volatile int hashcode = -1;
    private volatile transient int hashCodeValue = 0;
    private static Locale defaultLocale = null;
    private static String[] isoLanguages = null;
    private static final String compressedIsoLanguages = ",aaaar,ababk,aeave,afafr,akaka,amamh,anarg,arara,asasm,avava,ayaym,azaze,babak,bebel,bgbul,bhbih,bibis,bmbam,bnben,bobod,brbre,bsbos,cacat,ceche,chcha,cocos,crcre,csces,cuchu,cvchv,cycym,dadan,dedeu,dvdiv,dzdzo,eeewe,elell,eneng,eoepo,esspa,etest,eueus,fafas,ffful,fifin,fjfij,fofao,frfra,fyfry,gagle,gdgla,glglg,gngrn,guguj,gvglv,hahau,heheb,hihin,hohmo,hrhrv,hthat,huhun,hyhye,hzher,iaina,idind,ieile,igibo,iiiii,ikipk,inind,ioido,isisl,itita,iuiku,iwheb,jajpn,jiyid,jvjav,kakat,kgkon,kikik,kjkua,kkkaz,klkal,kmkhm,knkan,kokor,krkau,kskas,kukur,kvkom,kwcor,kykir,lalat,lbltz,lglug,lilim,lnlin,lolao,ltlit,lulub,lvlav,mgmlg,mhmah,mimri,mkmkd,mlmal,mnmon,momol,mrmar,msmsa,mtmlt,mymya,nanau,nbnob,ndnde,nenep,ngndo,nlnld,nnnno,nonor,nrnbl,nvnav,nynya,ococi,ojoji,omorm,orori,ososs,papan,pipli,plpol,pspus,ptpor,quque,rmroh,rnrun,roron,rurus,rwkin,sasan,scsrd,sdsnd,sesme,sgsag,sisin,skslk,slslv,smsmo,snsna,sosom,sqsqi,srsrp,ssssw,stsot,susun,svswe,swswa,tatam,tetel,tgtgk,ththa,titir,tktuk,tltgl,tntsn,toton,trtur,tstso,tttat,twtwi,tytah,uguig,ukukr,ururd,uzuzb,veven,vivie,vovol,wawln,wowol,xhxho,yiyid,yoyor,zazha,zhzho,zuzul";
    private static String[] isoCountries = null;
    private static final String compressedIsoCountries = ",ADAND,AEARE,AFAFG,AGATG,AIAIA,ALALB,AMARM,ANANT,AOAGO,AQATA,ARARG,ASASM,ATAUT,AUAUS,AWABW,AXALA,AZAZE,BABIH,BBBRB,BDBGD,BEBEL,BFBFA,BGBGR,BHBHR,BIBDI,BJBEN,BMBMU,BNBRN,BOBOL,BRBRA,BSBHS,BTBTN,BVBVT,BWBWA,BYBLR,BZBLZ,CACAN,CCCCK,CDCOD,CFCAF,CGCOG,CHCHE,CICIV,CKCOK,CLCHL,CMCMR,CNCHN,COCOL,CRCRI,CSSCG,CUCUB,CVCPV,CXCXR,CYCYP,CZCZE,DEDEU,DJDJI,DKDNK,DMDMA,DODOM,DZDZA,ECECU,EEEST,EGEGY,EHESH,ERERI,ESESP,ETETH,FIFIN,FJFJI,FKFLK,FMFSM,FOFRO,FRFRA,GAGAB,GBGBR,GDGRD,GEGEO,GFGUF,GHGHA,GIGIB,GLGRL,GMGMB,GNGIN,GPGLP,GQGNQ,GRGRC,GSSGS,GTGTM,GUGUM,GWGNB,GYGUY,HKHKG,HMHMD,HNHND,HRHRV,HTHTI,HUHUN,IDIDN,IEIRL,ILISR,ININD,IOIOT,IQIRQ,IRIRN,ISISL,ITITA,JMJAM,JOJOR,JPJPN,KEKEN,KGKGZ,KHKHM,KIKIR,KMCOM,KNKNA,KPPRK,KRKOR,KWKWT,KYCYM,KZKAZ,LALAO,LBLBN,LCLCA,LILIE,LKLKA,LRLBR,LSLSO,LTLTU,LULUX,LVLVA,LYLBY,MAMAR,MCMCO,MDMDA,MGMDG,MHMHL,MKMKD,MLMLI,MMMMR,MNMNG,MOMAC,MPMNP,MQMTQ,MRMRT,MSMSR,MTMLT,MUMUS,MVMDV,MWMWI,MXMEX,MYMYS,MZMOZ,NANAM,NCNCL,NENER,NFNFK,NGNGA,NINIC,NLNLD,NONOR,NPNPL,NRNRU,NUNIU,NZNZL,OMOMN,PAPAN,PEPER,PFPYF,PGPNG,PHPHL,PKPAK,PLPOL,PMSPM,PNPCN,PRPRI,PSPSE,PTPRT,PWPLW,PYPRY,QAQAT,REREU,ROROU,RURUS,RWRWA,SASAU,SBSLB,SCSYC,SDSDN,SESWE,SGSGP,SHSHN,SISVN,SJSJM,SKSVK,SLSLE,SMSMR,SNSEN,SOSOM,SRSUR,STSTP,SVSLV,SYSYR,SZSWZ,TCTCA,TDTCD,TFATF,TGTGO,THTHA,TJTJK,TKTKL,TLTLS,TMTKM,TNTUN,TOTON,TRTUR,TTTTO,TVTUV,TWTWN,TZTZA,UAUKR,UGUGA,UMUMI,USUSA,UYURY,UZUZB,VAVAT,VCVCT,VEVEN,VGVGB,VIVIR,VNVNM,VUVUT,WFWLF,WSWSM,YEYEM,YTMYT,ZAZAF,ZMZMB,ZWZWE";

    public Locale(String string, String string2, String string3) {
        this.language = this.convertOldISOCodes(string);
        this.country = this.toUpperCase(string2).intern();
        this.variant = string3.intern();
    }

    public Locale(String string, String string2) {
        this(string, string2, "");
    }

    public Locale(String string) {
        this(string, "", "");
    }

    public static Locale getDefault() {
        if (defaultLocale == null) {
            String string;
            String string2;
            String string3 = (String)AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
            String string4 = (String)AccessController.doPrivileged(new GetPropertyAction("user.region"));
            if (string4 != null) {
                int n2 = string4.indexOf(95);
                if (n2 >= 0) {
                    string2 = string4.substring(0, n2);
                    string = string4.substring(n2 + 1);
                } else {
                    string2 = string4;
                    string = "";
                }
            } else {
                string2 = (String)AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
                string = (String)AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
            }
            defaultLocale = new Locale(string3, string2, string);
        }
        return defaultLocale;
    }

    public static synchronized void setDefault(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("Can't set default locale to NULL");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission("user.language", "write"));
        }
        defaultLocale = locale;
    }

    public static Locale[] getAvailableLocales() {
        return LocaleData.getAvailableLocales("LocaleString");
    }

    public static String[] getISOCountries() {
        if (isoCountries == null) {
            isoCountries = new String[compressedIsoCountries.length() / 6];
            for (int i2 = 0; i2 < isoCountries.length; ++i2) {
                Locale.isoCountries[i2] = compressedIsoCountries.substring(i2 * 6 + 1, i2 * 6 + 3);
            }
        }
        String[] stringArray = new String[isoCountries.length];
        System.arraycopy(isoCountries, 0, stringArray, 0, isoCountries.length);
        return stringArray;
    }

    public static String[] getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = new String[compressedIsoLanguages.length() / 6];
            for (int i2 = 0; i2 < isoLanguages.length; ++i2) {
                Locale.isoLanguages[i2] = compressedIsoLanguages.substring(i2 * 6 + 1, i2 * 6 + 3);
            }
        }
        String[] stringArray = new String[isoLanguages.length];
        System.arraycopy(isoLanguages, 0, stringArray, 0, isoLanguages.length);
        return stringArray;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    public final String toString() {
        boolean bl2 = this.language.length() != 0;
        boolean bl3 = this.country.length() != 0;
        boolean bl4 = this.variant.length() != 0;
        StringBuffer stringBuffer = new StringBuffer(this.language);
        if (bl3 || bl2 && bl4) {
            stringBuffer.append('_').append(this.country);
        }
        if (bl4 && (bl2 || bl3)) {
            stringBuffer.append('_').append(this.variant);
        }
        return stringBuffer.toString();
    }

    public String getISO3Language() throws MissingResourceException {
        int n2 = this.language.length();
        if (n2 == 0) {
            return "";
        }
        int n3 = compressedIsoLanguages.indexOf("," + this.language);
        if (n3 == -1 || n2 != 2) {
            throw new MissingResourceException("Couldn't find 3-letter language code for " + this.language, "LocaleElements_" + this.toString(), "ShortLanguage");
        }
        return compressedIsoLanguages.substring(n3 + 3, n3 + 6);
    }

    public String getISO3Country() throws MissingResourceException {
        int n2 = this.country.length();
        if (n2 == 0) {
            return "";
        }
        int n3 = compressedIsoCountries.indexOf("," + this.country);
        if (n3 == -1 || n2 != 2) {
            throw new MissingResourceException("Couldn't find 3-letter country code for " + this.country, "LocaleElements_" + this.toString(), "ShortCountry");
        }
        return compressedIsoCountries.substring(n3 + 3, n3 + 6);
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale locale) {
        String string = this.language;
        if (string.length() == 0) {
            return "";
        }
        Locale locale2 = (Locale)locale.clone();
        String string2 = null;
        int n2 = 0;
        boolean bl2 = false;
        if (locale2.variant.length() == 0) {
            n2 = 1;
        }
        if (locale2.country.length() == 0) {
            n2 = 2;
        }
        while (!bl2) {
            try {
                ResourceBundle resourceBundle = LocaleData.getLocaleElements(locale2);
                string2 = this.findStringMatch((String[][])resourceBundle.getObject("Languages"), string, string);
                if (string2.length() != 0) {
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl2) continue;
            switch (n2) {
                case 0: {
                    locale2 = new Locale(locale2.language, locale2.country, "");
                    break;
                }
                case 1: {
                    locale2 = new Locale(locale2.language, "", locale2.variant);
                    break;
                }
                case 2: {
                    locale2 = Locale.getDefault();
                    break;
                }
                case 3: {
                    locale2 = new Locale("", "", "");
                    break;
                }
                default: {
                    return string;
                }
            }
            ++n2;
        }
        return string2;
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale locale) {
        String string = this.country;
        if (string.length() == 0) {
            return "";
        }
        Locale locale2 = (Locale)locale.clone();
        String string2 = null;
        int n2 = 0;
        boolean bl2 = false;
        if (locale2.variant.length() == 0) {
            n2 = 1;
        }
        if (locale2.country.length() == 0) {
            n2 = 2;
        }
        while (!bl2) {
            try {
                ResourceBundle resourceBundle = LocaleData.getLocaleElements(locale2);
                string2 = this.findStringMatch((String[][])resourceBundle.getObject("Countries"), string, string);
                if (string2.length() != 0) {
                    bl2 = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl2) continue;
            switch (n2) {
                case 0: {
                    locale2 = new Locale(locale2.language, locale2.country, "");
                    break;
                }
                case 1: {
                    locale2 = new Locale(locale2.language, "", locale2.variant);
                    break;
                }
                case 2: {
                    locale2 = Locale.getDefault();
                    break;
                }
                case 3: {
                    locale2 = new Locale("", "", "");
                    break;
                }
                default: {
                    return string;
                }
            }
            ++n2;
        }
        return string2;
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale locale) {
        String[] stringArray;
        if (this.variant.length() == 0) {
            return "";
        }
        ResourceBundle resourceBundle = LocaleData.getLocaleElements(locale);
        String[] stringArray2 = this.getDisplayVariantArray(resourceBundle);
        try {
            stringArray = (String[])resourceBundle.getObject("LocaleNamePatterns");
        }
        catch (MissingResourceException missingResourceException) {
            stringArray = null;
        }
        return Locale.formatList(stringArray, stringArray2);
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        String[] stringArray;
        ResourceBundle resourceBundle = LocaleData.getLocaleElements(locale);
        String string = this.getDisplayLanguage(locale);
        String string2 = this.getDisplayCountry(locale);
        String[] stringArray2 = this.getDisplayVariantArray(resourceBundle);
        try {
            stringArray = (String[])resourceBundle.getObject("LocaleNamePatterns");
        }
        catch (MissingResourceException missingResourceException) {
            stringArray = null;
        }
        String string3 = null;
        String[] stringArray3 = null;
        if (string.length() != 0) {
            string3 = string;
            if (string2.length() != 0) {
                stringArray3 = new String[stringArray2.length + 1];
                System.arraycopy(stringArray2, 0, stringArray3, 1, stringArray2.length);
                stringArray3[0] = string2;
            } else {
                stringArray3 = stringArray2;
            }
        } else if (string2.length() != 0) {
            string3 = string2;
            stringArray3 = stringArray2;
        } else {
            return Locale.formatList(stringArray, stringArray2);
        }
        Object[] objectArray = new Object[]{new Integer(stringArray3.length != 0 ? 2 : 1), string3, stringArray3.length != 0 ? Locale.formatList(stringArray, stringArray3) : null};
        if (stringArray != null) {
            return new MessageFormat(stringArray[0]).format(objectArray);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((String)objectArray[1]);
        if (objectArray.length > 2) {
            stringBuffer.append(" (");
            stringBuffer.append((String)objectArray[2]);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public Object clone() {
        try {
            Locale locale = (Locale)super.clone();
            return locale;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int n2 = this.hashCodeValue;
        if (n2 == 0) {
            this.hashCodeValue = n2 = this.language.hashCode() << 8 ^ this.country.hashCode() ^ this.variant.hashCode() << 4;
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Locale)) {
            return false;
        }
        Locale locale = (Locale)object;
        return this.language == locale.language && this.country == locale.country && this.variant == locale.variant;
    }

    private String[] getDisplayVariantArray(ResourceBundle resourceBundle) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.variant, "_");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringTokenizer.nextToken();
            try {
                stringArray[i2] = (String)resourceBundle.getObject("%%" + string);
                continue;
            }
            catch (MissingResourceException missingResourceException) {
                stringArray[i2] = string;
            }
        }
        return stringArray;
    }

    private static String formatList(String[] stringArray, String[] stringArray2) {
        Object object;
        if (stringArray == null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(stringArray2[i2]);
            }
            return stringBuffer.toString();
        }
        if (stringArray2.length > 3) {
            object = new MessageFormat(stringArray[2]);
            stringArray2 = Locale.composeList((MessageFormat)object, stringArray2);
        }
        object = new Object[stringArray2.length + 1];
        System.arraycopy(stringArray2, 0, object, 1, stringArray2.length);
        object[0] = new Integer(stringArray2.length);
        MessageFormat messageFormat = new MessageFormat(stringArray[1]);
        return messageFormat.format(object);
    }

    private static String[] composeList(MessageFormat messageFormat, String[] stringArray) {
        if (stringArray.length <= 3) {
            return stringArray;
        }
        String[] stringArray2 = new String[]{stringArray[0], stringArray[1]};
        String string = messageFormat.format(stringArray2);
        String[] stringArray3 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 2, stringArray3, 1, stringArray3.length - 1);
        stringArray3[0] = string;
        return Locale.composeList(messageFormat, stringArray3);
    }

    private Object readResolve() throws ObjectStreamException {
        return new Locale(this.language, this.country, this.variant);
    }

    private String toLowerCase(String string) {
        char[] cArray = new char[string.length()];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = Character.toLowerCase(string.charAt(i2));
        }
        return new String(cArray);
    }

    private String toUpperCase(String string) {
        char[] cArray = new char[string.length()];
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = Character.toUpperCase(string.charAt(i2));
        }
        return new String(cArray);
    }

    private String findStringMatch(String[][] stringArray, String string, String string2) {
        int n2;
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!string.equals(stringArray[n2][0])) continue;
            return stringArray[n2][1];
        }
        if (!string2.equals(string)) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!string2.equals(stringArray[n2][0])) continue;
                return stringArray[n2][1];
            }
        }
        if (!"EN".equals(string) && "EN".equals(string2)) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                if (!"EN".equals(stringArray[n2][0])) continue;
                return stringArray[n2][1];
            }
        }
        return "";
    }

    private String convertOldISOCodes(String string) {
        if ((string = this.toLowerCase(string).intern()) == "he") {
            return "iw";
        }
        if (string == "yi") {
            return "ji";
        }
        if (string == "id") {
            return "in";
        }
        return string;
    }
}

