/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PipedWriter;
import java.io.Reader;

public class PipedReader
extends Reader {
    boolean closedByWriter = false;
    boolean closedByReader = false;
    boolean connected = false;
    Thread readSide;
    Thread writeSide;
    static final int PIPE_SIZE = 1024;
    char[] buffer = new char[1024];
    int in = -1;
    int out = 0;

    public PipedReader(PipedWriter pipedWriter) throws IOException {
        this.connect(pipedWriter);
    }

    public PipedReader() {
    }

    public void connect(PipedWriter pipedWriter) throws IOException {
        pipedWriter.connect(this);
    }

    synchronized void receive(int n2) throws IOException {
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByWriter || this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        if (this.readSide != null && !this.readSide.isAlive()) {
            throw new IOException("Read end dead");
        }
        this.writeSide = Thread.currentThread();
        while (this.in == this.out) {
            if (this.readSide != null && !this.readSide.isAlive()) {
                throw new IOException("Pipe broken");
            }
            this.notifyAll();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        if (this.in < 0) {
            this.in = 0;
            this.out = 0;
        }
        this.buffer[this.in++] = (char)n2;
        if (this.in >= this.buffer.length) {
            this.in = 0;
        }
    }

    synchronized void receive(char[] cArray, int n2, int n3) throws IOException {
        while (--n3 >= 0) {
            this.receive(cArray[n2++]);
        }
    }

    synchronized void receivedLast() {
        this.closedByWriter = true;
        this.notifyAll();
    }

    public synchronized int read() throws IOException {
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        if (this.writeSide != null && !this.writeSide.isAlive() && !this.closedByWriter && this.in < 0) {
            throw new IOException("Write end dead");
        }
        this.readSide = Thread.currentThread();
        int n2 = 2;
        while (this.in < 0) {
            if (this.closedByWriter) {
                return -1;
            }
            if (this.writeSide != null && !this.writeSide.isAlive() && --n2 < 0) {
                throw new IOException("Pipe broken");
            }
            this.notifyAll();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException();
            }
        }
        char c2 = this.buffer[this.out++];
        if (this.out >= this.buffer.length) {
            this.out = 0;
        }
        if (this.in == this.out) {
            this.in = -1;
        }
        return c2;
    }

    public synchronized int read(char[] cArray, int n2, int n3) throws IOException {
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        if (this.writeSide != null && !this.writeSide.isAlive() && !this.closedByWriter && this.in < 0) {
            throw new IOException("Write end dead");
        }
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 > cArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return 0;
        }
        int n4 = this.read();
        if (n4 < 0) {
            return -1;
        }
        cArray[n2] = (char)n4;
        int n5 = 1;
        while (this.in >= 0 && --n3 > 0) {
            cArray[n2 + n5] = this.buffer[this.out++];
            ++n5;
            if (this.out >= this.buffer.length) {
                this.out = 0;
            }
            if (this.in != this.out) continue;
            this.in = -1;
        }
        return n5;
    }

    public synchronized boolean ready() throws IOException {
        if (!this.connected) {
            throw new IOException("Pipe not connected");
        }
        if (this.closedByReader) {
            throw new IOException("Pipe closed");
        }
        if (this.writeSide != null && !this.writeSide.isAlive() && !this.closedByWriter && this.in < 0) {
            throw new IOException("Write end dead");
        }
        return this.in >= 0;
    }

    public void close() throws IOException {
        this.in = -1;
        this.closedByReader = true;
    }
}

