/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.util.Arrays;

public class ComponentSampleModel
extends SampleModel {
    protected int[] bandOffsets;
    protected int[] bankIndices;
    protected int numBands = 1;
    protected int numBanks = 1;
    protected int scanlineStride;
    protected int pixelStride;

    private static native void initIDs();

    public ComponentSampleModel(int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        super(n2, n3, n4, nArray.length);
        this.dataType = n2;
        this.pixelStride = n5;
        this.scanlineStride = n6;
        this.bandOffsets = (int[])nArray.clone();
        this.numBands = nArray.length;
        if (n5 < 0) {
            throw new IllegalArgumentException("Pixel stride must be >= 0");
        }
        if (n6 < 0) {
            throw new IllegalArgumentException("Scanline stride must be >= 0");
        }
        if (this.numBands < 1) {
            throw new IllegalArgumentException("Must have at least one band.");
        }
        if (n2 < 0 || n2 > 5) {
            throw new IllegalArgumentException("Unsupported dataType.");
        }
        this.bankIndices = new int[this.numBands];
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            this.bankIndices[i2] = 0;
        }
    }

    public ComponentSampleModel(int n2, int n3, int n4, int n5, int n6, int[] nArray, int[] nArray2) {
        super(n2, n3, n4, nArray2.length);
        this.dataType = n2;
        this.pixelStride = n5;
        this.scanlineStride = n6;
        this.bandOffsets = (int[])nArray2.clone();
        this.bankIndices = (int[])nArray.clone();
        if (n5 < 0) {
            throw new IllegalArgumentException("Pixel stride must be >= 0");
        }
        if (n6 < 0) {
            throw new IllegalArgumentException("Scanline stride must be >= 0");
        }
        if (n2 < 0 || n2 > 5) {
            throw new IllegalArgumentException("Unsupported dataType.");
        }
        int n7 = nArray[0];
        if (n7 < 0) {
            throw new IllegalArgumentException("Index of bank 0 is less than 0 (" + n7 + ")");
        }
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] > n7) {
                n7 = nArray[i2];
                continue;
            }
            if (nArray[i2] >= 0) continue;
            throw new IllegalArgumentException("Index of bank " + i2 + " is less than 0 (" + n7 + ")");
        }
        this.numBanks = n7 + 1;
        this.numBands = nArray2.length;
        if (nArray2.length != nArray.length) {
            throw new IllegalArgumentException("Length of bandOffsets must equal length of bankIndices.");
        }
    }

    private long getBufferSize() {
        int n2 = this.bandOffsets[0];
        for (int i2 = 1; i2 < this.bandOffsets.length; ++i2) {
            n2 = Math.max(n2, this.bandOffsets[i2]);
        }
        long l2 = 0L;
        if (n2 >= 0) {
            l2 += (long)(n2 + 1);
        }
        if (this.pixelStride > 0) {
            l2 += (long)(this.pixelStride * (this.width - 1));
        }
        if (this.scanlineStride > 0) {
            l2 += (long)(this.scanlineStride * (this.height - 1));
        }
        return l2;
    }

    int[] orderBands(int[] nArray, int n2) {
        int n3;
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            nArray2[n3] = n3;
        }
        for (n3 = 0; n3 < nArray3.length; ++n3) {
            int n4 = n3;
            for (int i2 = n3 + 1; i2 < nArray3.length; ++i2) {
                if (nArray[nArray2[n4]] <= nArray[nArray2[i2]]) continue;
                n4 = i2;
            }
            nArray3[nArray2[n4]] = n3 * n2;
            nArray2[n4] = nArray2[n3];
        }
        return nArray3;
    }

    public SampleModel createCompatibleSampleModel(int n2, int n3) {
        int n4;
        int[] nArray;
        int n5;
        Object var3_3 = null;
        int n6 = this.bandOffsets[0];
        int n7 = this.bandOffsets[0];
        for (n5 = 1; n5 < this.bandOffsets.length; ++n5) {
            n6 = Math.min(n6, this.bandOffsets[n5]);
            n7 = Math.max(n7, this.bandOffsets[n5]);
        }
        n5 = this.bandOffsets.length;
        int n8 = Math.abs(this.pixelStride);
        int n9 = Math.abs(this.scanlineStride);
        int n10 = Math.abs(n7 -= n6);
        if (n8 > n9) {
            if (n8 > n10) {
                if (n9 > n10) {
                    nArray = new int[this.bandOffsets.length];
                    for (n4 = 0; n4 < n5; ++n4) {
                        nArray[n4] = this.bandOffsets[n4] - n6;
                    }
                    n9 = n10 + 1;
                    n8 = n9 * n3;
                } else {
                    nArray = this.orderBands(this.bandOffsets, n9 * n3);
                    n8 = n5 * n9 * n3;
                }
            } else {
                n8 = n9 * n3;
                nArray = this.orderBands(this.bandOffsets, n8 * n2);
            }
        } else if (n8 > n10) {
            nArray = new int[this.bandOffsets.length];
            for (n4 = 0; n4 < n5; ++n4) {
                nArray[n4] = this.bandOffsets[n4] - n6;
            }
            n8 = n10 + 1;
            n9 = n8 * n2;
        } else if (n9 > n10) {
            nArray = this.orderBands(this.bandOffsets, n8 * n2);
            n9 = n5 * n8 * n2;
        } else {
            n9 = n8 * n2;
            nArray = this.orderBands(this.bandOffsets, n9 * n3);
        }
        n4 = 0;
        if (this.scanlineStride < 0) {
            n4 += n9 * n3;
            n9 *= -1;
        }
        if (this.pixelStride < 0) {
            n4 += n8 * n2;
            n8 *= -1;
        }
        int n11 = 0;
        while (n11 < n5) {
            int n12 = n11++;
            nArray[n12] = nArray[n12] + n4;
        }
        return new ComponentSampleModel(this.dataType, n2, n3, n8, n9, this.bankIndices, nArray);
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.bankIndices.length) {
            throw new RasterFormatException("There are only " + this.bankIndices.length + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray2[i2] = this.bankIndices[nArray[i2]];
            nArray3[i2] = this.bandOffsets[nArray[i2]];
        }
        return new ComponentSampleModel(this.dataType, this.width, this.height, this.pixelStride, this.scanlineStride, nArray2, nArray3);
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n2 = (int)this.getBufferSize();
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n2, this.numBanks);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n2, this.numBanks);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n2, this.numBanks);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n2, this.numBanks);
                break;
            }
            case 4: {
                dataBuffer = new DataBufferFloat(n2, this.numBanks);
                break;
            }
            case 5: {
                dataBuffer = new DataBufferDouble(n2, this.numBanks);
            }
        }
        return dataBuffer;
    }

    public int getOffset(int n2, int n3) {
        int n4 = n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[0];
        return n4;
    }

    public int getOffset(int n2, int n3, int n4) {
        int n5 = n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4];
        return n5;
    }

    public final int[] getSampleSize() {
        int[] nArray = new int[this.numBands];
        int n2 = this.getSampleSize(0);
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            nArray[i2] = n2;
        }
        return nArray;
    }

    public final int getSampleSize(int n2) {
        return DataBuffer.getDataTypeSize(this.dataType);
    }

    public final int[] getBankIndices() {
        return (int[])this.bankIndices.clone();
    }

    public final int[] getBandOffsets() {
        return (int[])this.bandOffsets.clone();
    }

    public final int getScanlineStride() {
        return this.scanlineStride;
    }

    public final int getPixelStride() {
        return this.pixelStride;
    }

    public final int getNumDataElements() {
        return this.getNumBands();
    }

    public Object getDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        int n5 = this.getNumDataElements();
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride;
        switch (n4) {
            case 0: {
                byte[] byArray = object == null ? new byte[n5] : (byte[])object;
                for (int i2 = 0; i2 < n5; ++i2) {
                    byArray[i2] = (byte)dataBuffer.getElem(this.bankIndices[i2], n6 + this.bandOffsets[i2]);
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n5] : (short[])object;
                for (int i3 = 0; i3 < n5; ++i3) {
                    sArray[i3] = (short)dataBuffer.getElem(this.bankIndices[i3], n6 + this.bandOffsets[i3]);
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n5] : (int[])object;
                for (int i4 = 0; i4 < n5; ++i4) {
                    nArray[i4] = dataBuffer.getElem(this.bankIndices[i4], n6 + this.bandOffsets[i4]);
                }
                object = nArray;
                break;
            }
            case 4: {
                float[] fArray = object == null ? new float[n5] : (float[])object;
                for (int i5 = 0; i5 < n5; ++i5) {
                    fArray[i5] = dataBuffer.getElemFloat(this.bankIndices[i5], n6 + this.bandOffsets[i5]);
                }
                object = fArray;
                break;
            }
            case 5: {
                double[] dArray = object == null ? new double[n5] : (double[])object;
                for (int i6 = 0; i6 < n5; ++i6) {
                    dArray[i6] = dataBuffer.getElemDouble(this.bankIndices[i6], n6 + this.bandOffsets[i6]);
                }
                object = dArray;
            }
        }
        return object;
    }

    public int[] getPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        int n4 = n3 * this.scanlineStride + n2 * this.pixelStride;
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            nArray2[i2] = dataBuffer.getElem(this.bankIndices[i2], n4 + this.bandOffsets[i2]);
        }
        return nArray2;
    }

    public int[] getPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5 * this.numBands];
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride;
        int n7 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n8 = n6;
            for (int i3 = 0; i3 < n4; ++i3) {
                for (int i4 = 0; i4 < this.numBands; ++i4) {
                    nArray2[n7++] = dataBuffer.getElem(this.bankIndices[i4], n8 + this.bandOffsets[i4]);
                }
                n8 += this.pixelStride;
            }
            n6 += this.scanlineStride;
        }
        return nArray2;
    }

    public int getSample(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = dataBuffer.getElem(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4]);
        return n5;
    }

    public float getSampleFloat(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        float f2 = dataBuffer.getElemFloat(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4]);
        return f2;
    }

    public double getSampleDouble(int n2, int n3, int n4, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        double d2 = dataBuffer.getElemDouble(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4]);
        return d2;
    }

    public int[] getSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int[] nArray2 = nArray != null ? nArray : new int[n4 * n5];
        int n7 = n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n6];
        int n8 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n9 = n7;
            for (int i3 = 0; i3 < n4; ++i3) {
                nArray2[n8++] = dataBuffer.getElem(this.bankIndices[n6], n9);
                n9 += this.pixelStride;
            }
            n7 += this.scanlineStride;
        }
        return nArray2;
    }

    public void setDataElements(int n2, int n3, Object object, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = this.getTransferType();
        int n5 = this.getNumDataElements();
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride;
        switch (n4) {
            case 0: {
                byte[] byArray = (byte[])object;
                for (int i2 = 0; i2 < n5; ++i2) {
                    dataBuffer.setElem(this.bankIndices[i2], n6 + this.bandOffsets[i2], byArray[i2] & 0xFF);
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                for (int i3 = 0; i3 < n5; ++i3) {
                    dataBuffer.setElem(this.bankIndices[i3], n6 + this.bandOffsets[i3], sArray[i3] & 0xFFFF);
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                for (int i4 = 0; i4 < n5; ++i4) {
                    dataBuffer.setElem(this.bankIndices[i4], n6 + this.bandOffsets[i4], nArray[i4]);
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                for (int i5 = 0; i5 < n5; ++i5) {
                    dataBuffer.setElemFloat(this.bankIndices[i5], n6 + this.bandOffsets[i5], fArray[i5]);
                }
                break;
            }
            case 5: {
                double[] dArray = (double[])object;
                for (int i6 = 0; i6 < n5; ++i6) {
                    dataBuffer.setElemDouble(this.bankIndices[i6], n6 + this.bandOffsets[i6], dArray[i6]);
                }
                break;
            }
        }
    }

    public void setPixel(int n2, int n3, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n4 = n3 * this.scanlineStride + n2 * this.pixelStride;
        for (int i2 = 0; i2 < this.numBands; ++i2) {
            dataBuffer.setElem(this.bankIndices[i2], n4 + this.bandOffsets[i2], nArray[i2]);
        }
    }

    public void setPixels(int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = n3 * this.scanlineStride + n2 * this.pixelStride;
        int n7 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n8 = n6;
            for (int i3 = 0; i3 < n4; ++i3) {
                for (int i4 = 0; i4 < this.numBands; ++i4) {
                    dataBuffer.setElem(this.bankIndices[i4], n8 + this.bandOffsets[i4], nArray[n7++]);
                }
                n8 += this.pixelStride;
            }
            n6 += this.scanlineStride;
        }
    }

    public void setSample(int n2, int n3, int n4, int n5, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElem(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4], n5);
    }

    public void setSample(int n2, int n3, int n4, float f2, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElemFloat(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4], f2);
    }

    public void setSample(int n2, int n3, int n4, double d2, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 >= this.width || n3 >= this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        dataBuffer.setElemDouble(this.bankIndices[n4], n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n4], d2);
    }

    public void setSamples(int n2, int n3, int n4, int n5, int n6, int[] nArray, DataBuffer dataBuffer) {
        if (n2 < 0 || n3 < 0 || n2 + n4 > this.width || n3 + n5 > this.height) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = n3 * this.scanlineStride + n2 * this.pixelStride + this.bandOffsets[n6];
        int n8 = 0;
        for (int i2 = 0; i2 < n5; ++i2) {
            int n9 = n7;
            for (int i3 = 0; i3 < n4; ++i3) {
                dataBuffer.setElem(this.bankIndices[n6], n9, nArray[n8++]);
                n9 += this.pixelStride;
            }
            n7 += this.scanlineStride;
        }
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ComponentSampleModel)) {
            return false;
        }
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)object;
        return this.width == componentSampleModel.width && this.height == componentSampleModel.height && this.numBands == componentSampleModel.numBands && this.dataType == componentSampleModel.dataType && Arrays.equals(this.bandOffsets, componentSampleModel.bandOffsets) && Arrays.equals(this.bankIndices, componentSampleModel.bankIndices) && this.numBands == componentSampleModel.numBands && this.numBanks == componentSampleModel.numBanks && this.scanlineStride == componentSampleModel.scanlineStride && this.pixelStride == componentSampleModel.pixelStride;
    }

    public int hashCode() {
        int n2;
        int n3 = 0;
        n3 = this.width;
        n3 <<= 8;
        n3 ^= this.height;
        n3 <<= 8;
        n3 ^= this.numBands;
        n3 <<= 8;
        n3 ^= this.dataType;
        n3 <<= 8;
        for (n2 = 0; n2 < this.bandOffsets.length; ++n2) {
            n3 ^= this.bandOffsets[n2];
            n3 <<= 8;
        }
        for (n2 = 0; n2 < this.bankIndices.length; ++n2) {
            n3 ^= this.bankIndices[n2];
            n3 <<= 8;
        }
        n3 ^= this.numBands;
        n3 <<= 8;
        n3 ^= this.numBanks;
        n3 <<= 8;
        n3 ^= this.scanlineStride;
        n3 <<= 8;
        return n3 ^= this.pixelStride;
    }

    static {
        ColorModel.loadLibraries();
        ComponentSampleModel.initIDs();
    }
}

