/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.IndexedInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.TypedInstruction;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class LocalVariableInstruction
extends Instruction
implements TypedInstruction,
IndexedInstruction {
    protected int n = -1;
    private short c_tag = (short)-1;
    private short canon_tag = (short)-1;

    private final boolean wide() {
        return this.n > 255;
    }

    LocalVariableInstruction(short s2, short s3) {
        this.canon_tag = s2;
        this.c_tag = s3;
    }

    LocalVariableInstruction() {
    }

    protected LocalVariableInstruction(short s2, short s3, int n2) {
        super(s2, (short)2);
        this.c_tag = s3;
        this.canon_tag = s2;
        this.setIndex(n2);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        if (this.wide()) {
            dataOutputStream.writeByte(196);
        }
        dataOutputStream.writeByte(this.opcode);
        if (this.length > 1) {
            if (this.wide()) {
                dataOutputStream.writeShort(this.n);
            } else {
                dataOutputStream.writeByte(this.n);
            }
        }
    }

    public String toString(boolean bl2) {
        if (this.opcode >= 26 && this.opcode <= 45 || this.opcode >= 59 && this.opcode <= 78) {
            return super.toString(bl2);
        }
        return super.toString(bl2) + " " + this.n;
    }

    protected void initFromFile(ByteSequence byteSequence, boolean bl2) throws IOException {
        if (bl2) {
            this.n = byteSequence.readUnsignedShort();
            this.length = (short)4;
        } else if (this.opcode >= 21 && this.opcode <= 25 || this.opcode >= 54 && this.opcode <= 58) {
            this.n = byteSequence.readUnsignedByte();
            this.length = (short)2;
        } else if (this.opcode <= 45) {
            this.n = (this.opcode - 26) % 4;
            this.length = 1;
        } else {
            this.n = (this.opcode - 59) % 4;
            this.length = 1;
        }
    }

    public final int getIndex() {
        return this.n;
    }

    public void setIndex(int n2) {
        if (n2 < 0 || n2 > 65535) {
            throw new ClassGenException("Illegal value: " + n2);
        }
        this.n = n2;
        if (n2 >= 0 && n2 <= 3) {
            this.opcode = (short)(this.c_tag + n2);
            this.length = 1;
        } else {
            this.opcode = this.canon_tag;
            this.length = this.wide() ? (short)4 : (short)2;
        }
    }

    public short getCanonicalTag() {
        return this.canon_tag;
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        switch (this.canon_tag) {
            case 21: 
            case 54: {
                return Type.INT;
            }
            case 22: 
            case 55: {
                return Type.LONG;
            }
            case 24: 
            case 57: {
                return Type.DOUBLE;
            }
            case 23: 
            case 56: {
                return Type.FLOAT;
            }
            case 25: 
            case 58: {
                return Type.OBJECT;
            }
        }
        throw new ClassGenException("Oops: unknown case in switch" + this.canon_tag);
    }
}

