/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.Constants;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Constant
implements Cloneable,
Node {
    protected byte tag;

    Constant(byte by) {
        this.tag = by;
    }

    public abstract void accept(Visitor var1);

    public abstract void dump(DataOutputStream var1) throws IOException;

    public final byte getTag() {
        return this.tag;
    }

    public String toString() {
        return Constants.CONSTANT_NAMES[this.tag] + "[" + this.tag + "]";
    }

    public Constant copy() {
        try {
            return (Constant)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    static final Constant readConstant(DataInputStream dataInputStream) throws IOException, ClassFormatError {
        byte by = dataInputStream.readByte();
        switch (by) {
            case 7: {
                return new ConstantClass(dataInputStream);
            }
            case 9: {
                return new ConstantFieldref(dataInputStream);
            }
            case 10: {
                return new ConstantMethodref(dataInputStream);
            }
            case 11: {
                return new ConstantInterfaceMethodref(dataInputStream);
            }
            case 8: {
                return new ConstantString(dataInputStream);
            }
            case 3: {
                return new ConstantInteger(dataInputStream);
            }
            case 4: {
                return new ConstantFloat(dataInputStream);
            }
            case 5: {
                return new ConstantLong(dataInputStream);
            }
            case 6: {
                return new ConstantDouble(dataInputStream);
            }
            case 12: {
                return new ConstantNameAndType(dataInputStream);
            }
            case 1: {
                return new ConstantUtf8(dataInputStream);
            }
        }
        throw new ClassFormatError("Invalid byte tag in constant pool: " + by);
    }
}

