/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp.agent;

import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpVarBind;
import com.sun.jmx.snmp.agent.SnmpMibAgent;
import com.sun.jmx.snmp.agent.SnmpMibRequest;
import com.sun.jmx.trace.Trace;
import java.io.Serializable;
import java.util.Enumeration;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SnmpErrorHandlerAgent
extends SnmpMibAgent
implements Serializable {
    private String dbgTag = "SnmpErrorHandlerAgent";

    public void init() throws IllegalAccessException {
    }

    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        return objectName;
    }

    public long[] getRootOid() {
        return null;
    }

    public void get(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.trace("get", "Get in Exception");
        }
        if (snmpMibRequest.getVersion() == 0) {
            throw new SnmpStatusException(2);
        }
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            snmpVarBind.setNoSuchObject();
        }
    }

    public void check(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.trace("check", "Check in Exception");
        }
        throw new SnmpStatusException(17);
    }

    public void set(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.trace("set", "Set in Exception, CAN't be called");
        }
        throw new SnmpStatusException(17);
    }

    public void getNext(SnmpMibRequest snmpMibRequest) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.trace("getNext", "GetNext in Exception");
        }
        if (snmpMibRequest.getVersion() == 0) {
            throw new SnmpStatusException(2);
        }
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            snmpVarBind.setEndOfMibView();
        }
    }

    public void getBulk(SnmpMibRequest snmpMibRequest, int n2, int n3) throws SnmpStatusException {
        if (this.isDebugOn()) {
            this.trace("getBulk", "GetBulk in Exception");
        }
        if (snmpMibRequest.getVersion() == 0) {
            throw new SnmpStatusException(5, 0);
        }
        Enumeration enumeration = snmpMibRequest.getElements();
        while (enumeration.hasMoreElements()) {
            SnmpVarBind snmpVarBind = (SnmpVarBind)enumeration.nextElement();
            snmpVarBind.setEndOfMibView();
        }
    }

    private boolean isDebugOn() {
        return Trace.isSelected(2, 256);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(1, 256, string, string2, string3);
    }

    private void trace(String string, String string2) {
        this.debug(this.dbgTag, string, string2);
    }
}

