/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class MotifTabbedPaneUI
extends BasicTabbedPaneUI {
    protected Color unselectedTabBackground;
    protected Color unselectedTabForeground;
    protected Color unselectedTabShadow;
    protected Color unselectedTabHighlight;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifTabbedPaneUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.unselectedTabBackground = UIManager.getColor("TabbedPane.unselectedTabBackground");
        this.unselectedTabForeground = UIManager.getColor("TabbedPane.unselectedTabForeground");
        this.unselectedTabShadow = UIManager.getColor("TabbedPane.unselectedTabShadow");
        this.unselectedTabHighlight = UIManager.getColor("TabbedPane.unselectedTabHighlight");
    }

    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.unselectedTabBackground = null;
        this.unselectedTabForeground = null;
        this.unselectedTabShadow = null;
        this.unselectedTabHighlight = null;
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.lightHighlight);
        if (n2 != 1 || n3 < 0 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            graphics.drawLine(n4, n5, n4 + n6 - 2, n5);
        } else {
            graphics.drawLine(n4, n5, rectangle.x - 1, n5);
            if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n5, n4 + n6 - 2, n5);
            }
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.shadow);
        if (n2 != 3 || n3 < 0 || rectangle.x < n4 || rectangle.x > n4 + n6) {
            graphics.drawLine(n4 + 1, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
        } else {
            graphics.drawLine(n4 + 1, n5 + n7 - 1, rectangle.x - 1, n5 + n7 - 1);
            if (rectangle.x + rectangle.width < n4 + n6 - 2) {
                graphics.drawLine(rectangle.x + rectangle.width, n5 + n7 - 1, n4 + n6 - 2, n5 + n7 - 1);
            }
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = n3 < 0 ? null : this.getTabBounds(n3, this.calcRect);
        graphics.setColor(this.shadow);
        if (n2 != 4 || n3 < 0 || rectangle.y < n5 || rectangle.y > n5 + n7) {
            graphics.drawLine(n4 + n6 - 1, n5 + 1, n4 + n6 - 1, n5 + n7 - 1);
        } else {
            graphics.drawLine(n4 + n6 - 1, n5 + 1, n4 + n6 - 1, rectangle.y - 1);
            if (rectangle.y + rectangle.height < n5 + n7 - 2) {
                graphics.drawLine(n4 + n6 - 1, rectangle.y + rectangle.height, n4 + n6 - 1, n5 + n7 - 2);
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        graphics.setColor(bl2 ? this.tabPane.getBackgroundAt(n3) : this.unselectedTabBackground);
        switch (n2) {
            case 2: {
                graphics.fillRect(n4 + 1, n5 + 1, n6 - 1, n7 - 2);
                break;
            }
            case 4: {
                graphics.fillRect(n4, n5 + 1, n6 - 1, n7 - 2);
                break;
            }
            case 3: {
                graphics.fillRect(n4 + 1, n5, n6 - 2, n7 - 3);
                graphics.drawLine(n4 + 2, n5 + n7 - 3, n4 + n6 - 3, n5 + n7 - 3);
                graphics.drawLine(n4 + 3, n5 + n7 - 2, n4 + n6 - 4, n5 + n7 - 2);
                break;
            }
            default: {
                graphics.fillRect(n4 + 1, n5 + 3, n6 - 2, n7 - 3);
                graphics.drawLine(n4 + 2, n5 + 2, n4 + n6 - 3, n5 + 2);
                graphics.drawLine(n4 + 3, n5 + 1, n4 + n6 - 4, n5 + 1);
            }
        }
    }

    protected void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        graphics.setColor(bl2 ? this.lightHighlight : this.unselectedTabHighlight);
        switch (n2) {
            case 2: {
                graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 3);
                graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 2);
                graphics.drawLine(n4 + 2, n5, n4 + 2, n5 + 1);
                graphics.drawLine(n4 + 3, n5, n4 + n6 - 1, n5);
                graphics.setColor(bl2 ? this.shadow : this.unselectedTabShadow);
                graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 1, n5 + n7 - 2);
                graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + 2, n5 + n7 - 1);
                graphics.drawLine(n4 + 3, n5 + n7 - 1, n4 + n6 - 1, n5 + n7 - 1);
                break;
            }
            case 4: {
                graphics.drawLine(n4, n5, n4 + n6 - 3, n5);
                graphics.setColor(bl2 ? this.shadow : this.unselectedTabShadow);
                graphics.drawLine(n4 + n6 - 3, n5, n4 + n6 - 3, n5 + 1);
                graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 2);
                graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 3);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 3, n4 + n6 - 2, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 3, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 1);
                graphics.drawLine(n4, n5 + n7 - 1, n4 + n6 - 3, n5 + n7 - 1);
                break;
            }
            case 3: {
                graphics.drawLine(n4, n5, n4, n5 + n7 - 3);
                graphics.drawLine(n4 + 1, n5 + n7 - 3, n4 + 1, n5 + n7 - 2);
                graphics.drawLine(n4 + 2, n5 + n7 - 2, n4 + 2, n5 + n7 - 1);
                graphics.setColor(bl2 ? this.shadow : this.unselectedTabShadow);
                graphics.drawLine(n4 + 3, n5 + n7 - 1, n4 + n6 - 4, n5 + n7 - 1);
                graphics.drawLine(n4 + n6 - 3, n5 + n7 - 2, n4 + n6 - 3, n5 + n7 - 1);
                graphics.drawLine(n4 + n6 - 2, n5 + n7 - 3, n4 + n6 - 2, n5 + n7 - 2);
                graphics.drawLine(n4 + n6 - 1, n5, n4 + n6 - 1, n5 + n7 - 3);
                break;
            }
            default: {
                graphics.drawLine(n4, n5 + 2, n4, n5 + n7 - 1);
                graphics.drawLine(n4 + 1, n5 + 1, n4 + 1, n5 + 2);
                graphics.drawLine(n4 + 2, n5, n4 + 2, n5 + 1);
                graphics.drawLine(n4 + 3, n5, n4 + n6 - 4, n5);
                graphics.setColor(bl2 ? this.shadow : this.unselectedTabShadow);
                graphics.drawLine(n4 + n6 - 3, n5, n4 + n6 - 3, n5 + 1);
                graphics.drawLine(n4 + n6 - 2, n5 + 1, n4 + n6 - 2, n5 + 2);
                graphics.drawLine(n4 + n6 - 1, n5 + 2, n4 + n6 - 1, n5 + n7 - 1);
            }
        }
    }

    protected void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
        Rectangle rectangle3 = rectangleArray[n3];
        if (this.tabPane.hasFocus() && bl2) {
            int n4;
            int n5;
            int n6;
            int n7;
            graphics.setColor(this.focus);
            switch (n2) {
                case 2: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 6;
                    n4 = rectangle3.height - 7;
                    break;
                }
                case 4: {
                    n7 = rectangle3.x + 2;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 6;
                    n4 = rectangle3.height - 7;
                    break;
                }
                case 3: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 2;
                    n5 = rectangle3.width - 7;
                    n4 = rectangle3.height - 6;
                    break;
                }
                default: {
                    n7 = rectangle3.x + 3;
                    n6 = rectangle3.y + 3;
                    n5 = rectangle3.width - 7;
                    n4 = rectangle3.height - 6;
                }
            }
            graphics.drawRect(n7, n6, n5, n4);
        }
    }

    protected int getTabRunIndent(int n2, int n3) {
        return n3 * 3;
    }

    protected int getTabRunOverlay(int n2) {
        this.tabRunOverlay = n2 == 2 || n2 == 4 ? (int)Math.round((double)this.maxTabWidth * 0.1) : (int)Math.round((double)this.maxTabHeight * 0.22);
        switch (n2) {
            case 2: {
                if (this.tabRunOverlay <= this.tabInsets.right - 2) break;
                this.tabRunOverlay = this.tabInsets.right - 2;
                break;
            }
            case 4: {
                if (this.tabRunOverlay <= this.tabInsets.left - 2) break;
                this.tabRunOverlay = this.tabInsets.left - 2;
                break;
            }
            case 1: {
                if (this.tabRunOverlay <= this.tabInsets.bottom - 2) break;
                this.tabRunOverlay = this.tabInsets.bottom - 2;
                break;
            }
            case 3: {
                if (this.tabRunOverlay <= this.tabInsets.top - 2) break;
                this.tabRunOverlay = this.tabInsets.top - 2;
            }
        }
        return this.tabRunOverlay;
    }
}

