/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.encoding.CDROutputStream_1_1;
import com.sun.corba.se.impl.encoding.CodeSetConversion;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import org.omg.CORBA.CompletionStatus;

public class CDROutputStream_1_2
extends CDROutputStream_1_1 {
    protected boolean primitiveAcrossFragmentedChunk = false;
    protected boolean specialChunk = false;
    private boolean headerPadding;

    protected void handleSpecialChunkBegin(int n2) {
        if (this.inBlock && n2 + this.bbwi.position() > this.bbwi.buflen) {
            int n3 = this.bbwi.position();
            this.bbwi.position(this.blockSizeIndex - 4);
            this.writeLongWithoutAlign(n3 - this.blockSizeIndex + n2);
            this.bbwi.position(n3);
            this.specialChunk = true;
        }
    }

    protected void handleSpecialChunkEnd() {
        if (this.inBlock && this.specialChunk) {
            this.inBlock = false;
            this.blockSizeIndex = -1;
            this.blockSizePosition = -1;
            this.start_block();
            this.specialChunk = false;
        }
    }

    private void checkPrimitiveAcrossFragmentedChunk() {
        if (this.primitiveAcrossFragmentedChunk) {
            this.primitiveAcrossFragmentedChunk = false;
            this.inBlock = false;
            this.blockSizeIndex = -1;
            this.blockSizePosition = -1;
            this.start_block();
        }
    }

    public void write_octet(byte by) {
        super.write_octet(by);
        this.checkPrimitiveAcrossFragmentedChunk();
    }

    public void write_short(short s2) {
        super.write_short(s2);
        this.checkPrimitiveAcrossFragmentedChunk();
    }

    public void write_long(int n2) {
        super.write_long(n2);
        this.checkPrimitiveAcrossFragmentedChunk();
    }

    public void write_longlong(long l2) {
        super.write_longlong(l2);
        this.checkPrimitiveAcrossFragmentedChunk();
    }

    void setHeaderPadding(boolean bl2) {
        this.headerPadding = bl2;
    }

    protected void alignAndReserve(int n2, int n3) {
        if (this.headerPadding) {
            this.headerPadding = false;
            this.alignOnBoundary(8);
        }
        this.bbwi.position(this.bbwi.position() + this.computeAlignment(n2));
        if (this.bbwi.position() + n3 > this.bbwi.buflen) {
            this.grow(n2, n3);
        }
    }

    protected void grow(int n2, int n3) {
        boolean bl2;
        int n4 = this.bbwi.position();
        boolean bl3 = bl2 = this.inBlock && !this.specialChunk;
        if (bl2) {
            int n5 = this.bbwi.position();
            this.bbwi.position(this.blockSizeIndex - 4);
            this.writeLongWithoutAlign(n5 - this.blockSizeIndex + n3);
            this.bbwi.position(n5);
        }
        this.bbwi.needed = n3;
        this.bufferManagerWrite.overflow(this.bbwi);
        if (this.bbwi.fragmented) {
            this.bbwi.fragmented = false;
            this.fragmentOffset += n4 - this.bbwi.position();
            if (bl2) {
                this.primitiveAcrossFragmentedChunk = true;
            }
        }
    }

    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_2;
    }

    public void write_wchar(char c2) {
        CodeSetConversion.CTBConverter cTBConverter = this.getWCharConverter();
        cTBConverter.convert(c2);
        this.handleSpecialChunkBegin(1 + cTBConverter.getNumBytes());
        this.write_octet((byte)cTBConverter.getNumBytes());
        byte[] byArray = cTBConverter.getBytes();
        this.internalWriteOctetArray(byArray, 0, cTBConverter.getNumBytes());
        this.handleSpecialChunkEnd();
    }

    public void write_wchar_array(char[] cArray, int n2, int n3) {
        if (cArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        CodeSetConversion.CTBConverter cTBConverter = this.getWCharConverter();
        int n4 = 0;
        int n5 = (int)Math.ceil(cTBConverter.getMaxBytesPerChar() * (float)n3);
        byte[] byArray = new byte[n5 + n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            cTBConverter.convert(cArray[n2 + i2]);
            byArray[n4++] = (byte)cTBConverter.getNumBytes();
            System.arraycopy(cTBConverter.getBytes(), 0, byArray, n4, cTBConverter.getNumBytes());
            n4 += cTBConverter.getNumBytes();
        }
        this.handleSpecialChunkBegin(n4);
        this.internalWriteOctetArray(byArray, 0, n4);
        this.handleSpecialChunkEnd();
    }

    public void write_wstring(String string) {
        if (string == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        if (string.length() == 0) {
            this.write_long(0);
            return;
        }
        CodeSetConversion.CTBConverter cTBConverter = this.getWCharConverter();
        cTBConverter.convert(string);
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 4 + cTBConverter.getNumBytes());
        this.write_long(cTBConverter.getNumBytes());
        this.internalWriteOctetArray(cTBConverter.getBytes(), 0, cTBConverter.getNumBytes());
        this.handleSpecialChunkEnd();
    }
}

