/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jazzlib;

import java.io.IOException;
import java.io.OutputStream;
import net.sf.jazzlib.CRC32;
import net.sf.jazzlib.Deflater;
import net.sf.jazzlib.DeflaterOutputStream;

public class GZIPOutputStream
extends DeflaterOutputStream {
    protected CRC32 crc = new CRC32();

    public GZIPOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 4096);
    }

    public GZIPOutputStream(OutputStream outputStream, int n) throws IOException {
        super(outputStream, new Deflater(-1, true), n);
        int n2 = (int)(System.currentTimeMillis() / 1000L);
        byte[] byArray = new byte[]{31, -117, 8, 0, (byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24), 0, -1};
        outputStream.write(byArray);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.crc.update(byArray, n, n2);
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void finish() throws IOException {
        super.finish();
        int n = this.def.getTotalIn();
        int n2 = (int)(this.crc.getValue() & 0xFFFFFFFFFFFFFFFFL);
        byte[] byArray = new byte[]{(byte)n2, (byte)(n2 >> 8), (byte)(n2 >> 16), (byte)(n2 >> 24), (byte)n, (byte)(n >> 8), (byte)(n >> 16), (byte)(n >> 24)};
        this.out.write(byArray);
    }
}

