/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.propertysheet;

import com.l2fprod.common.propertysheet.CellEditorAdapter;
import com.l2fprod.common.propertysheet.Property;
import com.l2fprod.common.propertysheet.PropertyEditorRegistry;
import com.l2fprod.common.propertysheet.PropertyRendererRegistry;
import com.l2fprod.common.propertysheet.PropertySheetTableModel;
import com.l2fprod.common.swing.HeaderlessColumnResizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PropertySheetTable
extends JTable {
    private static final TableCellRenderer categoryRenderer = new CategoryRenderer();
    private static final TableCellRenderer propertyRenderer = new PropertyRenderer();
    private static final int HOTSPOT_SIZE = 18;
    private static final String BACKGROUND_COLOR_KEY = "Panel.background";
    private PropertyEditorRegistry registry;
    private PropertyRendererRegistry renderers;
    private TableModelListener cancelEditing = new TableModelListener(){

        public void tableChanged(TableModelEvent e) {
            if (e.getType() == 0) {
                int first = e.getFirstRow();
                int last = e.getLastRow();
                int editingRow = PropertySheetTable.this.getEditingRow();
                TableCellEditor editor = PropertySheetTable.this.getCellEditor();
                if (editor != null && editingRow >= first && editingRow <= last) {
                    editor.cancelCellEditing();
                }
            }
        }
    };
    static /* synthetic */ Class class$java$lang$Object;

    public PropertySheetTable() {
        this(new PropertySheetTableModel());
    }

    public PropertySheetTable(PropertySheetTableModel dm) {
        super(dm);
        this.addMouseListener(new CategoryVisibilityToggle());
        this.setGridColor(UIManager.getColor(BACKGROUND_COLOR_KEY));
        this.getSelectionModel().setSelectionMode(0);
        Dimension nullSize = new Dimension(0, 0);
        this.getTableHeader().setPreferredSize(nullSize);
        this.getTableHeader().setMinimumSize(nullSize);
        this.getTableHeader().setMaximumSize(nullSize);
        this.getTableHeader().setVisible(false);
        new HeaderlessColumnResizer(this);
        this.setRendererRegistry(new PropertyRendererRegistry());
        this.setEditorRegistry(new PropertyEditorRegistry());
    }

    public final void setEditorRegistry(PropertyEditorRegistry registry) {
        this.registry = registry;
    }

    public final PropertyEditorRegistry getEditorRegistry() {
        return this.registry;
    }

    public final void setRendererRegistry(PropertyRendererRegistry registry) {
        this.renderers = registry;
    }

    public final PropertyRendererRegistry getRendererRegistry() {
        return this.renderers;
    }

    public final boolean isCellEditable(int row, int column) {
        if (column == 0) {
            return false;
        }
        Object o = ((PropertySheetTableModel)this.getModel()).getPropertySheetElement(row);
        if (o instanceof Property) {
            return ((Property)o).isEditable();
        }
        return false;
    }

    public final TableCellEditor getCellEditor(int row, int column) {
        if (column == 0) {
            return null;
        }
        Object o = ((PropertySheetTableModel)this.getModel()).getPropertySheetElement(row);
        if (o instanceof Property) {
            Property prop = (Property)o;
            PropertyEditor editor = this.getEditorRegistry().getEditor(prop);
            if (editor != null) {
                return new CellEditorAdapter(editor);
            }
            return null;
        }
        return null;
    }

    public final TableCellRenderer getCellRenderer(int row, int column) {
        Object o = ((PropertySheetTableModel)this.getModel()).getPropertySheetElement(row);
        if (o instanceof PropertySheetTableModel.Category) {
            return categoryRenderer;
        }
        if (column == 0) {
            return propertyRenderer;
        }
        if (column == 1) {
            Property property = (Property)o;
            TableCellRenderer renderer = this.getRendererRegistry().getRenderer(property);
            if (renderer == null) {
                renderer = this.getCellRenderer(property.getType());
            }
            return new WrappedRenderer(renderer);
        }
        return super.getCellRenderer(row, column);
    }

    private TableCellRenderer getCellRenderer(Class type) {
        TableCellRenderer renderer = this.getRendererRegistry().getRenderer(type);
        if (renderer == null && type != null) {
            renderer = this.getCellRenderer(type.getSuperclass());
        }
        if (renderer == null) {
            renderer = super.getDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = PropertySheetTable.class$("java.lang.Object")) : class$java$lang$Object);
        }
        return renderer;
    }

    public final PropertySheetTableModel getSheetModel() {
        return (PropertySheetTableModel)this.getModel();
    }

    public void setModel(TableModel dataModel) {
        TableModel oldModel = this.getModel();
        if (oldModel != null) {
            oldModel.removeTableModelListener(this.cancelEditing);
        }
        super.setModel(dataModel);
        dataModel.addTableModelListener(this.cancelEditing);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CategoryRenderer
    extends DefaultTableCellRenderer {
        private Color background;
        private Color foreground;

        public CategoryRenderer() {
            this(UIManager.getColor(PropertySheetTable.BACKGROUND_COLOR_KEY), UIManager.getColor(PropertySheetTable.BACKGROUND_COLOR_KEY).darker());
        }

        public CategoryRenderer(Color background, Color foreground) {
            this.setBorder(new CellBorder(UIManager.getColor(PropertySheetTable.BACKGROUND_COLOR_KEY)));
            this.background = background;
            this.foreground = foreground;
            this.setFont(this.getFont().deriveFont(1));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            PropertySheetTableModel.Category category = (PropertySheetTableModel.Category)value;
            this.setBackground(this.background);
            this.setForeground(this.foreground);
            if (column == 0) {
                ((CellBorder)this.getBorder()).setToggle(category.isVisible());
                ((CellBorder)this.getBorder()).setToggleVisible(true);
                this.setText(category.getName());
            } else {
                ((CellBorder)this.getBorder()).setToggleVisible(false);
                this.setText("");
            }
            return this;
        }
    }

    private static class WrappedRenderer
    implements TableCellRenderer {
        private TableCellRenderer renderer;

        public WrappedRenderer(TableCellRenderer renderer) {
            this.renderer = renderer;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.renderer.getTableCellRendererComponent(table, value, false, false, row, column);
        }
    }

    private static class PropertyRenderer
    extends DefaultTableCellRenderer {
        private PropertyRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Property property = (Property)value;
            this.setText(property.getDisplayName());
            if (!isSelected) {
                this.setEnabled(property.isEditable());
            } else {
                this.setEnabled(true);
            }
            this.setBorder(new CellBorder(UIManager.getColor(PropertySheetTable.BACKGROUND_COLOR_KEY)));
            return this;
        }
    }

    private static class CellBorder
    implements Border {
        private Color background;
        private boolean showToggle;
        private boolean toggleState;
        private Icon expandedIcon = (Icon)UIManager.get("Tree.expandedIcon");
        private Icon collapsedIcon = (Icon)UIManager.get("Tree.collapsedIcon");

        public CellBorder(Color background) {
            this.background = background;
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(1, 18, 1, 1);
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color oldColor = g.getColor();
            g.setColor(this.background);
            g.fillRect(x, y, x + 18 - 2, y + height);
            g.setColor(oldColor);
            if (this.showToggle) {
                if (this.toggleState) {
                    this.expandedIcon.paintIcon(c, g, x + (16 - this.expandedIcon.getIconWidth()) / 2, y + (height - this.expandedIcon.getIconHeight()) / 2);
                } else {
                    this.collapsedIcon.paintIcon(c, g, x + (16 - this.collapsedIcon.getIconWidth()) / 2, y + (height - this.collapsedIcon.getIconHeight()) / 2);
                }
            }
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void setToggle(boolean state) {
            this.toggleState = state;
        }

        public void setToggleVisible(boolean visible) {
            this.showToggle = visible;
        }
    }

    private static class CategoryVisibilityToggle
    extends MouseAdapter {
        private CategoryVisibilityToggle() {
        }

        public void mouseReleased(MouseEvent event) {
            Object o;
            PropertySheetTable table = (PropertySheetTable)event.getComponent();
            int row = table.rowAtPoint(event.getPoint());
            int column = table.columnAtPoint(event.getPoint());
            if (row != -1 && column == 0 && event.getX() < 18 && (o = table.getSheetModel().getPropertySheetElement(row)) instanceof PropertySheetTableModel.Category) {
                ((PropertySheetTableModel.Category)o).toggle();
            }
        }
    }
}

