/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import sun.security.krb5.Config;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbAsRep;
import sun.security.krb5.KrbAsReq;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.bs;
import sun.security.krb5.internal.ccache.an;
import sun.security.krb5.internal.ccache.as;
import sun.security.krb5.internal.o;
import sun.security.krb5.internal.tools.KinitOptions;

public class Kinit {
    private KinitOptions a;
    private static final boolean b = bs.ed;

    public static void main(String[] stringArray) {
        try {
            Kinit kinit = new Kinit(stringArray);
        }
        catch (Exception exception) {
            String string = null;
            string = exception instanceof KrbException ? ((KrbException)exception).krbErrorMessage() + " " + ((KrbException)exception).returnCodeMessage() : exception.getMessage();
            if (string != null) {
                System.err.println("Exception: " + string);
            } else {
                System.out.println("Exception: " + exception);
            }
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private Kinit(String[] stringArray) throws IOException, RealmException, KrbException {
        Object object;
        Object object2;
        Config config = Config.getInstance();
        this.a = stringArray == null || stringArray.length == 0 ? new KinitOptions() : new KinitOptions(stringArray);
        String string = null;
        PrincipalName principalName = this.a.getPrincipal();
        if (principalName != null) {
            string = principalName.toString();
        }
        if (b) {
            System.out.println("Principal is " + principalName);
        }
        char[] cArray = this.a.b;
        EncryptionKey[] encryptionKeyArray = null;
        boolean bl2 = this.a.useKeytabFile();
        if (!bl2) {
            if (string == null) {
                throw new IllegalArgumentException(" Can not obtain principal name");
            }
            if (cArray == null) {
                object2 = new BufferedReader(new InputStreamReader(System.in));
                System.out.print("Password for " + string + ":");
                System.out.flush();
                cArray = ((BufferedReader)object2).readLine().toCharArray();
                if (b) {
                    System.out.println(">>> Kinit console input " + new String(cArray));
                }
            }
        } else {
            if (b) {
                System.out.println(">>> Kinit using keytab");
            }
            if (string == null) {
                throw new IllegalArgumentException("Principal name must be specified.");
            }
            object2 = this.a.keytabFileName();
            if (object2 != null && b) {
                System.out.println(">>> Kinit keytab file name: " + (String)object2);
            }
            if ((encryptionKeyArray = EncryptionKey.acquireSecretKeys(principalName, (String)object2)) == null || encryptionKeyArray.length == 0) {
                String string2 = "No supported key found in keytab";
                if (string != null) {
                    string2 = string2 + " for principal " + string;
                }
                throw new KrbException(string2);
            }
        }
        object2 = new o();
        Kinit.a(1, this.a.forwardable, (o)object2);
        Kinit.a(3, this.a.proxiable, (o)object2);
        String string3 = this.a.getKDCRealm();
        if (string3 == null) {
            string3 = config.getDefaultRealm();
        }
        if (b) {
            System.out.println(">>> Kinit realm name is " + string3);
        }
        PrincipalName principalName2 = new PrincipalName("krbtgt/" + string3);
        principalName2.setRealm(string3);
        if (b) {
            System.out.println(">>> Creating KrbAsReq");
        }
        KrbAsReq krbAsReq = null;
        try {
            object = null;
            if (this.a.getAddressOption()) {
                object = HostAddresses.getLocalAddresses();
            }
            krbAsReq = bl2 ? new KrbAsReq(encryptionKeyArray, (o)object2, principalName, principalName2, null, null, null, null, (HostAddresses)object, null) : new KrbAsReq(cArray, (o)object2, principalName, principalName2, null, null, null, null, (HostAddresses)object, null);
        }
        catch (KrbException krbException) {
            throw krbException;
        }
        catch (Exception exception) {
            throw new KrbException(exception.toString());
        }
        if (b) {
            System.out.println(">>> Kinit: sending as_req to realm " + string3);
        }
        object = krbAsReq.send(string3);
        if (b) {
            System.out.println(">>> reading response from kdc");
        }
        KrbAsRep krbAsRep = null;
        try {
            krbAsRep = bl2 ? krbAsReq.getReply(encryptionKeyArray) : krbAsReq.getReply(cArray);
        }
        catch (KrbException krbException) {
            if (krbException.returnCode() == 52) {
                krbAsReq.send(string3, (String)object, true);
                krbAsRep = bl2 ? krbAsReq.getReply(encryptionKeyArray) : krbAsReq.getReply(cArray);
            }
            throw krbException;
        }
        as as2 = krbAsRep.setCredentials();
        an an2 = an.b(principalName, this.a.cachename);
        if (an2 == null) {
            throw new IOException("Unable to create the cache file " + this.a.cachename);
        }
        an2.update(as2);
        an2.save();
        if (this.a.b == null) {
            System.out.println("New ticket is stored in cache file " + this.a.cachename);
        } else {
            Arrays.fill(this.a.b, '0');
        }
        if (cArray != null) {
            Arrays.fill(cArray, '0');
        }
        this.a = null;
    }

    private static void a(int n2, int n3, o o2) {
        switch (n3) {
            case 0: {
                break;
            }
            case -1: {
                o2.a(n2, false);
                break;
            }
            case 1: {
                o2.a(n2, true);
            }
        }
    }
}

