/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import com.sun.beans.ObjectHandler;
import java.beans.ExceptionListener;
import java.beans.NameGenerator;
import java.beans.ReflectionUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Statement {
    private static Object[] emptyArray = new Object[0];
    static ExceptionListener defaultExceptionListener = new ExceptionListener(){

        public void exceptionThrown(Exception exception) {
            System.err.println(exception);
            System.err.println("Continuing ...");
        }
    };
    Object target;
    String methodName;
    Object[] arguments;

    public Statement(Object object, String string, Object[] objectArray) {
        this.target = object;
        this.methodName = string;
        this.arguments = objectArray == null ? emptyArray : objectArray;
    }

    public Object getTarget() {
        return this.target;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void execute() throws Exception {
        this.invoke();
    }

    Object invoke() throws Exception {
        Object object = this.getTarget();
        String string = this.getMethodName();
        if (object == null || string == null) {
            throw new NullPointerException((object == null ? "target" : "methodName") + " should not be null");
        }
        Object[] objectArray = this.getArguments();
        if (object == Class.class && string.equals("forName")) {
            return ObjectHandler.classForName((String)objectArray[0]);
        }
        Class[] classArray = new Class[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            classArray[i2] = objectArray[i2] == null ? null : objectArray[i2].getClass();
        }
        AccessibleObject accessibleObject = null;
        if (object instanceof Class) {
            if (string.equals("new")) {
                string = "newInstance";
            }
            if (string.equals("newInstance") && ((Class)object).isArray()) {
                Object object2 = Array.newInstance(((Class)object).getComponentType(), objectArray.length);
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    Array.set(object2, i3, objectArray[i3]);
                }
                return object2;
            }
            if (string.equals("newInstance") && objectArray.length != 0) {
                if (object == Character.class && objectArray.length == 1 && classArray[0] == String.class) {
                    return new Character(((String)objectArray[0]).charAt(0));
                }
                accessibleObject = ReflectionUtils.getConstructor((Class)object, classArray);
            }
            if (accessibleObject == null) {
                accessibleObject = ReflectionUtils.getMethod((Class)object, string, classArray);
            }
            if (accessibleObject == null) {
                accessibleObject = ReflectionUtils.getMethod(Class.class, string, classArray);
            }
        } else {
            if (object.getClass().isArray() && (string.equals("set") || string.equals("get"))) {
                int n2 = (Integer)objectArray[0];
                if (string.equals("get")) {
                    return Array.get(object, n2);
                }
                Array.set(object, n2, objectArray[1]);
                return null;
            }
            accessibleObject = ReflectionUtils.getMethod(object.getClass(), string, classArray);
        }
        if (accessibleObject != null) {
            try {
                if (accessibleObject instanceof Method) {
                    return accessibleObject.invoke(object, objectArray);
                }
                return ((Constructor)accessibleObject).newInstance(objectArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Exception("Statement cannot invoke: " + string + " on " + object.getClass(), illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw invocationTargetException;
            }
        }
        throw new NoSuchMethodException(this.toString());
    }

    String instanceName(Object object) {
        if (object == null) {
            return "null";
        }
        if (object.getClass() == String.class) {
            return "\"" + (String)object + "\"";
        }
        return NameGenerator.unqualifiedClassName(object.getClass());
    }

    public String toString() {
        Object object = this.getTarget();
        String string = this.getMethodName();
        Object[] objectArray = this.getArguments();
        StringBuffer stringBuffer = new StringBuffer(this.instanceName(object) + "." + string + "(");
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(this.instanceName(objectArray[i2]));
            if (i2 == n2 - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(");");
        return stringBuffer.toString();
    }
}

