/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.SaslException;
import sun.misc.HexDumpEncoder;

public abstract class AbstractSaslImpl {
    protected static Logger logger;
    protected boolean completed = false;
    protected boolean privacy = false;
    protected boolean integrity = false;
    protected byte[] qop;
    protected byte allQop;
    protected byte[] strength;
    protected int sendMaxBufSize = 0;
    protected int recvMaxBufSize = 65536;
    protected int rawSendSize;
    protected String myClassName;
    private static final String SASL_LOGGER_NAME = "javax.security.sasl";
    protected static final String MAX_SEND_BUF = "javax.security.sasl.sendmaxbuffer";
    protected static final byte NO_PROTECTION = 1;
    protected static final byte INTEGRITY_ONLY_PROTECTION = 2;
    protected static final byte PRIVACY_PROTECTION = 4;
    protected static final byte LOW_STRENGTH = 1;
    protected static final byte MEDIUM_STRENGTH = 2;
    protected static final byte HIGH_STRENGTH = 4;
    private static final byte[] DEFAULT_QOP;
    private static final String[] QOP_TOKENS;
    private static final byte[] QOP_MASKS;
    private static final byte[] DEFAULT_STRENGTH;
    private static final String[] STRENGTH_TOKENS;
    private static final byte[] STRENGTH_MASKS;

    protected AbstractSaslImpl(Map map, String string) throws SaslException {
        AbstractSaslImpl.initLogger();
        this.myClassName = string;
        if (map != null) {
            int n2;
            StringBuffer stringBuffer;
            String string2 = (String)map.get("javax.security.sasl.qop");
            this.qop = AbstractSaslImpl.parseQop(string2);
            logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL01:Preferred qop property: {0}", string2);
            this.allQop = AbstractSaslImpl.combineMasks(this.qop);
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL02:Preferred qop mask: {0}", new Byte(this.allQop));
                if (this.qop.length > 0) {
                    stringBuffer = new StringBuffer();
                    for (n2 = 0; n2 < this.qop.length; ++n2) {
                        stringBuffer.append(Byte.toString(this.qop[n2]));
                        stringBuffer.append(' ');
                    }
                    logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL03:Preferred qops : {0}", stringBuffer.toString());
                }
            }
            string2 = (String)map.get("javax.security.sasl.strength");
            this.strength = AbstractSaslImpl.parseStrength(string2);
            logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL04:Preferred strength property: {0}", string2);
            if (logger.isLoggable(Level.FINE) && this.strength.length > 0) {
                stringBuffer = new StringBuffer();
                for (n2 = 0; n2 < this.strength.length; ++n2) {
                    stringBuffer.append(Byte.toString(this.strength[n2]));
                    stringBuffer.append(' ');
                }
                logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL05:Cipher strengths: {0}", stringBuffer.toString());
            }
            if ((string2 = (String)map.get("javax.security.sasl.maxbuffer")) != null) {
                try {
                    logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL06:Max receive buffer size: {0}", string2);
                    this.recvMaxBufSize = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SaslException("Property must be string representation of integer: javax.security.sasl.maxbuffer");
                }
            }
            if ((string2 = (String)map.get(MAX_SEND_BUF)) != null) {
                try {
                    logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL07:Max send buffer size: {0}", string2);
                    this.sendMaxBufSize = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SaslException("Property must be string representation of integer: javax.security.sasl.sendmaxbuffer");
                }
            }
        } else {
            this.qop = DEFAULT_QOP;
            this.allQop = 1;
            this.strength = STRENGTH_MASKS;
        }
    }

    public boolean isComplete() {
        return this.completed;
    }

    public Object getNegotiatedProperty(String string) {
        if (!this.completed) {
            throw new IllegalStateException("SASL authentication not completed");
        }
        if (string.equals("javax.security.sasl.qop")) {
            if (this.privacy) {
                return "auth-conf";
            }
            if (this.integrity) {
                return "auth-int";
            }
            return "auth";
        }
        if (string.equals("javax.security.sasl.maxbuffer")) {
            return Integer.toString(this.recvMaxBufSize);
        }
        if (string.equals("javax.security.sasl.rawsendsize")) {
            return Integer.toString(this.rawSendSize);
        }
        if (string.equals(MAX_SEND_BUF)) {
            return Integer.toString(this.sendMaxBufSize);
        }
        return null;
    }

    protected static final byte combineMasks(byte[] byArray) {
        byte by = 0;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            by = (byte)(by | byArray[i2]);
        }
        return by;
    }

    protected static final byte findPreferredMask(byte by, byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if ((byArray[i2] & by) == 0) continue;
            return byArray[i2];
        }
        return 0;
    }

    private static final byte[] parseQop(String string) throws SaslException {
        return AbstractSaslImpl.parseQop(string, null, false);
    }

    protected static final byte[] parseQop(String string, String[] stringArray, boolean bl2) throws SaslException {
        if (string == null) {
            return DEFAULT_QOP;
        }
        return AbstractSaslImpl.parseProp("javax.security.sasl.qop", string, QOP_TOKENS, QOP_MASKS, stringArray, bl2);
    }

    private static final byte[] parseStrength(String string) throws SaslException {
        if (string == null) {
            return DEFAULT_STRENGTH;
        }
        return AbstractSaslImpl.parseProp("javax.security.sasl.strength", string, STRENGTH_TOKENS, STRENGTH_MASKS, null, false);
    }

    private static final byte[] parseProp(String string, String string2, String[] stringArray, byte[] byArray, String[] stringArray2, boolean bl2) throws SaslException {
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", \t\n");
        byte[] byArray2 = new byte[stringArray.length];
        int n3 = 0;
        while (stringTokenizer.hasMoreTokens() && n3 < byArray2.length) {
            String string3 = stringTokenizer.nextToken();
            boolean bl3 = false;
            for (n2 = 0; !bl3 && n2 < stringArray.length; ++n2) {
                if (!string3.equalsIgnoreCase(stringArray[n2])) continue;
                bl3 = true;
                byArray2[n3++] = byArray[n2];
                if (stringArray2 == null) continue;
                stringArray2[n2] = string3;
            }
            if (bl3 || bl2) continue;
            throw new SaslException("Invalid token in " + string + ": " + string2);
        }
        for (n2 = n3; n2 < byArray2.length; ++n2) {
            byArray2[n2] = 0;
        }
        return byArray2;
    }

    protected static final void traceOutput(String string, String string2, String string3, byte[] byArray) {
        AbstractSaslImpl.traceOutput(string, string2, string3, byArray, 0, byArray.length);
    }

    protected static final void traceOutput(String string, String string2, String string3, byte[] byArray, int n2, int n3) {
        try {
            Level level;
            int n4 = n3;
            if (!logger.isLoggable(Level.FINEST)) {
                n3 = Math.min(16, n3);
                level = Level.FINER;
            } else {
                level = Level.FINEST;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n3);
            new HexDumpEncoder().encodeBuffer(new ByteArrayInputStream(byArray, n2, n3), (OutputStream)byteArrayOutputStream);
            logger.logp(level, string, string2, "{0} ( {1} ): {2}", new Object[]{string3, new Integer(n4), byteArrayOutputStream.toString()});
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, string, string2, "SASLIMPL09:Error generating trace output: {0}", exception);
        }
    }

    protected static final int networkByteOrderToInt(byte[] byArray, int n2, int n3) {
        if (n3 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            n4 <<= 8;
            n4 |= byArray[n2 + i2] & 0xFF;
        }
        return n4;
    }

    protected static final void intToNetworkByteOrder(int n2, byte[] byArray, int n3, int n4) {
        if (n4 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        for (int i2 = n4 - 1; i2 >= 0; --i2) {
            byArray[n3 + i2] = (byte)(n2 & 0xFF);
            n2 >>>= 8;
        }
    }

    private static synchronized void initLogger() {
        if (logger == null) {
            logger = Logger.getLogger(SASL_LOGGER_NAME);
        }
    }

    static {
        DEFAULT_QOP = new byte[]{1};
        QOP_TOKENS = new String[]{"auth-conf", "auth-int", "auth"};
        QOP_MASKS = new byte[]{4, 2, 1};
        DEFAULT_STRENGTH = new byte[]{4, 2, 1};
        STRENGTH_TOKENS = new String[]{"low", "medium", "high"};
        STRENGTH_MASKS = new byte[]{1, 2, 4};
    }
}

