/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

import sun.text.Utility;

public final class CompactByteArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    private static final int BLOCKSHIFT = 7;
    private static final int BLOCKCOUNT = 128;
    private static final int INDEXSHIFT = 9;
    private static final int INDEXCOUNT = 512;
    private static final int BLOCKMASK = 127;
    private byte[] values;
    private short[] indices;
    private boolean isCompact;
    private int[] hashes;

    public CompactByteArray() {
        this(0);
    }

    public CompactByteArray(byte by) {
        int n2;
        this.values = new byte[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        for (n2 = 0; n2 < 65536; ++n2) {
            this.values[n2] = by;
        }
        for (n2 = 0; n2 < 512; ++n2) {
            this.indices[n2] = (short)(n2 << 7);
            this.hashes[n2] = 0;
        }
        this.isCompact = false;
    }

    public CompactByteArray(short[] sArray, byte[] byArray) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds!");
        }
        for (int i2 = 0; i2 < 512; ++i2) {
            short s2 = sArray[i2];
            if (s2 >= 0 && s2 < byArray.length + 128) continue;
            throw new IllegalArgumentException("Index out of bounds!");
        }
        this.indices = sArray;
        this.values = byArray;
        this.isCompact = true;
    }

    public CompactByteArray(String string, String string2) {
        this(Utility.RLEStringToShortArray(string), Utility.RLEStringToByteArray(string2));
    }

    public byte elementAt(char c2) {
        return this.values[(this.indices[c2 >> 7] & 0xFFFF) + (c2 & 0x7F)];
    }

    public void setElementAt(char c2, byte by) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c2] = by;
        this.touchBlock(c2 >> 7, by);
    }

    public void setElementAt(char n2, char c2, byte by) {
        if (this.isCompact) {
            this.expand();
        }
        for (int i2 = n2; i2 <= c2; ++i2) {
            this.values[i2] = by;
            this.touchBlock(i2 >> 7, by);
        }
    }

    public void compact() {
        if (!this.isCompact) {
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.indices.length) {
                this.indices[n5] = -1;
                boolean bl2 = this.blockTouched(n5);
                if (!bl2 && n4 != -1) {
                    this.indices[n5] = n4;
                } else {
                    int n6 = 0;
                    int n7 = 0;
                    n7 = 0;
                    while (n7 < n2) {
                        if (this.hashes[n5] == this.hashes[n7] && CompactByteArray.arrayRegionMatches(this.values, n3, this.values, n6, 128)) {
                            this.indices[n5] = (short)n6;
                            break;
                        }
                        ++n7;
                        n6 += 128;
                    }
                    if (this.indices[n5] == -1) {
                        System.arraycopy(this.values, n3, this.values, n6, 128);
                        this.indices[n5] = (short)n6;
                        this.hashes[n7] = this.hashes[n5];
                        ++n2;
                        if (!bl2) {
                            n4 = (short)n6;
                        }
                    }
                }
                ++n5;
                n3 += 128;
            }
            n5 = n2 * 128;
            byte[] byArray = new byte[n5];
            System.arraycopy(this.values, 0, byArray, 0, n5);
            this.values = byArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    static final boolean arrayRegionMatches(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        for (int i2 = n2; i2 < n5; ++i2) {
            if (byArray[i2] == byArray2[i2 + n6]) continue;
            return false;
        }
        return true;
    }

    private final void touchBlock(int n2, int n3) {
        this.hashes[n2] = this.hashes[n2] + (n3 << 1) | 1;
    }

    private final boolean blockTouched(int n2) {
        return this.hashes[n2] != 0;
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public byte[] getStringArray() {
        return this.values;
    }

    public Object clone() {
        try {
            CompactByteArray compactByteArray = (CompactByteArray)super.clone();
            compactByteArray.values = (byte[])this.values.clone();
            compactByteArray.indices = (short[])this.indices.clone();
            if (this.hashes != null) {
                compactByteArray.hashes = (int[])this.hashes.clone();
            }
            return compactByteArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactByteArray compactByteArray = (CompactByteArray)object;
        for (int i2 = 0; i2 < 65536; ++i2) {
            if (this.elementAt((char)i2) == compactByteArray.elementAt((char)i2)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = Math.min(3, this.values.length / 16);
        for (int i2 = 0; i2 < this.values.length; i2 += n3) {
            n2 = n2 * 37 + this.values[i2];
        }
        return n2;
    }

    private void expand() {
        if (this.isCompact) {
            int n2;
            this.hashes = new int[512];
            byte[] byArray = new byte[65536];
            for (n2 = 0; n2 < 65536; ++n2) {
                byte by;
                byArray[n2] = by = this.elementAt((char)n2);
                this.touchBlock(n2 >> 7, by);
            }
            for (n2 = 0; n2 < 512; ++n2) {
                this.indices[n2] = (short)(n2 << 7);
            }
            this.values = null;
            this.values = byArray;
            this.isCompact = false;
        }
    }

    private byte[] getArray() {
        return this.values;
    }
}

