/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVA;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.GeneralSubtree;
import sun.security.x509.GeneralSubtrees;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.RFC822Name;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;

public class NameConstraintsExtension
extends Extension
implements CertAttrSet,
Cloneable {
    public static final String IDENT = "x509.info.extensions.NameConstraints";
    public static final String NAME = "NameConstraints";
    public static final String PERMITTED_SUBTREES = "permitted_subtrees";
    public static final String EXCLUDED_SUBTREES = "excluded_subtrees";
    private static final byte TAG_PERMITTED = 0;
    private static final byte TAG_EXCLUDED = 1;
    private GeneralSubtrees permitted = null;
    private GeneralSubtrees excluded = null;
    private boolean hasMin;
    private boolean hasMax;
    private boolean minMaxValid = false;

    private void calcMinMax() throws IOException {
        GeneralSubtree generalSubtree;
        int n2;
        this.hasMin = false;
        this.hasMax = false;
        if (this.excluded != null) {
            for (n2 = 0; n2 < this.excluded.size(); ++n2) {
                generalSubtree = this.excluded.get(n2);
                if (generalSubtree.getMinimum() != 0) {
                    this.hasMin = true;
                }
                if (generalSubtree.getMaximum() == -1) continue;
                this.hasMax = true;
            }
        }
        if (this.permitted != null) {
            for (n2 = 0; n2 < this.permitted.size(); ++n2) {
                generalSubtree = this.permitted.get(n2);
                if (generalSubtree.getMinimum() != 0) {
                    this.hasMin = true;
                }
                if (generalSubtree.getMaximum() == -1) continue;
                this.hasMax = true;
            }
        }
        this.minMaxValid = true;
    }

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        this.minMaxValid = false;
        if (this.permitted == null && this.excluded == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.permitted != null) {
            derOutputStream = new DerOutputStream();
            this.permitted.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)0), derOutputStream);
        }
        if (this.excluded != null) {
            derOutputStream = new DerOutputStream();
            this.excluded.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream3);
        this.extensionValue = derOutputStream2.toByteArray();
    }

    public NameConstraintsExtension(GeneralSubtrees generalSubtrees, GeneralSubtrees generalSubtrees2) throws IOException {
        this.permitted = generalSubtrees;
        this.excluded = generalSubtrees2;
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = true;
        this.encodeThis();
    }

    public NameConstraintsExtension(Boolean bl2, Object object) throws IOException {
        this.extensionId = PKIXExtensions.NameConstraints_Id;
        this.critical = bl2;
        this.extensionValue = (byte[])object;
        DerValue derValue = new DerValue(this.extensionValue);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for NameConstraintsExtension.");
        }
        if (derValue.data == null) {
            return;
        }
        while (derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.isContextSpecific((byte)0) && derValue2.isConstructed()) {
                if (this.permitted != null) {
                    throw new IOException("Duplicate permitted GeneralSubtrees in NameConstraintsExtension.");
                }
                derValue2.resetTag((byte)48);
                this.permitted = new GeneralSubtrees(derValue2);
                continue;
            }
            if (derValue2.isContextSpecific((byte)1) && derValue2.isConstructed()) {
                if (this.excluded != null) {
                    throw new IOException("Duplicate excluded GeneralSubtrees in NameConstraintsExtension.");
                }
                derValue2.resetTag((byte)48);
                this.excluded = new GeneralSubtrees(derValue2);
                continue;
            }
            throw new IOException("Invalid encoding of NameConstraintsExtension.");
        }
        this.minMaxValid = false;
    }

    public String toString() {
        return super.toString() + "NameConstraints: [" + (this.permitted == null ? "" : "\n    Permitted:" + this.permitted.toString()) + (this.excluded == null ? "" : "\n    Excluded:" + this.excluded.toString()) + "   ]\n";
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.NameConstraints_Id;
            this.critical = true;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            if (!(object instanceof GeneralSubtrees)) {
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.permitted = (GeneralSubtrees)object;
        } else if (string.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            if (!(object instanceof GeneralSubtrees)) {
                throw new IOException("Attribute value should be of type GeneralSubtrees.");
            }
            this.excluded = (GeneralSubtrees)object;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        this.encodeThis();
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            return this.permitted;
        }
        if (string.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            return this.excluded;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(PERMITTED_SUBTREES)) {
            this.permitted = null;
        } else if (string.equalsIgnoreCase(EXCLUDED_SUBTREES)) {
            this.excluded = null;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:NameConstraintsExtension.");
        }
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(PERMITTED_SUBTREES);
        attributeNameEnumeration.addElement(EXCLUDED_SUBTREES);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public void merge(NameConstraintsExtension nameConstraintsExtension) throws IOException {
        if (nameConstraintsExtension == null) {
            return;
        }
        GeneralSubtrees generalSubtrees = (GeneralSubtrees)nameConstraintsExtension.get(EXCLUDED_SUBTREES);
        if (this.excluded == null) {
            this.excluded = generalSubtrees != null ? (GeneralSubtrees)generalSubtrees.clone() : null;
        } else if (generalSubtrees != null) {
            this.excluded.union(generalSubtrees);
        }
        GeneralSubtrees generalSubtrees2 = (GeneralSubtrees)nameConstraintsExtension.get(PERMITTED_SUBTREES);
        if (this.permitted == null) {
            this.permitted = generalSubtrees2 != null ? (GeneralSubtrees)generalSubtrees2.clone() : null;
        } else if (generalSubtrees2 != null && (generalSubtrees = this.permitted.intersect(generalSubtrees2)) != null) {
            if (this.excluded != null) {
                this.excluded.union(generalSubtrees);
            } else {
                this.excluded = (GeneralSubtrees)generalSubtrees.clone();
            }
        }
        if (this.permitted != null) {
            this.permitted.reduce(this.excluded);
        }
        this.encodeThis();
    }

    public boolean verify(X509Certificate x509Certificate) throws IOException {
        Object object;
        if (x509Certificate == null) {
            throw new IOException("Certificate is null");
        }
        if (!this.minMaxValid) {
            this.calcMinMax();
        }
        if (this.hasMin) {
            throw new IOException("Non-zero minimum BaseDistance in name constraints not supported");
        }
        if (this.hasMax) {
            throw new IOException("Maximum BaseDistance in name constraints not supported");
        }
        X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
        X500Name x500Name = X500Name.asX500Name(x500Principal);
        if (!x500Name.isEmpty() && !this.verify(x500Name)) {
            return false;
        }
        GeneralNames generalNames = null;
        try {
            X509CertImpl x509CertImpl = X509CertImpl.toImpl(x509Certificate);
            object = x509CertImpl.getSubjectAlternativeNameExtension();
            if (object != null) {
                generalNames = (GeneralNames)((SubjectAlternativeNameExtension)object).get("subject_name");
            }
        }
        catch (CertificateException certificateException) {
            throw new IOException("Unable to extract extensions from certificate: " + certificateException.getMessage());
        }
        if (generalNames == null) {
            return this.verifyRFC822SpecialCase(x500Name);
        }
        for (int i2 = 0; i2 < generalNames.size(); ++i2) {
            object = generalNames.get(i2).getName();
            if (this.verify((GeneralNameInterface)object)) continue;
            return false;
        }
        return true;
    }

    public boolean verify(GeneralNameInterface generalNameInterface) throws IOException {
        Object object;
        Object object2;
        int n2;
        if (generalNameInterface == null) {
            throw new IOException("name is null");
        }
        if (this.excluded != null && this.excluded.size() > 0) {
            block9: for (n2 = 0; n2 < this.excluded.size(); ++n2) {
                GeneralSubtree generalSubtree = this.excluded.get(n2);
                if (generalSubtree == null || (object2 = generalSubtree.getName()) == null || (object = ((GeneralName)object2).getName()) == null) continue;
                switch (object.constrains(generalNameInterface)) {
                    case -1: 
                    case 2: 
                    case 3: {
                        continue block9;
                    }
                    case 0: 
                    case 1: {
                        return false;
                    }
                }
            }
        }
        if (this.permitted != null && this.permitted.size() > 0) {
            n2 = 0;
            block10: for (int i2 = 0; i2 < this.permitted.size(); ++i2) {
                GeneralNameInterface generalNameInterface2;
                object2 = this.permitted.get(i2);
                if (object2 == null || (object = ((GeneralSubtree)object2).getName()) == null || (generalNameInterface2 = ((GeneralName)object).getName()) == null) continue;
                switch (generalNameInterface2.constrains(generalNameInterface)) {
                    case -1: {
                        continue block10;
                    }
                    case 2: 
                    case 3: {
                        n2 = 1;
                        continue block10;
                    }
                    case 0: 
                    case 1: {
                        return true;
                    }
                }
            }
            if (n2 != 0) {
                return false;
            }
        }
        return true;
    }

    public boolean verifyRFC822SpecialCase(X500Name x500Name) throws IOException {
        for (AVA aVA : x500Name.allAvas()) {
            RFC822Name rFC822Name;
            String string;
            ObjectIdentifier objectIdentifier = aVA.getObjectIdentifier();
            if (!objectIdentifier.equals(PKCS9Attribute.EMAIL_ADDRESS_OID) || (string = aVA.getValueString()) == null) continue;
            try {
                rFC822Name = new RFC822Name(string);
            }
            catch (IOException iOException) {
                continue;
            }
            if (this.verify(rFC822Name)) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        try {
            NameConstraintsExtension nameConstraintsExtension = (NameConstraintsExtension)super.clone();
            if (this.permitted != null) {
                nameConstraintsExtension.permitted = (GeneralSubtrees)this.permitted.clone();
            }
            if (this.excluded != null) {
                nameConstraintsExtension.excluded = (GeneralSubtrees)this.excluded.clone();
            }
            return nameConstraintsExtension;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("CloneNotSupportedException while cloning NameConstraintsException. This should never happen.");
        }
    }
}

