/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvmmib;

import com.sun.jmx.snmp.SnmpCounter64;
import com.sun.jmx.snmp.SnmpGauge;
import com.sun.jmx.snmp.SnmpInt;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibGroup;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpStandardMetaServer;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import javax.management.MBeanServer;
import sun.management.snmp.jvmmib.EnumJvmMemoryGCCall;
import sun.management.snmp.jvmmib.EnumJvmMemoryGCVerboseLevel;
import sun.management.snmp.jvmmib.JvmMemGCTableMeta;
import sun.management.snmp.jvmmib.JvmMemManagerTableMeta;
import sun.management.snmp.jvmmib.JvmMemMgrPoolRelTableMeta;
import sun.management.snmp.jvmmib.JvmMemPoolTableMeta;
import sun.management.snmp.jvmmib.JvmMemoryMBean;

public class JvmMemoryMeta
extends SnmpMibGroup
implements Serializable,
SnmpStandardMetaServer {
    protected JvmMemoryMBean node;
    protected SnmpStandardObjectServer objectserver = null;
    protected JvmMemMgrPoolRelTableMeta tableJvmMemMgrPoolRelTable = null;
    protected JvmMemPoolTableMeta tableJvmMemPoolTable = null;
    protected JvmMemGCTableMeta tableJvmMemGCTable = null;
    protected JvmMemManagerTableMeta tableJvmMemManagerTable = null;

    public JvmMemoryMeta(SnmpMib snmpMib, SnmpStandardObjectServer snmpStandardObjectServer) {
        this.objectserver = snmpStandardObjectServer;
        try {
            this.registerObject(120L);
            this.registerObject(23L);
            this.registerObject(22L);
            this.registerObject(21L);
            this.registerObject(110L);
            this.registerObject(20L);
            this.registerObject(13L);
            this.registerObject(12L);
            this.registerObject(3L);
            this.registerObject(11L);
            this.registerObject(2L);
            this.registerObject(101L);
            this.registerObject(10L);
            this.registerObject(1L);
            this.registerObject(100L);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage());
        }
    }

    public SnmpValue get(long l2, Object object) throws SnmpStatusException {
        switch ((int)l2) {
            case 120: {
                throw new SnmpStatusException(224);
            }
            case 23: {
                return new SnmpCounter64(this.node.getJvmMemoryNonHeapMaxSize());
            }
            case 22: {
                return new SnmpCounter64(this.node.getJvmMemoryNonHeapCommitted());
            }
            case 21: {
                return new SnmpCounter64(this.node.getJvmMemoryNonHeapUsed());
            }
            case 110: {
                throw new SnmpStatusException(224);
            }
            case 20: {
                return new SnmpCounter64(this.node.getJvmMemoryNonHeapInitSize());
            }
            case 13: {
                return new SnmpCounter64(this.node.getJvmMemoryHeapMaxSize());
            }
            case 12: {
                return new SnmpCounter64(this.node.getJvmMemoryHeapCommitted());
            }
            case 3: {
                return new SnmpInt(this.node.getJvmMemoryGCCall());
            }
            case 11: {
                return new SnmpCounter64(this.node.getJvmMemoryHeapUsed());
            }
            case 2: {
                return new SnmpInt(this.node.getJvmMemoryGCVerboseLevel());
            }
            case 101: {
                throw new SnmpStatusException(224);
            }
            case 10: {
                return new SnmpCounter64(this.node.getJvmMemoryHeapInitSize());
            }
            case 1: {
                return new SnmpGauge(this.node.getJvmMemoryPendingFinalCount());
            }
            case 100: {
                throw new SnmpStatusException(224);
            }
        }
        throw new SnmpStatusException(225);
    }

    public SnmpValue set(SnmpValue snmpValue, long l2, Object object) throws SnmpStatusException {
        switch ((int)l2) {
            case 120: {
                throw new SnmpStatusException(17);
            }
            case 23: {
                throw new SnmpStatusException(17);
            }
            case 22: {
                throw new SnmpStatusException(17);
            }
            case 21: {
                throw new SnmpStatusException(17);
            }
            case 110: {
                throw new SnmpStatusException(17);
            }
            case 20: {
                throw new SnmpStatusException(17);
            }
            case 13: {
                throw new SnmpStatusException(17);
            }
            case 12: {
                throw new SnmpStatusException(17);
            }
            case 3: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.setJvmMemoryGCCall(new EnumJvmMemoryGCCall(((SnmpInt)snmpValue).toInteger()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(10);
                    }
                    return new SnmpInt(this.node.getJvmMemoryGCCall());
                }
                throw new SnmpStatusException(7);
            }
            case 11: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.setJvmMemoryGCVerboseLevel(new EnumJvmMemoryGCVerboseLevel(((SnmpInt)snmpValue).toInteger()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(10);
                    }
                    return new SnmpInt(this.node.getJvmMemoryGCVerboseLevel());
                }
                throw new SnmpStatusException(7);
            }
            case 101: {
                throw new SnmpStatusException(17);
            }
            case 10: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            case 100: {
                throw new SnmpStatusException(17);
            }
        }
        throw new SnmpStatusException(17);
    }

    public void check(SnmpValue snmpValue, long l2, Object object) throws SnmpStatusException {
        switch ((int)l2) {
            case 120: {
                throw new SnmpStatusException(17);
            }
            case 23: {
                throw new SnmpStatusException(17);
            }
            case 22: {
                throw new SnmpStatusException(17);
            }
            case 21: {
                throw new SnmpStatusException(17);
            }
            case 110: {
                throw new SnmpStatusException(17);
            }
            case 20: {
                throw new SnmpStatusException(17);
            }
            case 13: {
                throw new SnmpStatusException(17);
            }
            case 12: {
                throw new SnmpStatusException(17);
            }
            case 3: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.checkJvmMemoryGCCall(new EnumJvmMemoryGCCall(((SnmpInt)snmpValue).toInteger()));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(10);
                    }
                }
                throw new SnmpStatusException(7);
            }
            case 11: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.checkJvmMemoryGCVerboseLevel(new EnumJvmMemoryGCVerboseLevel(((SnmpInt)snmpValue).toInteger()));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(10);
                    }
                }
                throw new SnmpStatusException(7);
            }
            case 101: {
                throw new SnmpStatusException(17);
            }
            case 10: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            case 100: {
                throw new SnmpStatusException(17);
            }
            default: {
                throw new SnmpStatusException(17);
            }
        }
    }

    protected void setInstance(JvmMemoryMBean jvmMemoryMBean) {
        this.node = jvmMemoryMBean;
    }

    public void get(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        this.objectserver.get(this, snmpMibSubRequest, n2);
    }

    public void set(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        this.objectserver.set(this, snmpMibSubRequest, n2);
    }

    public void check(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        this.objectserver.check(this, snmpMibSubRequest, n2);
    }

    public boolean isVariable(long l2) {
        switch ((int)l2) {
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public boolean isReadable(long l2) {
        switch ((int)l2) {
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                return true;
            }
        }
        return false;
    }

    public boolean skipVariable(long l2, Object object, int n2) {
        switch ((int)l2) {
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                if (n2 != 0) break;
                return true;
            }
        }
        return super.skipVariable(l2, object, n2);
    }

    public String getAttributeName(long l2) throws SnmpStatusException {
        switch ((int)l2) {
            case 120: {
                throw new SnmpStatusException(224);
            }
            case 23: {
                return "JvmMemoryNonHeapMaxSize";
            }
            case 22: {
                return "JvmMemoryNonHeapCommitted";
            }
            case 21: {
                return "JvmMemoryNonHeapUsed";
            }
            case 110: {
                throw new SnmpStatusException(224);
            }
            case 20: {
                return "JvmMemoryNonHeapInitSize";
            }
            case 13: {
                return "JvmMemoryHeapMaxSize";
            }
            case 12: {
                return "JvmMemoryHeapCommitted";
            }
            case 3: {
                return "JvmMemoryGCCall";
            }
            case 11: {
                return "JvmMemoryHeapUsed";
            }
            case 2: {
                return "JvmMemoryGCVerboseLevel";
            }
            case 101: {
                throw new SnmpStatusException(224);
            }
            case 10: {
                return "JvmMemoryHeapInitSize";
            }
            case 1: {
                return "JvmMemoryPendingFinalCount";
            }
            case 100: {
                throw new SnmpStatusException(224);
            }
        }
        throw new SnmpStatusException(225);
    }

    public boolean isTable(long l2) {
        switch ((int)l2) {
            case 120: {
                return true;
            }
            case 110: {
                return true;
            }
            case 101: {
                return true;
            }
            case 100: {
                return true;
            }
        }
        return false;
    }

    public SnmpMibTable getTable(long l2) {
        switch ((int)l2) {
            case 120: {
                return this.tableJvmMemMgrPoolRelTable;
            }
            case 110: {
                return this.tableJvmMemPoolTable;
            }
            case 101: {
                return this.tableJvmMemGCTable;
            }
            case 100: {
                return this.tableJvmMemManagerTable;
            }
        }
        return null;
    }

    public void registerTableNodes(SnmpMib snmpMib, MBeanServer mBeanServer) {
        this.tableJvmMemMgrPoolRelTable = this.createJvmMemMgrPoolRelTableMetaNode("JvmMemMgrPoolRelTable", "JvmMemory", snmpMib, mBeanServer);
        if (this.tableJvmMemMgrPoolRelTable != null) {
            this.tableJvmMemMgrPoolRelTable.registerEntryNode(snmpMib, mBeanServer);
            snmpMib.registerTableMeta("JvmMemMgrPoolRelTable", this.tableJvmMemMgrPoolRelTable);
        }
        this.tableJvmMemPoolTable = this.createJvmMemPoolTableMetaNode("JvmMemPoolTable", "JvmMemory", snmpMib, mBeanServer);
        if (this.tableJvmMemPoolTable != null) {
            this.tableJvmMemPoolTable.registerEntryNode(snmpMib, mBeanServer);
            snmpMib.registerTableMeta("JvmMemPoolTable", this.tableJvmMemPoolTable);
        }
        this.tableJvmMemGCTable = this.createJvmMemGCTableMetaNode("JvmMemGCTable", "JvmMemory", snmpMib, mBeanServer);
        if (this.tableJvmMemGCTable != null) {
            this.tableJvmMemGCTable.registerEntryNode(snmpMib, mBeanServer);
            snmpMib.registerTableMeta("JvmMemGCTable", this.tableJvmMemGCTable);
        }
        this.tableJvmMemManagerTable = this.createJvmMemManagerTableMetaNode("JvmMemManagerTable", "JvmMemory", snmpMib, mBeanServer);
        if (this.tableJvmMemManagerTable != null) {
            this.tableJvmMemManagerTable.registerEntryNode(snmpMib, mBeanServer);
            snmpMib.registerTableMeta("JvmMemManagerTable", this.tableJvmMemManagerTable);
        }
    }

    protected JvmMemMgrPoolRelTableMeta createJvmMemMgrPoolRelTableMetaNode(String string, String string2, SnmpMib snmpMib, MBeanServer mBeanServer) {
        return new JvmMemMgrPoolRelTableMeta(snmpMib, this.objectserver);
    }

    protected JvmMemPoolTableMeta createJvmMemPoolTableMetaNode(String string, String string2, SnmpMib snmpMib, MBeanServer mBeanServer) {
        return new JvmMemPoolTableMeta(snmpMib, this.objectserver);
    }

    protected JvmMemGCTableMeta createJvmMemGCTableMetaNode(String string, String string2, SnmpMib snmpMib, MBeanServer mBeanServer) {
        return new JvmMemGCTableMeta(snmpMib, this.objectserver);
    }

    protected JvmMemManagerTableMeta createJvmMemManagerTableMetaNode(String string, String string2, SnmpMib snmpMib, MBeanServer mBeanServer) {
        return new JvmMemManagerTableMeta(snmpMib, this.objectserver);
    }
}

