/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.CharToGlyphMapper;
import sun.font.CompositeFont;

public final class CompositeGlyphMapper
extends CharToGlyphMapper {
    public static final int SLOTMASK = -16777216;
    public static final int GLYPHMASK = 0xFFFFFF;
    public static final int NBLOCKS = 216;
    public static final int BLOCKSZ = 256;
    public static final int MAXUNICODE = 55296;
    CompositeFont font;
    CharToGlyphMapper[] slotMappers;
    int[][] glyphMaps;
    private boolean hasExcludes;

    public CompositeGlyphMapper(CompositeFont compositeFont) {
        this.font = compositeFont;
        this.initMapper();
        this.hasExcludes = compositeFont.exclusionRanges != null && compositeFont.maxIndices != null;
    }

    public final int compositeGlyphCode(int n2, int n3) {
        return n2 << 24 | n3 & 0xFFFFFF;
    }

    private final void initMapper() {
        if (this.missingGlyph == -1) {
            if (this.glyphMaps == null) {
                this.glyphMaps = new int[216][];
            }
            this.slotMappers = new CharToGlyphMapper[this.font.numSlots];
            this.missingGlyph = this.font.getSlotFont(0).getMissingGlyphCode();
            this.missingGlyph = this.compositeGlyphCode(0, this.missingGlyph);
        }
    }

    private int getCachedGlyphCode(int n2) {
        if (n2 >= 55296) {
            return -1;
        }
        int[] nArray = this.glyphMaps[n2 >> 8];
        if (nArray == null) {
            return -1;
        }
        return nArray[n2 & 0xFF];
    }

    private void setCachedGlyphCode(int n2, int n3) {
        if (n2 >= 55296) {
            return;
        }
        int n4 = n2 >> 8;
        if (this.glyphMaps[n4] == null) {
            this.glyphMaps[n4] = new int[256];
            for (int i2 = 0; i2 < 256; ++i2) {
                this.glyphMaps[n4][i2] = -1;
            }
        }
        this.glyphMaps[n4][n2 & 0xFF] = n3;
    }

    private final CharToGlyphMapper getSlotMapper(int n2) {
        CharToGlyphMapper charToGlyphMapper = this.slotMappers[n2];
        if (charToGlyphMapper == null) {
            this.slotMappers[n2] = charToGlyphMapper = this.font.getSlotFont(n2).getMapper();
        }
        return charToGlyphMapper;
    }

    private final int convertToGlyph(int n2) {
        for (int i2 = 0; i2 < this.font.numSlots; ++i2) {
            CharToGlyphMapper charToGlyphMapper;
            int n3;
            if (this.hasExcludes && this.font.isExcludedChar(i2, n2) || (n3 = (charToGlyphMapper = this.getSlotMapper(i2)).charToGlyph(n2)) == charToGlyphMapper.getMissingGlyphCode()) continue;
            n3 = this.compositeGlyphCode(i2, n3);
            this.setCachedGlyphCode(n2, n3);
            return n3;
        }
        return this.missingGlyph;
    }

    public int getNumGlyphs() {
        int n2 = 0;
        for (int i2 = 0; i2 < 1; ++i2) {
            CharToGlyphMapper charToGlyphMapper = this.slotMappers[i2];
            if (charToGlyphMapper == null) {
                this.slotMappers[i2] = charToGlyphMapper = this.font.getSlotFont(i2).getMapper();
            }
            n2 += charToGlyphMapper.getNumGlyphs();
        }
        return n2;
    }

    public int charToGlyph(int n2) {
        int n3 = this.getCachedGlyphCode(n2);
        if (n3 == -1) {
            n3 = this.convertToGlyph(n2);
        }
        return n3;
    }

    public int charToGlyph(int n2, int n3) {
        CharToGlyphMapper charToGlyphMapper;
        int n4;
        if (n3 >= 0 && (n4 = (charToGlyphMapper = this.getSlotMapper(n3)).charToGlyph(n2)) != charToGlyphMapper.getMissingGlyphCode()) {
            return this.compositeGlyphCode(n3, n4);
        }
        return this.charToGlyph(n2);
    }

    public int charToGlyph(char c2) {
        int n2 = this.getCachedGlyphCode(c2);
        if (n2 == -1) {
            n2 = this.convertToGlyph(c2);
        }
        return n2;
    }

    public boolean charsToGlyphsNS(int n2, char[] cArray, int[] nArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4 = cArray[i2];
            if (n4 >= 55296 && n4 <= 56319 && i2 < n2 - 1 && (n3 = cArray[i2 + 1]) >= 56320 && n3 <= 57343) {
                n4 = (n4 - 55296) * 1024 + n3 - 56320 + 65536;
                nArray[i2 + 1] = 65535;
            }
            if ((n3 = (nArray[i2] = this.getCachedGlyphCode(n4))) == -1) {
                nArray[i2] = this.convertToGlyph(n4);
            }
            if (n4 < 1424) continue;
            if (n4 <= 1535) {
                return true;
            }
            if (n4 >= 1536 && n4 <= 1791) {
                return true;
            }
            if (n4 >= 2304 && n4 <= 3455) {
                return true;
            }
            if (n4 >= 3584 && n4 <= 3711) {
                return true;
            }
            if (n4 >= 8204 && n4 <= 8205) {
                return true;
            }
            if (n4 >= 8234 && n4 <= 8238) {
                return true;
            }
            if (n4 >= 8298 && n4 <= 8303) {
                return true;
            }
            if (n4 < 65536) continue;
            ++i2;
        }
        return false;
    }

    public void charsToGlyphs(int n2, char[] cArray, int[] nArray) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            int n4 = cArray[i2];
            if (n4 >= 55296 && n4 <= 56319 && i2 < n2 - 1 && (n3 = cArray[i2 + 1]) >= 56320 && n3 <= 57343) {
                nArray[i2] = this.getCachedGlyphCode(n4 = (n4 - 55296) * 1024 + n3 - 56320 + 65536);
                int n5 = nArray[i2];
                if (n5 == -1) {
                    nArray[i2] = this.convertToGlyph(n4);
                }
                nArray[++i2] = 65535;
                continue;
            }
            nArray[i2] = this.getCachedGlyphCode(n4);
            n3 = nArray[i2];
            if (n3 != -1) continue;
            nArray[i2] = this.convertToGlyph(n4);
        }
    }

    public void charsToGlyphs(int n2, int[] nArray, int[] nArray2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            nArray2[i2] = this.getCachedGlyphCode(n3);
            if (nArray2[i2] != -1) continue;
            nArray2[i2] = this.convertToGlyph(n3);
        }
    }
}

