/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.ToolkitThreadBlockedHandler;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.ToolkitImage;
import sun.awt.windows.HTMLDecodingInputStream;
import sun.awt.windows.HTMLSupport;
import sun.awt.windows.WToolkitThreadBlockedHandler;

public class WDataTransferer
extends DataTransferer {
    private static final String[] predefinedClipboardNames = new String[]{"", "TEXT", "BITMAP", "METAFILEPICT", "SYLK", "DIF", "TIFF", "OEM TEXT", "DIB", "PALETTE", "PENDATA", "RIFF", "WAVE", "UNICODE TEXT", "ENHMETAFILE", "HDROP", "LOCALE"};
    private static final Map predefinedClipboardNameMap;
    public static final int CF_TEXT = 1;
    public static final int CF_METAFILEPICT = 3;
    public static final int CF_DIB = 8;
    public static final int CF_ENHMETAFILE = 14;
    public static final int CF_HDROP = 15;
    public static final int CF_LOCALE = 16;
    public static final long CF_HTML;
    public static final long CFSTR_INETURL;
    public static final long CF_PNG;
    public static final long CF_JFIF;
    private static final Long L_CF_LOCALE;
    private static final DirectColorModel directColorModel;
    private static final int[] bandmasks;
    private static WDataTransferer transferer;
    private final ToolkitThreadBlockedHandler handler = new WToolkitThreadBlockedHandler();

    private WDataTransferer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WDataTransferer getInstanceImpl() {
        if (transferer != null) return transferer;
        Class<WDataTransferer> clazz = WDataTransferer.class;
        synchronized (WDataTransferer.class) {
            if (transferer != null) return transferer;
            transferer = new WDataTransferer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return transferer;
        }
    }

    public SortedMap getFormatsForFlavors(DataFlavor[] dataFlavorArray, FlavorTable flavorTable) {
        SortedMap sortedMap = super.getFormatsForFlavors(dataFlavorArray, flavorTable);
        sortedMap.remove(L_CF_LOCALE);
        return sortedMap;
    }

    public String getDefaultUnicodeEncoding() {
        return "utf-16le";
    }

    public byte[] translateTransferable(Transferable transferable, DataFlavor dataFlavor, long l2) throws IOException {
        byte[] byArray = super.translateTransferable(transferable, dataFlavor, l2);
        if (l2 == CF_HTML) {
            byArray = HTMLSupport.convertToHTMLFormat(byArray);
        }
        return byArray;
    }

    protected Object translateBytesOrStream(InputStream inputStream, byte[] byArray, DataFlavor dataFlavor, long l2, Transferable transferable) throws IOException {
        if (l2 == CF_HTML && dataFlavor.isFlavorTextType()) {
            if (inputStream == null) {
                inputStream = new ByteArrayInputStream(byArray);
                byArray = null;
            }
            inputStream = new HTMLDecodingInputStream(inputStream);
        }
        if (l2 == CFSTR_INETURL && URL.class.equals(dataFlavor.getRepresentationClass())) {
            if (byArray == null) {
                byArray = WDataTransferer.inputStreamToByteArray(inputStream);
                inputStream = null;
            }
            String string = WDataTransferer.getDefaultTextCharset();
            if (transferable != null && transferable.isDataFlavorSupported(javaTextEncodingFlavor)) {
                try {
                    string = new String((byte[])transferable.getTransferData(javaTextEncodingFlavor), "UTF-8");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
            }
            return new URL(new String(byArray, string));
        }
        return super.translateBytesOrStream(inputStream, byArray, dataFlavor, l2, transferable);
    }

    public boolean isLocaleDependentTextFormat(long l2) {
        return l2 == 1L || l2 == CFSTR_INETURL;
    }

    public boolean isFileFormat(long l2) {
        return l2 == 15L;
    }

    protected Long getFormatForNativeAsLong(String string) {
        Long l2 = (Long)predefinedClipboardNameMap.get(string);
        if (l2 == null) {
            l2 = new Long(WDataTransferer.registerClipboardFormat(string));
        }
        return l2;
    }

    protected String getNativeForFormat(long l2) {
        return l2 < (long)predefinedClipboardNames.length ? predefinedClipboardNames[(int)l2] : WDataTransferer.getClipboardFormatName(l2);
    }

    public ToolkitThreadBlockedHandler getToolkitThreadBlockedHandler() {
        return this.handler;
    }

    private static native long registerClipboardFormat(String var0);

    private static native String getClipboardFormatName(long var0);

    public boolean isImageFormat(long l2) {
        return l2 == 8L || l2 == 14L || l2 == 3L || l2 == CF_PNG || l2 == CF_JFIF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] imageToPlatformBytes(Image image, long l2) throws IOException {
        String string = null;
        if (l2 == CF_PNG) {
            string = "image/png";
        } else if (l2 == CF_JFIF) {
            string = "image/jpeg";
        }
        if (string != null) {
            return this.imageToStandardBytes(image, string);
        }
        int n2 = 0;
        int n3 = 0;
        if (image instanceof ToolkitImage) {
            ImageRepresentation imageRepresentation = ((ToolkitImage)image).getImageRep();
            imageRepresentation.reconstruct(32);
            n2 = imageRepresentation.getWidth();
            n3 = imageRepresentation.getHeight();
        } else {
            n2 = image.getWidth(null);
            n3 = image.getHeight(null);
        }
        int n4 = n2 * 3 % 4;
        int n5 = n4 > 0 ? 4 - n4 : 0;
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        int[] nArray = new int[]{8, 8, 8};
        int[] nArray2 = new int[]{2, 1, 0};
        ComponentColorModel componentColorModel = new ComponentColorModel(colorSpace, nArray, false, false, 1, 0);
        WritableRaster writableRaster = Raster.createInterleavedRaster(0, n2, n3, n2 * 3 + n5, 3, nArray2, null);
        BufferedImage bufferedImage = new BufferedImage(componentColorModel, writableRaster, false, null);
        AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        try {
            graphics2D.drawImage(image, affineTransform, null);
        }
        finally {
            graphics2D.dispose();
        }
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        return this.imageDataToPlatformImageBytes(byArray, n2, n3, l2);
    }

    private native byte[] imageDataToPlatformImageBytes(byte[] var1, int var2, int var3, long var4);

    protected Image platformImageBytesOrStreamToImage(InputStream inputStream, byte[] byArray, long l2) throws IOException {
        int[] nArray;
        String string = null;
        if (l2 == CF_PNG) {
            string = "image/png";
        } else if (l2 == CF_JFIF) {
            string = "image/jpeg";
        }
        if (string != null) {
            return this.standardImageBytesOrStreamToImage(inputStream, byArray, string);
        }
        if (byArray == null) {
            byArray = WDataTransferer.inputStreamToByteArray(inputStream);
        }
        if ((nArray = this.platformImageBytesToImageData(byArray, l2)) == null) {
            throw new IOException("data translation failed");
        }
        int n2 = nArray.length - 2;
        int n3 = nArray[n2];
        int n4 = nArray[n2 + 1];
        DataBufferInt dataBufferInt = new DataBufferInt(nArray, n2);
        WritableRaster writableRaster = Raster.createPackedRaster(dataBufferInt, n3, n4, n3, bandmasks, null);
        return new BufferedImage(directColorModel, writableRaster, false, null);
    }

    private native int[] platformImageBytesToImageData(byte[] var1, long var2) throws IOException;

    protected native String[] dragQueryFile(byte[] var1);

    static {
        HashMap<String, Long> hashMap = new HashMap<String, Long>(16, 1.0f);
        for (int i2 = 1; i2 < predefinedClipboardNames.length; ++i2) {
            hashMap.put(predefinedClipboardNames[i2], new Long(i2));
        }
        predefinedClipboardNameMap = Collections.synchronizedMap(hashMap);
        CF_HTML = WDataTransferer.registerClipboardFormat("HTML Format");
        CFSTR_INETURL = WDataTransferer.registerClipboardFormat("UniformResourceLocator");
        CF_PNG = WDataTransferer.registerClipboardFormat("PNG");
        CF_JFIF = WDataTransferer.registerClipboardFormat("JFIF");
        L_CF_LOCALE = (Long)predefinedClipboardNameMap.get(predefinedClipboardNames[16]);
        directColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255);
        bandmasks = new int[]{directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask()};
    }
}

