/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.metal.CachedPainter;
import javax.swing.plaf.metal.MetalLookAndFeel;

class MetalUtils {
    MetalUtils() {
    }

    static void drawFlush3DBorder(Graphics graphics, Rectangle rectangle) {
        MetalUtils.drawFlush3DBorder(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static void drawFlush3DBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
        graphics.drawRect(0, 0, n4 - 2, n5 - 2);
        graphics.setColor(MetalLookAndFeel.getControlHighlight());
        graphics.drawRect(1, 1, n4 - 2, n5 - 2);
        graphics.setColor(MetalLookAndFeel.getControl());
        graphics.drawLine(0, n5 - 1, 1, n5 - 2);
        graphics.drawLine(n4 - 1, 0, n4 - 2, 1);
        graphics.translate(-n2, -n3);
    }

    static void drawPressed3DBorder(Graphics graphics, Rectangle rectangle) {
        MetalUtils.drawPressed3DBorder(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static void drawDisabledBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        graphics.setColor(MetalLookAndFeel.getControlShadow());
        graphics.drawRect(0, 0, n4 - 1, n5 - 1);
        graphics.translate(-n2, -n3);
    }

    static void drawPressed3DBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        MetalUtils.drawFlush3DBorder(graphics, 0, 0, n4, n5);
        graphics.setColor(MetalLookAndFeel.getControlShadow());
        graphics.drawLine(1, 1, 1, n5 - 2);
        graphics.drawLine(1, 1, n4 - 2, 1);
        graphics.translate(-n2, -n3);
    }

    static void drawDark3DBorder(Graphics graphics, Rectangle rectangle) {
        MetalUtils.drawDark3DBorder(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    static void drawDark3DBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        graphics.translate(n2, n3);
        MetalUtils.drawFlush3DBorder(graphics, 0, 0, n4, n5);
        graphics.setColor(MetalLookAndFeel.getControl());
        graphics.drawLine(1, 1, 1, n5 - 2);
        graphics.drawLine(1, 1, n4 - 2, 1);
        graphics.setColor(MetalLookAndFeel.getControlShadow());
        graphics.drawLine(1, n5 - 2, 1, n5 - 2);
        graphics.drawLine(n4 - 2, 1, n4 - 2, 1);
        graphics.translate(-n2, -n3);
    }

    static void drawButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2) {
        if (bl2) {
            MetalUtils.drawActiveButtonBorder(graphics, n2, n3, n4, n5);
        } else {
            MetalUtils.drawFlush3DBorder(graphics, n2, n3, n4, n5);
        }
    }

    static void drawActiveButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        MetalUtils.drawFlush3DBorder(graphics, n2, n3, n4, n5);
        graphics.setColor(MetalLookAndFeel.getPrimaryControl());
        graphics.drawLine(n2 + 1, n3 + 1, n2 + 1, n5 - 3);
        graphics.drawLine(n2 + 1, n3 + 1, n4 - 3, n2 + 1);
        graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
        graphics.drawLine(n2 + 2, n5 - 2, n4 - 2, n5 - 2);
        graphics.drawLine(n4 - 2, n3 + 2, n4 - 2, n5 - 2);
    }

    static void drawDefaultButtonBorder(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2) {
        MetalUtils.drawButtonBorder(graphics, n2 + 1, n3 + 1, n4 - 1, n5 - 1, bl2);
        graphics.translate(n2, n3);
        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
        graphics.drawRect(0, 0, n4 - 3, n5 - 3);
        graphics.drawLine(n4 - 2, 0, n4 - 2, 0);
        graphics.drawLine(0, n5 - 2, 0, n5 - 2);
        graphics.translate(-n2, -n3);
    }

    static void drawDefaultButtonPressedBorder(Graphics graphics, int n2, int n3, int n4, int n5) {
        MetalUtils.drawPressed3DBorder(graphics, n2 + 1, n3 + 1, n4 - 1, n5 - 1);
        graphics.translate(n2, n3);
        graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
        graphics.drawRect(0, 0, n4 - 3, n5 - 3);
        graphics.drawLine(n4 - 2, 0, n4 - 2, 0);
        graphics.drawLine(0, n5 - 2, 0, n5 - 2);
        graphics.setColor(MetalLookAndFeel.getControl());
        graphics.drawLine(n4 - 1, 0, n4 - 1, 0);
        graphics.drawLine(0, n5 - 1, 0, n5 - 1);
        graphics.translate(-n2, -n3);
    }

    static boolean isLeftToRight(Component component) {
        return component.getComponentOrientation().isLeftToRight();
    }

    static int getInt(Object object, int n2) {
        Object object2 = UIManager.get(object);
        if (object2 instanceof Integer) {
            return (Integer)object2;
        }
        if (object2 instanceof String) {
            try {
                return Integer.parseInt((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    static boolean drawGradient(Component component, Graphics graphics, String string, int n2, int n3, int n4, int n5, boolean bl2) {
        List list = (List)UIManager.get(string);
        if (list == null || !(graphics instanceof Graphics2D)) {
            return false;
        }
        if (n4 <= 0 || n5 <= 0) {
            return true;
        }
        GradientPainter.INSTANCE.paint(component, (Graphics2D)graphics, list, n2, n3, n4, n5, bl2);
        return true;
    }

    static boolean isToolBarButton(JComponent jComponent) {
        return jComponent.getParent() instanceof JToolBar;
    }

    static Icon getOceanToolBarIcon(Image image) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new OceanToolBarImageFilter());
        return new IconUIResource(new ImageIcon(Toolkit.getDefaultToolkit().createImage(filteredImageSource)));
    }

    static Icon getOceanDisabledButtonIcon(Image image) {
        Object[] objectArray = (Object[])UIManager.get("Button.disabledGrayRange");
        int n2 = 180;
        int n3 = 215;
        if (objectArray != null) {
            n2 = (Integer)objectArray[0];
            n3 = (Integer)objectArray[1];
        }
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), new OceanDisabledButtonImageFilter(n2, n3));
        return new IconUIResource(new ImageIcon(Toolkit.getDefaultToolkit().createImage(filteredImageSource)));
    }

    private static class GradientPainter
    extends CachedPainter {
        public static final GradientPainter INSTANCE = new GradientPainter(8);
        private static final int IMAGE_SIZE = 64;
        private int w;
        private int h;

        GradientPainter(int n2) {
            super(n2);
        }

        public synchronized void paint(Component component, Graphics2D graphics2D, List list, int n2, int n3, int n4, int n5, boolean bl2) {
            int n6;
            int n7;
            if (bl2) {
                n7 = 64;
                n6 = n5;
            } else {
                n7 = n4;
                n6 = 64;
            }
            this.w = n4;
            this.h = n5;
            this.paint(component, (Graphics)graphics2D, n2, n3, n7, n6, list, bl2);
        }

        protected void paintToImage(Component component, Graphics graphics, int n2, int n3, Object[] objectArray) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            List list = (List)objectArray[0];
            boolean bl2 = (Boolean)objectArray[1];
            if (bl2) {
                this.drawVerticalGradient(graphics2D, ((Number)list.get(0)).floatValue(), ((Number)list.get(1)).floatValue(), (Color)list.get(2), (Color)list.get(3), (Color)list.get(4), n2, n3);
            } else {
                this.drawHorizontalGradient(graphics2D, ((Number)list.get(0)).floatValue(), ((Number)list.get(1)).floatValue(), (Color)list.get(2), (Color)list.get(3), (Color)list.get(4), n2, n3);
            }
        }

        protected void paintImage(Component component, Graphics graphics, int n2, int n3, int n4, int n5, Image image, Object[] objectArray) {
            boolean bl2 = (Boolean)objectArray[1];
            graphics.translate(n2, n3);
            if (bl2) {
                for (int i2 = 0; i2 < this.w; i2 += 64) {
                    int n6 = Math.min(64, this.w - i2);
                    graphics.drawImage(image, i2, 0, i2 + n6, this.h, 0, 0, n6, this.h, null);
                }
            } else {
                for (int i3 = 0; i3 < this.h; i3 += 64) {
                    int n7 = Math.min(64, this.h - i3);
                    graphics.drawImage(image, 0, i3, this.w, i3 + n7, 0, 0, this.w, n7, null);
                }
            }
            graphics.translate(-n2, -n3);
        }

        private void drawVerticalGradient(Graphics2D graphics2D, float f2, float f3, Color color, Color color2, Color color3, int n2, int n3) {
            int n4 = (int)(f2 * (float)n3);
            int n5 = (int)(f3 * (float)n3);
            if (n4 > 0) {
                graphics2D.setPaint(this.getGradient(0.0f, 0.0f, color, 0.0f, n4, color2));
                graphics2D.fillRect(0, 0, n2, n4);
            }
            if (n5 > 0) {
                graphics2D.setColor(color2);
                graphics2D.fillRect(0, n4, n2, n5);
            }
            if (n4 > 0) {
                graphics2D.setPaint(this.getGradient(0.0f, (float)n4 + (float)n5, color2, 0.0f, (float)n4 * 2.0f + (float)n5, color));
                graphics2D.fillRect(0, n4 + n5, n2, n4);
            }
            if (n3 - n4 * 2 - n5 > 0) {
                graphics2D.setPaint(this.getGradient(0.0f, (float)n4 * 2.0f + (float)n5, color, 0.0f, n3, color3));
                graphics2D.fillRect(0, n4 * 2 + n5, n2, n3 - n4 * 2 - n5);
            }
        }

        private void drawHorizontalGradient(Graphics2D graphics2D, float f2, float f3, Color color, Color color2, Color color3, int n2, int n3) {
            int n4 = (int)(f2 * (float)n2);
            int n5 = (int)(f3 * (float)n2);
            if (n4 > 0) {
                graphics2D.setPaint(this.getGradient(0.0f, 0.0f, color, n4, 0.0f, color2));
                graphics2D.fillRect(0, 0, n4, n3);
            }
            if (n5 > 0) {
                graphics2D.setColor(color2);
                graphics2D.fillRect(n4, 0, n5, n3);
            }
            if (n4 > 0) {
                graphics2D.setPaint(this.getGradient((float)n4 + (float)n5, 0.0f, color2, (float)n4 * 2.0f + (float)n5, 0.0f, color));
                graphics2D.fillRect(n4 + n5, 0, n4, n3);
            }
            if (n2 - n4 * 2 - n5 > 0) {
                graphics2D.setPaint(this.getGradient((float)n4 * 2.0f + (float)n5, 0.0f, color, n2, 0.0f, color3));
                graphics2D.fillRect(n4 * 2 + n5, 0, n2 - n4 * 2 - n5, n3);
            }
        }

        private GradientPaint getGradient(float f2, float f3, Color color, float f4, float f5, Color color2) {
            return new GradientPaint(f2, f3, color, f4, f5, color2, true);
        }
    }

    private static class OceanDisabledButtonImageFilter
    extends RGBImageFilter {
        private float min;
        private float factor;

        OceanDisabledButtonImageFilter(int n2, int n3) {
            this.canFilterIndexColorModel = true;
            this.min = n2;
            this.factor = (float)(n3 - n2) / 255.0f;
        }

        public int filterRGB(int n2, int n3, int n4) {
            int n5 = Math.min(255, (int)((0.2125f * (float)(n4 >> 16 & 0xFF) + 0.7154f * (float)(n4 >> 8 & 0xFF) + 0.0721f * (float)(n4 & 0xFF) + 0.5f) * this.factor + this.min));
            return n4 & 0xFF000000 | n5 << 16 | n5 << 8 | n5 << 0;
        }
    }

    private static class OceanToolBarImageFilter
    extends RGBImageFilter {
        OceanToolBarImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n2, int n3, int n4) {
            int n5 = n4 >> 16 & 0xFF;
            int n6 = n4 >> 8 & 0xFF;
            int n7 = n4 & 0xFF;
            int n8 = Math.max(Math.max(n5, n6), n7);
            return n4 & 0xFF000000 | n8 << 16 | n8 << 8 | n8 << 0;
        }
    }
}

