/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.Action;
import javax.swing.ArrayTable;
import javax.swing.Icon;
import javax.swing.event.SwingPropertyChangeSupport;

public abstract class AbstractAction
implements Action,
Cloneable,
Serializable {
    protected boolean enabled = true;
    private transient ArrayTable arrayTable;
    protected SwingPropertyChangeSupport changeSupport;

    public AbstractAction() {
    }

    public AbstractAction(String string) {
        this.putValue("Name", string);
    }

    public AbstractAction(String string, Icon icon) {
        this(string);
        this.putValue("SmallIcon", icon);
    }

    public Object getValue(String string) {
        if (this.arrayTable == null) {
            return null;
        }
        return this.arrayTable.get(string);
    }

    public void putValue(String string, Object object) {
        Object object2 = null;
        if (this.arrayTable == null) {
            this.arrayTable = new ArrayTable();
        }
        if (this.arrayTable.containsKey(string)) {
            object2 = this.arrayTable.get(string);
        }
        if (object == null) {
            this.arrayTable.remove(string);
        } else {
            this.arrayTable.put(string, object);
        }
        this.firePropertyChange(string, object2, object);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl2) {
        boolean bl3 = this.enabled;
        if (bl3 != bl2) {
            this.enabled = bl2;
            this.firePropertyChange("enabled", bl3, bl2);
        }
    }

    public Object[] getKeys() {
        if (this.arrayTable == null) {
            return null;
        }
        Object[] objectArray = new Object[this.arrayTable.size()];
        this.arrayTable.getKeys(objectArray);
        return objectArray;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (this.changeSupport == null || object != null && object2 != null && object.equals(object2)) {
            return;
        }
        this.changeSupport.firePropertyChange(string, object, object2);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object clone() throws CloneNotSupportedException {
        AbstractAction abstractAction = (AbstractAction)super.clone();
        AbstractAction abstractAction2 = this;
        synchronized (abstractAction2) {
            if (this.arrayTable != null) {
                abstractAction.arrayTable = (ArrayTable)this.arrayTable.clone();
            }
        }
        return abstractAction;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        ArrayTable.writeArrayTable(objectOutputStream, this.arrayTable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        for (int i2 = objectInputStream.readInt() - 1; i2 >= 0; --i2) {
            this.putValue((String)objectInputStream.readObject(), objectInputStream.readObject());
        }
    }
}

