/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteArrayList<E>
implements List<E>,
RandomAccess,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8673264195747942595L;
    private volatile transient E[] array;

    private E[] array() {
        return this.array;
    }

    public CopyOnWriteArrayList() {
        this.array = new Object[0];
    }

    public CopyOnWriteArrayList(Collection<? extends E> collection) {
        this.array = new Object[collection.size()];
        Iterator<E> iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            this.array[n2++] = iterator.next();
        }
    }

    public CopyOnWriteArrayList(E[] EArray) {
        this.copyIn(EArray, 0, EArray.length);
    }

    private synchronized void copyIn(E[] EArray, int n2, int n3) {
        this.array = new Object[n3];
        System.arraycopy(EArray, n2, this.array, 0, n3);
    }

    @Override
    public int size() {
        return this.array().length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        int n2;
        Object[] objectArray = this.array();
        return CopyOnWriteArrayList.indexOf(object, objectArray, n2 = objectArray.length) >= 0;
    }

    @Override
    public int indexOf(Object object) {
        Object[] objectArray = this.array();
        int n2 = objectArray.length;
        return CopyOnWriteArrayList.indexOf(object, objectArray, n2);
    }

    private static int indexOf(Object object, Object[] objectArray, int n2) {
        if (object == null) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (objectArray[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!object.equals(objectArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public int indexOf(E e2, int n2) {
        E[] EArray = this.array();
        int n3 = EArray.length;
        if (e2 == null) {
            for (int i2 = n2; i2 < n3; ++i2) {
                if (EArray[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 < n3; ++i3) {
                if (!e2.equals(EArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        Object[] objectArray = this.array();
        int n2 = objectArray.length;
        return CopyOnWriteArrayList.lastIndexOf(object, objectArray, n2);
    }

    private static int lastIndexOf(Object object, Object[] objectArray, int n2) {
        if (object == null) {
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                if (objectArray[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = n2 - 1; i3 >= 0; --i3) {
                if (!object.equals(objectArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public int lastIndexOf(E e2, int n2) {
        E[] EArray = this.array();
        if (e2 == null) {
            for (int i2 = n2; i2 >= 0; --i2) {
                if (EArray[i2] != null) continue;
                return i2;
            }
        } else {
            for (int i3 = n2; i3 >= 0; --i3) {
                if (!e2.equals(EArray[i3])) continue;
                return i3;
            }
        }
        return -1;
    }

    public Object clone() {
        try {
            E[] EArray = this.array();
            CopyOnWriteArrayList copyOnWriteArrayList = (CopyOnWriteArrayList)super.clone();
            copyOnWriteArrayList.array = new Object[EArray.length];
            System.arraycopy(EArray, 0, copyOnWriteArrayList.array, 0, EArray.length);
            return copyOnWriteArrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Object[] toArray() {
        E[] EArray = this.array();
        Object[] objectArray = new Object[EArray.length];
        System.arraycopy(EArray, 0, objectArray, 0, EArray.length);
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        E[] EArray = this.array();
        if (objectArray.length < EArray.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), EArray.length);
        }
        System.arraycopy(EArray, 0, objectArray, 0, EArray.length);
        if (objectArray.length > EArray.length) {
            objectArray[EArray.length] = null;
        }
        return objectArray;
    }

    @Override
    public E get(int n2) {
        E[] EArray = this.array();
        this.rangeCheck(n2, EArray.length);
        return EArray[n2];
    }

    @Override
    public synchronized E set(int n2, E e2) {
        boolean bl2;
        int n3 = this.array.length;
        this.rangeCheck(n2, n3);
        E e3 = this.array[n2];
        boolean bl3 = bl2 = e3 == e2 || e2 != null && e2.equals(e3);
        if (!bl2) {
            Object[] objectArray = new Object[n3];
            System.arraycopy(this.array, 0, objectArray, 0, n3);
            objectArray[n2] = e2;
            this.array = objectArray;
        }
        return e3;
    }

    @Override
    public synchronized boolean add(E e2) {
        int n2 = this.array.length;
        Object[] objectArray = new Object[n2 + 1];
        System.arraycopy(this.array, 0, objectArray, 0, n2);
        objectArray[n2] = e2;
        this.array = objectArray;
        return true;
    }

    @Override
    public synchronized void add(int n2, E e2) {
        int n3 = this.array.length;
        if (n2 > n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + n3);
        }
        Object[] objectArray = new Object[n3 + 1];
        System.arraycopy(this.array, 0, objectArray, 0, n2);
        objectArray[n2] = e2;
        System.arraycopy(this.array, n2, objectArray, n2 + 1, n3 - n2);
        this.array = objectArray;
    }

    @Override
    public synchronized E remove(int n2) {
        int n3 = this.array.length;
        this.rangeCheck(n2, n3);
        E e2 = this.array[n2];
        Object[] objectArray = new Object[n3 - 1];
        System.arraycopy(this.array, 0, objectArray, 0, n2);
        int n4 = n3 - n2 - 1;
        if (n4 > 0) {
            System.arraycopy(this.array, n2 + 1, objectArray, n2, n4);
        }
        this.array = objectArray;
        return e2;
    }

    @Override
    public synchronized boolean remove(Object object) {
        int n2 = this.array.length;
        if (n2 == 0) {
            return false;
        }
        int n3 = n2 - 1;
        Object[] objectArray = new Object[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            if (object == this.array[i2] || object != null && object.equals(this.array[i2])) {
                for (int i3 = i2 + 1; i3 < n2; ++i3) {
                    objectArray[i3 - 1] = this.array[i3];
                }
                this.array = objectArray;
                return true;
            }
            objectArray[i2] = this.array[i2];
        }
        if (object == this.array[n3] || object != null && object.equals(this.array[n3])) {
            this.array = objectArray;
            return true;
        }
        return false;
    }

    private synchronized void removeRange(int n2, int n3) {
        int n4 = this.array.length;
        if (n2 < 0 || n2 >= n4 || n3 > n4 || n3 < n2) {
            throw new IndexOutOfBoundsException();
        }
        int n5 = n4 - n3;
        int n6 = n4 - (n3 - n2);
        Object[] objectArray = new Object[n6];
        System.arraycopy(this.array, 0, objectArray, 0, n2);
        System.arraycopy(this.array, n3, objectArray, n2, n5);
        this.array = objectArray;
    }

    public synchronized boolean addIfAbsent(E e2) {
        int n2 = this.array.length;
        Object[] objectArray = new Object[n2 + 1];
        for (int i2 = 0; i2 < n2; ++i2) {
            if (e2 == this.array[i2] || e2 != null && e2.equals(this.array[i2])) {
                return false;
            }
            objectArray[i2] = this.array[i2];
        }
        objectArray[n2] = e2;
        this.array = objectArray;
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Object[] objectArray = this.array();
        int n2 = objectArray.length;
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (CopyOnWriteArrayList.indexOf(iterator.next(), objectArray, n2) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        E[] EArray = this.array;
        int n2 = EArray.length;
        if (n2 == 0) {
            return false;
        }
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            E e2 = EArray[i2];
            if (collection.contains(e2)) continue;
            objectArray[n3++] = e2;
        }
        if (n3 == n2) {
            return false;
        }
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(objectArray, 0, objectArray2, 0, n3);
        this.array = objectArray2;
        return true;
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        E[] EArray = this.array;
        int n2 = EArray.length;
        if (n2 == 0) {
            return false;
        }
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            E e2 = EArray[i2];
            if (!collection.contains(e2)) continue;
            objectArray[n3++] = e2;
        }
        if (n3 == n2) {
            return false;
        }
        Object[] objectArray2 = new Object[n3];
        System.arraycopy(objectArray, 0, objectArray2, 0, n3);
        this.array = objectArray2;
        return true;
    }

    public synchronized int addAllAbsent(Collection<? extends E> collection) {
        Object object2;
        int n2 = collection.size();
        if (n2 == 0) {
            return 0;
        }
        Object[] objectArray = this.array;
        int n3 = objectArray.length;
        Object[] objectArray2 = new Object[n2];
        int n4 = 0;
        for (Object object2 : collection) {
            if (CopyOnWriteArrayList.indexOf(object2, objectArray, n3) >= 0 || CopyOnWriteArrayList.indexOf(object2, objectArray2, n4) >= 0) continue;
            objectArray2[n4++] = object2;
        }
        if (n4 == 0) {
            return 0;
        }
        object2 = new Object[n3 + n4];
        System.arraycopy(objectArray, 0, object2, 0, n3);
        System.arraycopy(objectArray2, 0, object2, n3, n4);
        this.array = object2;
        return n4;
    }

    @Override
    public synchronized void clear() {
        this.array = new Object[0];
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        int n2 = collection.size();
        if (n2 == 0) {
            return false;
        }
        int n3 = this.array.length;
        Object[] objectArray = new Object[n3 + n2];
        System.arraycopy(this.array, 0, objectArray, 0, n3);
        Iterator<E> iterator = collection.iterator();
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[n3++] = iterator.next();
        }
        this.array = objectArray;
        return true;
    }

    @Override
    public synchronized boolean addAll(int n2, Collection<? extends E> collection) {
        int n3 = this.array.length;
        if (n2 > n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + n3);
        }
        int n4 = collection.size();
        if (n4 == 0) {
            return false;
        }
        Object[] objectArray = new Object[n3 + n4];
        System.arraycopy(this.array, 0, objectArray, 0, n3);
        int n5 = n3 - n2;
        if (n5 > 0) {
            System.arraycopy(this.array, n2, objectArray, n2 + n4, n5);
        }
        Iterator<E> iterator = collection.iterator();
        for (int i2 = 0; i2 < n4; ++i2) {
            objectArray[n2++] = iterator.next();
        }
        this.array = objectArray;
        return true;
    }

    private void rangeCheck(int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + n3);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        E[] EArray = this.array();
        objectOutputStream.writeInt(EArray.length);
        for (int i2 = 0; i2 < EArray.length; ++i2) {
            objectOutputStream.writeObject(EArray[i2]);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = objectInputStream.readObject();
        }
        this.array = objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator<E> iterator = this.iterator();
        stringBuffer.append("[");
        int n2 = this.size() - 1;
        for (int i2 = 0; i2 <= n2; ++i2) {
            stringBuffer.append(String.valueOf(iterator.next()));
            if (i2 >= n2) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        ListIterator<E> listIterator = this.listIterator();
        ListIterator listIterator2 = list.listIterator();
        while (listIterator.hasNext()) {
            E e2 = listIterator.next();
            Object e3 = listIterator2.next();
            if (e2 != null ? e2.equals(e3) : e3 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        for (E e2 : this) {
            n2 = 31 * n2 + (e2 == null ? 0 : e2.hashCode());
        }
        return n2;
    }

    @Override
    public Iterator<E> iterator() {
        return new COWIterator(this.array(), 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new COWIterator(this.array(), 0);
    }

    @Override
    public ListIterator<E> listIterator(int n2) {
        E[] EArray = this.array();
        int n3 = EArray.length;
        if (n2 < 0 || n2 > n3) {
            throw new IndexOutOfBoundsException("Index: " + n2);
        }
        return new COWIterator(this.array(), n2);
    }

    @Override
    public synchronized List<E> subList(int n2, int n3) {
        int n4 = this.array.length;
        if (n2 < 0 || n3 > n4 || n2 > n3) {
            throw new IndexOutOfBoundsException();
        }
        return new COWSubList(this, n2, n3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class COWIterator<E>
    implements ListIterator<E> {
        private final E[] array;
        private int cursor;

        private COWIterator(E[] EArray, int n2) {
            this.array = EArray;
            this.cursor = n2;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.array.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            try {
                return this.array[this.cursor++];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public E previous() {
            try {
                return this.array[--this.cursor];
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e2) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class COWSubList<E>
    extends AbstractList<E> {
        private final CopyOnWriteArrayList<E> l;
        private final int offset;
        private int size;
        private E[] expectedArray;

        private COWSubList(CopyOnWriteArrayList<E> copyOnWriteArrayList, int n2, int n3) {
            this.l = copyOnWriteArrayList;
            this.expectedArray = ((CopyOnWriteArrayList)this.l).array();
            this.offset = n2;
            this.size = n3 - n2;
        }

        private void checkForComodification() {
            if (((CopyOnWriteArrayList)this.l).array != this.expectedArray) {
                throw new ConcurrentModificationException();
            }
        }

        private void rangeCheck(int n2) {
            if (n2 < 0 || n2 >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n2 + ",Size: " + this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int n2, E e2) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n2);
                this.checkForComodification();
                E e3 = this.l.set(n2 + this.offset, e2);
                this.expectedArray = ((CopyOnWriteArrayList)this.l).array;
                return e3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int n2) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n2);
                this.checkForComodification();
                return this.l.get(n2 + this.offset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n2, E e2) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n2 < 0 || n2 > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                this.l.add(n2 + this.offset, e2);
                this.expectedArray = ((CopyOnWriteArrayList)this.l).array;
                ++this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                ((CopyOnWriteArrayList)this.l).removeRange(this.offset, this.offset + this.size);
                this.expectedArray = ((CopyOnWriteArrayList)this.l).array;
                this.size = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int n2) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.rangeCheck(n2);
                this.checkForComodification();
                E e2 = this.l.remove(n2 + this.offset);
                this.expectedArray = ((CopyOnWriteArrayList)this.l).array;
                --this.size;
                return e2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<E> iterator() {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                return new COWSubListIterator(this.l, 0, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<E> listIterator(int n2) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n2 < 0 || n2 > this.size) {
                    throw new IndexOutOfBoundsException("Index: " + n2 + ", Size: " + this.size);
                }
                return new COWSubListIterator(this.l, n2, this.offset, this.size);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int n2, int n3) {
            CopyOnWriteArrayList<E> copyOnWriteArrayList = this.l;
            synchronized (copyOnWriteArrayList) {
                this.checkForComodification();
                if (n2 < 0 || n3 > this.size) {
                    throw new IndexOutOfBoundsException();
                }
                return new COWSubList<E>(this.l, n2 + this.offset, n3 + this.offset);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class COWSubListIterator<E>
    implements ListIterator<E> {
        private final ListIterator<E> i;
        private final int index;
        private final int offset;
        private final int size;

        private COWSubListIterator(List<E> list, int n2, int n3, int n4) {
            this.index = n2;
            this.offset = n3;
            this.size = n4;
            this.i = list.listIterator(n2 + n3);
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex() < this.size;
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                return this.i.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public boolean hasPrevious() {
            return this.previousIndex() >= 0;
        }

        @Override
        public E previous() {
            if (this.hasPrevious()) {
                return this.i.previous();
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex() - this.offset;
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex() - this.offset;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(E e2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e2) {
            throw new UnsupportedOperationException();
        }
    }
}

