/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeSet<E>
extends AbstractSet<E>
implements SortedSet<E>,
Cloneable,
Serializable {
    private transient SortedMap<E, Object> m;
    private transient Set<E> keySet;
    private static final Object PRESENT = new Object();
    private static final long serialVersionUID = -2479143000061671589L;

    private TreeSet(SortedMap<E, Object> sortedMap) {
        this.m = sortedMap;
        this.keySet = sortedMap.keySet();
    }

    public TreeSet() {
        this(new TreeMap());
    }

    public TreeSet(Comparator<? super E> comparator) {
        this(new TreeMap(comparator));
    }

    public TreeSet(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    public TreeSet(SortedSet<E> sortedSet) {
        this(sortedSet.comparator());
        this.addAll(sortedSet);
    }

    @Override
    public Iterator<E> iterator() {
        return this.keySet.iterator();
    }

    @Override
    public int size() {
        return this.m.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.m.containsKey(object);
    }

    @Override
    public boolean add(E e2) {
        return this.m.put(e2, PRESENT) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this.m.remove(object) == PRESENT;
    }

    @Override
    public void clear() {
        this.m.clear();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (this.m.size() == 0 && collection.size() > 0 && collection instanceof SortedSet && this.m instanceof TreeMap) {
            Comparator comparator;
            SortedSet sortedSet = (SortedSet)collection;
            TreeMap treeMap = (TreeMap)this.m;
            Comparator comparator2 = sortedSet.comparator();
            if (comparator2 == (comparator = treeMap.comparator()) || comparator2 != null && ((Object)comparator2).equals(comparator)) {
                treeMap.addAllForTreeSet(sortedSet, PRESENT);
                return true;
            }
        }
        return super.addAll(collection);
    }

    @Override
    public SortedSet<E> subSet(E e2, E e3) {
        return new TreeSet<E>(this.m.subMap(e2, e3));
    }

    @Override
    public SortedSet<E> headSet(E e2) {
        return new TreeSet<E>(this.m.headMap(e2));
    }

    @Override
    public SortedSet<E> tailSet(E e2) {
        return new TreeSet<E>(this.m.tailMap(e2));
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.m.comparator();
    }

    @Override
    public E first() {
        return this.m.firstKey();
    }

    @Override
    public E last() {
        return this.m.lastKey();
    }

    public Object clone() {
        TreeSet treeSet = null;
        try {
            treeSet = (TreeSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        treeSet.m = new TreeMap<E, Object>(this.m);
        treeSet.keySet = treeSet.m.keySet();
        return treeSet;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.m.comparator());
        objectOutputStream.writeInt(this.m.size());
        Iterator iterator = this.m.keySet().iterator();
        while (iterator.hasNext()) {
            objectOutputStream.writeObject(iterator.next());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Comparator comparator = (Comparator)objectInputStream.readObject();
        TreeMap<Object, Object> treeMap = comparator == null ? new TreeMap<E, Object>() : new TreeMap(comparator);
        this.m = treeMap;
        this.keySet = this.m.keySet();
        int n2 = objectInputStream.readInt();
        treeMap.readTreeSet(n2, objectInputStream, PRESENT);
    }
}

