/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIteratorFieldDelegate;
import java.text.DecimalFormatSymbols;
import java.text.DigitList;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import sun.text.resources.LocaleData;

public class DecimalFormat
extends NumberFormat {
    private transient BigInteger bigIntegerMultiplier;
    private transient BigDecimal bigDecimalMultiplier;
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    private transient DigitList digitList = new DigitList();
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private String posPrefixPattern;
    private String posSuffixPattern;
    private String negPrefixPattern;
    private String negSuffixPattern;
    private int multiplier = 1;
    private byte groupingSize = (byte)3;
    private boolean decimalSeparatorAlwaysShown = false;
    private boolean parseBigDecimal = false;
    private transient boolean isCurrencyFormat = false;
    private DecimalFormatSymbols symbols = null;
    private boolean useExponentialNotation;
    private transient FieldPosition[] positivePrefixFieldPositions;
    private transient FieldPosition[] positiveSuffixFieldPositions;
    private transient FieldPosition[] negativePrefixFieldPositions;
    private transient FieldPosition[] negativeSuffixFieldPositions;
    private byte minExponentDigits;
    private int maximumIntegerDigits = super.getMaximumIntegerDigits();
    private int minimumIntegerDigits = super.getMinimumIntegerDigits();
    private int maximumFractionDigits = super.getMaximumFractionDigits();
    private int minimumFractionDigits = super.getMinimumFractionDigits();
    static final int currentSerialVersion = 3;
    private int serialVersionOnStream = 3;
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_SEPARATOR = ';';
    private static final char PATTERN_EXPONENT = 'E';
    private static final char PATTERN_MINUS = '-';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    private static FieldPosition[] EmptyFieldPositionArray = new FieldPosition[0];
    static final int DOUBLE_INTEGER_DIGITS = 309;
    static final int DOUBLE_FRACTION_DIGITS = 340;
    static final int MAXIMUM_INTEGER_DIGITS = Integer.MAX_VALUE;
    static final int MAXIMUM_FRACTION_DIGITS = Integer.MAX_VALUE;
    static final long serialVersionUID = 864413376551465018L;
    private static Hashtable cachedLocaleData = new Hashtable(3);

    public DecimalFormat() {
        Locale locale = Locale.getDefault();
        String string = (String)cachedLocaleData.get(locale);
        if (string == null) {
            ResourceBundle resourceBundle = LocaleData.getLocaleElements(locale);
            String[] stringArray = resourceBundle.getStringArray("NumberPatterns");
            string = stringArray[0];
            cachedLocaleData.put(locale, string);
        }
        this.symbols = new DecimalFormatSymbols(locale);
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string) {
        this.symbols = new DecimalFormatSymbols(Locale.getDefault());
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        this.applyPattern(string, false);
    }

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte || object instanceof BigInteger && ((BigInteger)object).bitLength() < 64) {
            return this.format(((Number)object).longValue(), stringBuffer, fieldPosition);
        }
        if (object instanceof BigDecimal) {
            return this.format((BigDecimal)object, stringBuffer, fieldPosition);
        }
        if (object instanceof BigInteger) {
            return this.format((BigInteger)object, stringBuffer, fieldPosition);
        }
        if (object instanceof Number) {
            return this.format(((Number)object).doubleValue(), stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(d2, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(double d2, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        if (Double.isNaN(d2) || Double.isInfinite(d2) && this.multiplier == 0) {
            int n2 = stringBuffer.length();
            stringBuffer.append(this.symbols.getNaN());
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n2, stringBuffer.length(), stringBuffer);
            return stringBuffer;
        }
        boolean bl2 = (d2 < 0.0 || d2 == 0.0 && 1.0 / d2 < 0.0) ^ this.multiplier < 0;
        if (this.multiplier != 1) {
            d2 *= (double)this.multiplier;
        }
        if (Double.isInfinite(d2)) {
            if (bl2) {
                this.append(stringBuffer, this.negativePrefix, fieldDelegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.SIGN);
            } else {
                this.append(stringBuffer, this.positivePrefix, fieldDelegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.SIGN);
            }
            int n3 = stringBuffer.length();
            stringBuffer.append(this.symbols.getInfinity());
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n3, stringBuffer.length(), stringBuffer);
            if (bl2) {
                this.append(stringBuffer, this.negativeSuffix, fieldDelegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.SIGN);
            } else {
                this.append(stringBuffer, this.positiveSuffix, fieldDelegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.SIGN);
            }
            return stringBuffer;
        }
        if (bl2) {
            d2 = -d2;
        }
        assert (d2 >= 0.0 && !Double.isInfinite(d2));
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            int n4 = super.getMaximumIntegerDigits();
            int n5 = super.getMinimumIntegerDigits();
            int n6 = super.getMaximumFractionDigits();
            int n7 = super.getMinimumFractionDigits();
            this.digitList.set(d2, this.useExponentialNotation ? n4 + n6 : n6, !this.useExponentialNotation);
            return this.subformat(stringBuffer, fieldDelegate, bl2, false, n4, n5, n6, n7);
        }
    }

    public StringBuffer format(long l2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(l2, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(long l2, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        boolean bl2;
        boolean bl3 = bl2 = l2 < 0L;
        if (bl2) {
            l2 = -l2;
        }
        boolean bl4 = false;
        if (l2 < 0L) {
            if (this.multiplier != 0) {
                bl4 = true;
            }
        } else if (this.multiplier != 1 && this.multiplier != 0) {
            long l3 = Long.MAX_VALUE / (long)this.multiplier;
            if (l3 < 0L) {
                l3 = -l3;
            }
            boolean bl5 = bl4 = l2 > l3;
        }
        if (bl4) {
            if (bl2) {
                l2 = -l2;
            }
            BigInteger bigInteger = BigInteger.valueOf(l2);
            return this.format(bigInteger, stringBuffer, fieldDelegate, true);
        }
        if ((l2 *= (long)this.multiplier) == 0L) {
            bl2 = false;
        } else if (this.multiplier < 0) {
            l2 = -l2;
            bl2 = !bl2;
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            int n2 = super.getMaximumIntegerDigits();
            int n3 = super.getMinimumIntegerDigits();
            int n4 = super.getMaximumFractionDigits();
            int n5 = super.getMinimumFractionDigits();
            this.digitList.set(l2, this.useExponentialNotation ? n2 + n4 : 0);
            return this.subformat(stringBuffer, fieldDelegate, bl2, true, n2, n3, n4, n5);
        }
    }

    private StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(bigDecimal, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(BigDecimal bigDecimal, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        boolean bl2;
        if (this.multiplier != 1) {
            bigDecimal = bigDecimal.multiply(this.getBigDecimalMultiplier());
        }
        boolean bl3 = bl2 = bigDecimal.signum() == -1;
        if (bl2) {
            bigDecimal = bigDecimal.negate();
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            int n2 = this.getMaximumIntegerDigits();
            int n3 = this.getMinimumIntegerDigits();
            int n4 = this.getMaximumFractionDigits();
            int n5 = this.getMinimumFractionDigits();
            int n6 = n2 + n4;
            this.digitList.set(bigDecimal, this.useExponentialNotation ? (n6 < 0 ? Integer.MAX_VALUE : n6) : n4, !this.useExponentialNotation);
            return this.subformat(stringBuffer, fieldDelegate, bl2, false, n2, n3, n4, n5);
        }
    }

    private StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(bigInteger, stringBuffer, fieldPosition.getFieldDelegate(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(BigInteger bigInteger, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate, boolean bl2) {
        boolean bl3;
        if (this.multiplier != 1) {
            bigInteger = bigInteger.multiply(this.getBigIntegerMultiplier());
        }
        boolean bl4 = bl3 = bigInteger.signum() == -1;
        if (bl3) {
            bigInteger = bigInteger.negate();
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            if (bl2) {
                n6 = super.getMaximumIntegerDigits();
                n5 = super.getMinimumIntegerDigits();
                n4 = super.getMaximumFractionDigits();
                n3 = super.getMinimumFractionDigits();
                n2 = n6 + n4;
            } else {
                n6 = this.getMaximumIntegerDigits();
                n5 = this.getMinimumIntegerDigits();
                n4 = this.getMaximumFractionDigits();
                n3 = this.getMinimumFractionDigits();
                n2 = n6 + n4;
                if (n2 < 0) {
                    n2 = Integer.MAX_VALUE;
                }
            }
            this.digitList.set(bigInteger, this.useExponentialNotation ? n2 : 0);
            return this.subformat(stringBuffer, fieldDelegate, bl3, true, n6, n5, n4, n3);
        }
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        CharacterIteratorFieldDelegate characterIteratorFieldDelegate = new CharacterIteratorFieldDelegate();
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Double || object instanceof Float) {
            this.format(((Number)object).doubleValue(), stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
        } else if (object instanceof Long || object instanceof Integer || object instanceof Short || object instanceof Byte) {
            this.format(((Number)object).longValue(), stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
        } else if (object instanceof BigDecimal) {
            this.format((BigDecimal)object, stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
        } else if (object instanceof BigInteger) {
            this.format((BigInteger)object, stringBuffer, characterIteratorFieldDelegate, false);
        } else {
            if (object == null) {
                throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
            }
            throw new IllegalArgumentException("Cannot format given Object as a Number");
        }
        return characterIteratorFieldDelegate.getIterator(stringBuffer.toString());
    }

    private StringBuffer subformat(StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate, boolean bl2, boolean bl3, int n2, int n3, int n4, int n5) {
        char c2;
        char c3 = this.symbols.getZeroDigit();
        int n6 = c3 - 48;
        char c4 = this.symbols.getGroupingSeparator();
        char c5 = c2 = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
        if (this.digitList.isZero()) {
            this.digitList.decimalAt = 0;
        }
        if (bl2) {
            this.append(stringBuffer, this.negativePrefix, fieldDelegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.SIGN);
        } else {
            this.append(stringBuffer, this.positivePrefix, fieldDelegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.SIGN);
        }
        if (this.useExponentialNotation) {
            int n7;
            boolean bl4;
            int n8;
            int n9;
            int n10;
            int n11 = stringBuffer.length();
            int n12 = -1;
            int n13 = -1;
            int n14 = this.digitList.decimalAt;
            int n15 = n2;
            int n16 = n3;
            if (n15 > 1 && n15 > n3) {
                n14 = n14 >= 1 ? (n14 - 1) / n15 * n15 : (n14 - n15) / n15 * n15;
                n16 = 1;
            } else {
                n14 -= n16;
            }
            int n17 = n3 + n5;
            if (n17 < 0) {
                n17 = Integer.MAX_VALUE;
            }
            int n18 = n10 = this.digitList.isZero() ? n16 : this.digitList.decimalAt - n14;
            if (n17 < n10) {
                n17 = n10;
            }
            if (n17 > (n9 = this.digitList.count)) {
                n9 = n17;
            }
            boolean bl5 = false;
            for (n8 = 0; n8 < n9; ++n8) {
                if (n8 == n10) {
                    n12 = stringBuffer.length();
                    stringBuffer.append(c2);
                    bl5 = true;
                    n13 = stringBuffer.length();
                }
                stringBuffer.append(n8 < this.digitList.count ? (char)(this.digitList.digits[n8] + n6) : c3);
            }
            if (this.decimalSeparatorAlwaysShown && n9 == n10) {
                n12 = stringBuffer.length();
                stringBuffer.append(c2);
                bl5 = true;
                n13 = stringBuffer.length();
            }
            if (n12 == -1) {
                n12 = stringBuffer.length();
            }
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n11, n12, stringBuffer);
            if (bl5) {
                fieldDelegate.formatted(NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.DECIMAL_SEPARATOR, n12, n13, stringBuffer);
            }
            if (n13 == -1) {
                n13 = stringBuffer.length();
            }
            fieldDelegate.formatted(1, NumberFormat.Field.FRACTION, NumberFormat.Field.FRACTION, n13, stringBuffer.length(), stringBuffer);
            n8 = stringBuffer.length();
            stringBuffer.append(this.symbols.getExponentialSymbol());
            fieldDelegate.formatted(NumberFormat.Field.EXPONENT_SYMBOL, NumberFormat.Field.EXPONENT_SYMBOL, n8, stringBuffer.length(), stringBuffer);
            if (this.digitList.isZero()) {
                n14 = 0;
            }
            boolean bl6 = bl4 = n14 < 0;
            if (bl4) {
                n14 = -n14;
                n8 = stringBuffer.length();
                stringBuffer.append(this.symbols.getMinusSign());
                fieldDelegate.formatted(NumberFormat.Field.EXPONENT_SIGN, NumberFormat.Field.EXPONENT_SIGN, n8, stringBuffer.length(), stringBuffer);
            }
            this.digitList.set(n14);
            int n19 = stringBuffer.length();
            for (n7 = this.digitList.decimalAt; n7 < this.minExponentDigits; ++n7) {
                stringBuffer.append(c3);
            }
            for (n7 = 0; n7 < this.digitList.decimalAt; ++n7) {
                stringBuffer.append(n7 < this.digitList.count ? (char)(this.digitList.digits[n7] + n6) : c3);
            }
            fieldDelegate.formatted(NumberFormat.Field.EXPONENT, NumberFormat.Field.EXPONENT, n19, stringBuffer.length(), stringBuffer);
        } else {
            int n20;
            int n21;
            int n22 = stringBuffer.length();
            int n23 = n3;
            int n24 = 0;
            if (this.digitList.decimalAt > 0 && n23 < this.digitList.decimalAt) {
                n23 = this.digitList.decimalAt;
            }
            if (n23 > n2) {
                n23 = n2;
                n24 = this.digitList.decimalAt - n23;
            }
            int n25 = stringBuffer.length();
            for (n21 = n23 - 1; n21 >= 0; --n21) {
                if (n21 < this.digitList.decimalAt && n24 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n24++] + n6));
                } else {
                    stringBuffer.append(c3);
                }
                if (!this.isGroupingUsed() || n21 <= 0 || this.groupingSize == 0 || n21 % this.groupingSize != 0) continue;
                n20 = stringBuffer.length();
                stringBuffer.append(c4);
                fieldDelegate.formatted(NumberFormat.Field.GROUPING_SEPARATOR, NumberFormat.Field.GROUPING_SEPARATOR, n20, stringBuffer.length(), stringBuffer);
            }
            int n26 = n21 = n5 > 0 || !bl3 && n24 < this.digitList.count ? 1 : 0;
            if (n21 == 0 && stringBuffer.length() == n25) {
                stringBuffer.append(c3);
            }
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n22, stringBuffer.length(), stringBuffer);
            n20 = stringBuffer.length();
            if (this.decimalSeparatorAlwaysShown || n21 != 0) {
                stringBuffer.append(c2);
            }
            if (n20 != stringBuffer.length()) {
                fieldDelegate.formatted(NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.DECIMAL_SEPARATOR, n20, stringBuffer.length(), stringBuffer);
            }
            int n27 = stringBuffer.length();
            for (int i2 = 0; i2 < n4 && (i2 < n5 || !bl3 && n24 < this.digitList.count); ++i2) {
                if (-1 - i2 > this.digitList.decimalAt - 1) {
                    stringBuffer.append(c3);
                    continue;
                }
                if (!bl3 && n24 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n24++] + n6));
                    continue;
                }
                stringBuffer.append(c3);
            }
            fieldDelegate.formatted(1, NumberFormat.Field.FRACTION, NumberFormat.Field.FRACTION, n27, stringBuffer.length(), stringBuffer);
        }
        if (bl2) {
            this.append(stringBuffer, this.negativeSuffix, fieldDelegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.SIGN);
        } else {
            this.append(stringBuffer, this.positiveSuffix, fieldDelegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.SIGN);
        }
        return stringBuffer;
    }

    private void append(StringBuffer stringBuffer, String string, Format.FieldDelegate fieldDelegate, FieldPosition[] fieldPositionArray, Format.Field field) {
        int n2 = stringBuffer.length();
        if (string.length() > 0) {
            stringBuffer.append(string);
            for (FieldPosition fieldPosition : fieldPositionArray) {
                Format.Field field2 = fieldPosition.getFieldAttribute();
                if (field2 == NumberFormat.Field.SIGN) {
                    field2 = field;
                }
                fieldDelegate.formatted(field2, field2, n2 + fieldPosition.getBeginIndex(), n2 + fieldPosition.getEndIndex(), stringBuffer);
            }
        }
    }

    public Number parse(String string, ParsePosition parsePosition) {
        if (string.regionMatches(parsePosition.index, this.symbols.getNaN(), 0, this.symbols.getNaN().length())) {
            parsePosition.index += this.symbols.getNaN().length();
            return new Double(Double.NaN);
        }
        boolean[] blArray = new boolean[2];
        if (!this.subparse(string, parsePosition, this.positivePrefix, this.negativePrefix, this.digitList, false, blArray)) {
            return null;
        }
        if (blArray[0]) {
            if (blArray[1] == this.multiplier >= 0) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (this.multiplier == 0) {
            if (this.digitList.isZero()) {
                return new Double(Double.NaN);
            }
            if (blArray[1]) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            return new Double(Double.NEGATIVE_INFINITY);
        }
        if (this.isParseBigDecimal()) {
            BigDecimal bigDecimal = this.digitList.getBigDecimal();
            if (this.multiplier != 1) {
                try {
                    bigDecimal = bigDecimal.divide(this.getBigDecimalMultiplier());
                }
                catch (ArithmeticException arithmeticException) {
                    bigDecimal = bigDecimal.divide(this.getBigDecimalMultiplier(), 6);
                }
            }
            if (!blArray[1]) {
                bigDecimal = bigDecimal.negate();
            }
            return bigDecimal;
        }
        boolean bl2 = true;
        boolean bl3 = false;
        double d2 = 0.0;
        long l2 = 0L;
        if (this.digitList.fitsIntoLong(blArray[1], this.isParseIntegerOnly())) {
            bl2 = false;
            l2 = this.digitList.getLong();
            if (l2 < 0L) {
                bl3 = true;
            }
        } else {
            d2 = this.digitList.getDouble();
        }
        if (this.multiplier != 1) {
            if (bl2) {
                d2 /= (double)this.multiplier;
            } else if (l2 % (long)this.multiplier == 0L) {
                l2 /= (long)this.multiplier;
            } else {
                d2 = (double)l2 / (double)this.multiplier;
                bl2 = true;
            }
        }
        if (!blArray[1] && !bl3) {
            d2 = -d2;
            l2 = -l2;
        }
        if (this.multiplier != 1 && bl2) {
            l2 = (long)d2;
            bl2 = (d2 != (double)l2 || d2 == 0.0 && 1.0 / d2 < 0.0) && !this.isParseIntegerOnly();
        }
        return bl2 ? (Number)new Double(d2) : (Number)new Long(l2);
    }

    private BigInteger getBigIntegerMultiplier() {
        if (this.bigIntegerMultiplier == null) {
            this.bigIntegerMultiplier = BigInteger.valueOf(this.multiplier);
        }
        return this.bigIntegerMultiplier;
    }

    private BigDecimal getBigDecimalMultiplier() {
        if (this.bigDecimalMultiplier == null) {
            this.bigDecimalMultiplier = new BigDecimal(this.multiplier);
        }
        return this.bigDecimalMultiplier;
    }

    private final boolean subparse(String string, ParsePosition parsePosition, String string2, String string3, DigitList digitList, boolean bl2, boolean[] blArray) {
        int n2 = parsePosition.index;
        int n3 = parsePosition.index;
        boolean bl3 = string.regionMatches(n2, string2, 0, string2.length());
        boolean bl4 = string.regionMatches(n2, string3, 0, string3.length());
        if (bl3 && bl4) {
            if (string2.length() > string3.length()) {
                bl4 = false;
            } else if (string2.length() < string3.length()) {
                bl3 = false;
            }
        }
        if (bl3) {
            n2 += string2.length();
        } else if (bl4) {
            n2 += string3.length();
        } else {
            parsePosition.errorIndex = n2;
            return false;
        }
        blArray[0] = false;
        if (!bl2 && string.regionMatches(n2, this.symbols.getInfinity(), 0, this.symbols.getInfinity().length())) {
            n2 += this.symbols.getInfinity().length();
            blArray[0] = true;
        } else {
            digitList.count = 0;
            digitList.decimalAt = 0;
            char c2 = this.symbols.getZeroDigit();
            char c3 = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
            char c4 = this.symbols.getGroupingSeparator();
            char c5 = this.symbols.getExponentialSymbol();
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            int n4 = 0;
            int n5 = 0;
            int n6 = -1;
            while (n2 < string.length()) {
                char c6 = string.charAt(n2);
                int n7 = c6 - c2;
                if (n7 < 0 || n7 > 9) {
                    n7 = Character.digit(c6, 10);
                }
                if (n7 == 0) {
                    n6 = -1;
                    bl7 = true;
                    if (digitList.count == 0) {
                        if (bl5) {
                            --digitList.decimalAt;
                        }
                    } else {
                        ++n5;
                        digitList.append((char)(n7 + 48));
                    }
                } else if (n7 > 0 && n7 <= 9) {
                    bl7 = true;
                    ++n5;
                    digitList.append((char)(n7 + 48));
                    n6 = -1;
                } else if (!bl2 && c6 == c3) {
                    if (this.isParseIntegerOnly() || bl5) break;
                    digitList.decimalAt = n5;
                    bl5 = true;
                } else if (!bl2 && c6 == c4 && this.isGroupingUsed()) {
                    if (bl5) break;
                    n6 = n2;
                } else {
                    if (bl2 || c6 != c5 || bl6) break;
                    ParsePosition parsePosition2 = new ParsePosition(n2 + 1);
                    boolean[] blArray2 = new boolean[2];
                    DigitList digitList2 = new DigitList();
                    if (!this.subparse(string, parsePosition2, "", Character.toString(this.symbols.getMinusSign()), digitList2, true, blArray2) || !digitList2.fitsIntoLong(blArray2[1], true)) break;
                    n2 = parsePosition2.index;
                    n4 = (int)digitList2.getLong();
                    if (!blArray2[1]) {
                        n4 = -n4;
                    }
                    bl6 = true;
                    break;
                }
                ++n2;
            }
            if (n6 != -1) {
                n2 = n6;
            }
            if (!bl5) {
                digitList.decimalAt = n5;
            }
            digitList.decimalAt += n4;
            if (!bl7 && n5 == 0) {
                parsePosition.index = n3;
                parsePosition.errorIndex = n3;
                return false;
            }
        }
        if (!bl2) {
            if (bl3) {
                bl3 = string.regionMatches(n2, this.positiveSuffix, 0, this.positiveSuffix.length());
            }
            if (bl4) {
                bl4 = string.regionMatches(n2, this.negativeSuffix, 0, this.negativeSuffix.length());
            }
            if (bl3 && bl4) {
                if (this.positiveSuffix.length() > this.negativeSuffix.length()) {
                    bl4 = false;
                } else if (this.positiveSuffix.length() < this.negativeSuffix.length()) {
                    bl3 = false;
                }
            }
            if (bl3 == bl4) {
                parsePosition.errorIndex = n2;
                return false;
            }
            parsePosition.index = n2 + (bl3 ? this.positiveSuffix.length() : this.negativeSuffix.length());
        } else {
            parsePosition.index = n2;
        }
        blArray[1] = bl3;
        if (parsePosition.index == n3) {
            parsePosition.errorIndex = n2;
            return false;
        }
        return true;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        try {
            return (DecimalFormatSymbols)this.symbols.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        try {
            this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
            this.expandAffixes();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String string) {
        this.positivePrefix = string;
        this.posPrefixPattern = null;
        this.positivePrefixFieldPositions = null;
    }

    private FieldPosition[] getPositivePrefixFieldPositions() {
        if (this.positivePrefixFieldPositions == null) {
            this.positivePrefixFieldPositions = this.posPrefixPattern != null ? this.expandAffix(this.posPrefixPattern) : EmptyFieldPositionArray;
        }
        return this.positivePrefixFieldPositions;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public void setNegativePrefix(String string) {
        this.negativePrefix = string;
        this.negPrefixPattern = null;
    }

    private FieldPosition[] getNegativePrefixFieldPositions() {
        if (this.negativePrefixFieldPositions == null) {
            this.negativePrefixFieldPositions = this.negPrefixPattern != null ? this.expandAffix(this.negPrefixPattern) : EmptyFieldPositionArray;
        }
        return this.negativePrefixFieldPositions;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public void setPositiveSuffix(String string) {
        this.positiveSuffix = string;
        this.posSuffixPattern = null;
    }

    private FieldPosition[] getPositiveSuffixFieldPositions() {
        if (this.positiveSuffixFieldPositions == null) {
            this.positiveSuffixFieldPositions = this.posSuffixPattern != null ? this.expandAffix(this.posSuffixPattern) : EmptyFieldPositionArray;
        }
        return this.positiveSuffixFieldPositions;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public void setNegativeSuffix(String string) {
        this.negativeSuffix = string;
        this.negSuffixPattern = null;
    }

    private FieldPosition[] getNegativeSuffixFieldPositions() {
        if (this.negativeSuffixFieldPositions == null) {
            this.negativeSuffixFieldPositions = this.negSuffixPattern != null ? this.expandAffix(this.negSuffixPattern) : EmptyFieldPositionArray;
        }
        return this.negativeSuffixFieldPositions;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int n2) {
        this.multiplier = n2;
        this.bigDecimalMultiplier = null;
        this.bigIntegerMultiplier = null;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int n2) {
        this.groupingSize = (byte)n2;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl2) {
        this.decimalSeparatorAlwaysShown = bl2;
    }

    public boolean isParseBigDecimal() {
        return this.parseBigDecimal;
    }

    public void setParseBigDecimal(boolean bl2) {
        this.parseBigDecimal = bl2;
    }

    public Object clone() {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)super.clone();
            decimalFormat.symbols = (DecimalFormatSymbols)this.symbols.clone();
            decimalFormat.digitList = (DigitList)this.digitList.clone();
            return decimalFormat;
        }
        catch (Exception exception) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)object;
        return (this.posPrefixPattern == decimalFormat.posPrefixPattern && this.positivePrefix.equals(decimalFormat.positivePrefix) || this.posPrefixPattern != null && this.posPrefixPattern.equals(decimalFormat.posPrefixPattern)) && (this.posSuffixPattern == decimalFormat.posSuffixPattern && this.positiveSuffix.equals(decimalFormat.positiveSuffix) || this.posSuffixPattern != null && this.posSuffixPattern.equals(decimalFormat.posSuffixPattern)) && (this.negPrefixPattern == decimalFormat.negPrefixPattern && this.negativePrefix.equals(decimalFormat.negativePrefix) || this.negPrefixPattern != null && this.negPrefixPattern.equals(decimalFormat.negPrefixPattern)) && (this.negSuffixPattern == decimalFormat.negSuffixPattern && this.negativeSuffix.equals(decimalFormat.negativeSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(decimalFormat.negSuffixPattern)) && this.multiplier == decimalFormat.multiplier && this.groupingSize == decimalFormat.groupingSize && this.decimalSeparatorAlwaysShown == decimalFormat.decimalSeparatorAlwaysShown && this.parseBigDecimal == decimalFormat.parseBigDecimal && this.useExponentialNotation == decimalFormat.useExponentialNotation && (!this.useExponentialNotation || this.minExponentDigits == decimalFormat.minExponentDigits) && this.maximumIntegerDigits == decimalFormat.maximumIntegerDigits && this.minimumIntegerDigits == decimalFormat.minimumIntegerDigits && this.maximumFractionDigits == decimalFormat.maximumFractionDigits && this.minimumFractionDigits == decimalFormat.minimumFractionDigits && this.symbols.equals(decimalFormat.symbols);
    }

    public int hashCode() {
        return super.hashCode() * 37 + this.positivePrefix.hashCode();
    }

    public String toPattern() {
        return this.toPattern(false);
    }

    public String toLocalizedPattern() {
        return this.toPattern(true);
    }

    private void expandAffixes() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.posPrefixPattern != null) {
            this.positivePrefix = this.expandAffix(this.posPrefixPattern, stringBuffer);
            this.positivePrefixFieldPositions = null;
        }
        if (this.posSuffixPattern != null) {
            this.positiveSuffix = this.expandAffix(this.posSuffixPattern, stringBuffer);
            this.positiveSuffixFieldPositions = null;
        }
        if (this.negPrefixPattern != null) {
            this.negativePrefix = this.expandAffix(this.negPrefixPattern, stringBuffer);
            this.negativePrefixFieldPositions = null;
        }
        if (this.negSuffixPattern != null) {
            this.negativeSuffix = this.expandAffix(this.negSuffixPattern, stringBuffer);
            this.negativeSuffixFieldPositions = null;
        }
    }

    private String expandAffix(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n2 = 0;
        block6: while (n2 < string.length()) {
            char c2;
            if ((c2 = string.charAt(n2++)) == '\'') {
                c2 = string.charAt(n2++);
                switch (c2) {
                    case '\u00a4': {
                        if (n2 < string.length() && string.charAt(n2) == '\u00a4') {
                            ++n2;
                            stringBuffer.append(this.symbols.getInternationalCurrencySymbol());
                            continue block6;
                        }
                        stringBuffer.append(this.symbols.getCurrencySymbol());
                        continue block6;
                    }
                    case '%': {
                        c2 = this.symbols.getPercent();
                        break;
                    }
                    case '\u2030': {
                        c2 = this.symbols.getPerMill();
                        break;
                    }
                    case '-': {
                        c2 = this.symbols.getMinusSign();
                    }
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    private FieldPosition[] expandAffix(String string) {
        ArrayList<Object> arrayList = null;
        int n2 = 0;
        int n3 = 0;
        block6: while (n3 < string.length()) {
            char c2;
            if ((c2 = string.charAt(n3++)) == '\'') {
                Object object;
                int n4 = -1;
                NumberFormat.Field field = null;
                c2 = string.charAt(n3++);
                switch (c2) {
                    case '\u00a4': {
                        if (n3 < string.length() && string.charAt(n3) == '\u00a4') {
                            ++n3;
                            object = this.symbols.getInternationalCurrencySymbol();
                        } else {
                            object = this.symbols.getCurrencySymbol();
                        }
                        if (((String)object).length() <= 0) continue block6;
                        if (arrayList == null) {
                            arrayList = new ArrayList(2);
                        }
                        FieldPosition fieldPosition = new FieldPosition(NumberFormat.Field.CURRENCY);
                        fieldPosition.setBeginIndex(n2);
                        fieldPosition.setEndIndex(n2 + ((String)object).length());
                        arrayList.add(fieldPosition);
                        n2 += ((String)object).length();
                        continue block6;
                    }
                    case '%': {
                        c2 = this.symbols.getPercent();
                        n4 = -1;
                        field = NumberFormat.Field.PERCENT;
                        break;
                    }
                    case '\u2030': {
                        c2 = this.symbols.getPerMill();
                        n4 = -1;
                        field = NumberFormat.Field.PERMILLE;
                        break;
                    }
                    case '-': {
                        c2 = this.symbols.getMinusSign();
                        n4 = -1;
                        field = NumberFormat.Field.SIGN;
                    }
                }
                if (field != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<Object>(2);
                    }
                    object = new FieldPosition(field, n4);
                    ((FieldPosition)object).setBeginIndex(n2);
                    ((FieldPosition)object).setEndIndex(n2 + 1);
                    arrayList.add(object);
                }
            }
            ++n2;
        }
        if (arrayList != null) {
            return arrayList.toArray(EmptyFieldPositionArray);
        }
        return EmptyFieldPositionArray;
    }

    private void appendAffix(StringBuffer stringBuffer, String string, String string2, boolean bl2) {
        if (string == null) {
            this.appendAffix(stringBuffer, string2, bl2);
        } else {
            int n2 = 0;
            while (n2 < string.length()) {
                int n3 = string.indexOf(39, n2);
                if (n3 < 0) {
                    this.appendAffix(stringBuffer, string.substring(n2), bl2);
                    break;
                }
                if (n3 > n2) {
                    this.appendAffix(stringBuffer, string.substring(n2, n3), bl2);
                }
                char c2 = string.charAt(++n3);
                ++n3;
                if (c2 == '\'') {
                    stringBuffer.append(c2);
                } else if (c2 == '\u00a4' && n3 < string.length() && string.charAt(n3) == '\u00a4') {
                    stringBuffer.append(c2);
                } else if (bl2) {
                    switch (c2) {
                        case '%': {
                            c2 = this.symbols.getPercent();
                            break;
                        }
                        case '\u2030': {
                            c2 = this.symbols.getPerMill();
                            break;
                        }
                        case '-': {
                            c2 = this.symbols.getMinusSign();
                        }
                    }
                }
                stringBuffer.append(c2);
                n2 = ++n3;
            }
        }
    }

    private void appendAffix(StringBuffer stringBuffer, String string, boolean bl2) {
        boolean bl3;
        if (bl2) {
            bl3 = string.indexOf(this.symbols.getZeroDigit()) >= 0 || string.indexOf(this.symbols.getGroupingSeparator()) >= 0 || string.indexOf(this.symbols.getDecimalSeparator()) >= 0 || string.indexOf(this.symbols.getPercent()) >= 0 || string.indexOf(this.symbols.getPerMill()) >= 0 || string.indexOf(this.symbols.getDigit()) >= 0 || string.indexOf(this.symbols.getPatternSeparator()) >= 0 || string.indexOf(this.symbols.getMinusSign()) >= 0 || string.indexOf(164) >= 0;
        } else {
            boolean bl4 = bl3 = string.indexOf(48) >= 0 || string.indexOf(44) >= 0 || string.indexOf(46) >= 0 || string.indexOf(37) >= 0 || string.indexOf(8240) >= 0 || string.indexOf(35) >= 0 || string.indexOf(59) >= 0 || string.indexOf(45) >= 0 || string.indexOf(164) >= 0;
        }
        if (bl3) {
            stringBuffer.append('\'');
        }
        if (string.indexOf(39) < 0) {
            stringBuffer.append(string);
        } else {
            for (int i2 = 0; i2 < string.length(); ++i2) {
                char c2 = string.charAt(i2);
                stringBuffer.append(c2);
                if (c2 != '\'') continue;
                stringBuffer.append(c2);
            }
        }
        if (bl3) {
            stringBuffer.append('\'');
        }
    }

    private String toPattern(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 1; i2 >= 0; --i2) {
            int n2;
            int n3;
            if (i2 == 1) {
                this.appendAffix(stringBuffer, this.posPrefixPattern, this.positivePrefix, bl2);
            } else {
                this.appendAffix(stringBuffer, this.negPrefixPattern, this.negativePrefix, bl2);
            }
            for (n3 = n2 = this.useExponentialNotation ? this.getMaximumIntegerDigits() : Math.max(this.groupingSize, this.getMinimumIntegerDigits()) + 1; n3 > 0; --n3) {
                if (n3 != n2 && this.isGroupingUsed() && this.groupingSize != 0 && n3 % this.groupingSize == 0) {
                    stringBuffer.append(bl2 ? this.symbols.getGroupingSeparator() : (char)',');
                }
                stringBuffer.append(n3 <= this.getMinimumIntegerDigits() ? (bl2 ? this.symbols.getZeroDigit() : (char)'0') : (bl2 ? this.symbols.getDigit() : (char)'#'));
            }
            if (this.getMaximumFractionDigits() > 0 || this.decimalSeparatorAlwaysShown) {
                stringBuffer.append(bl2 ? this.symbols.getDecimalSeparator() : (char)'.');
            }
            for (n3 = 0; n3 < this.getMaximumFractionDigits(); ++n3) {
                if (n3 < this.getMinimumFractionDigits()) {
                    stringBuffer.append(bl2 ? this.symbols.getZeroDigit() : (char)'0');
                    continue;
                }
                stringBuffer.append(bl2 ? this.symbols.getDigit() : (char)'#');
            }
            if (this.useExponentialNotation) {
                stringBuffer.append(bl2 ? this.symbols.getExponentialSymbol() : (char)'E');
                for (n3 = 0; n3 < this.minExponentDigits; ++n3) {
                    stringBuffer.append(bl2 ? this.symbols.getZeroDigit() : (char)'0');
                }
            }
            if (i2 == 1) {
                this.appendAffix(stringBuffer, this.posSuffixPattern, this.positiveSuffix, bl2);
                if ((this.negSuffixPattern == this.posSuffixPattern && this.negativeSuffix.equals(this.positiveSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(this.posSuffixPattern)) && (this.negPrefixPattern != null && this.posPrefixPattern != null && this.negPrefixPattern.equals("'-" + this.posPrefixPattern) || this.negPrefixPattern == this.posPrefixPattern && this.negativePrefix.equals(this.symbols.getMinusSign() + this.positivePrefix))) break;
                stringBuffer.append(bl2 ? this.symbols.getPatternSeparator() : (char)';');
                continue;
            }
            this.appendAffix(stringBuffer, this.negSuffixPattern, this.negativeSuffix, bl2);
        }
        return stringBuffer.toString();
    }

    public void applyPattern(String string) {
        this.applyPattern(string, false);
    }

    public void applyLocalizedPattern(String string) {
        this.applyPattern(string, true);
    }

    private void applyPattern(String string, boolean bl2) {
        int n2 = 48;
        int n3 = 44;
        int n4 = 46;
        int n5 = 37;
        int n6 = 8240;
        int n7 = 35;
        int n8 = 59;
        int n9 = 69;
        int n10 = 45;
        if (bl2) {
            n2 = this.symbols.getZeroDigit();
            n3 = this.symbols.getGroupingSeparator();
            n4 = this.symbols.getDecimalSeparator();
            n5 = this.symbols.getPercent();
            n6 = this.symbols.getPerMill();
            n7 = this.symbols.getDigit();
            n8 = this.symbols.getPatternSeparator();
            n9 = this.symbols.getExponentialSymbol();
            n10 = this.symbols.getMinusSign();
        }
        boolean bl3 = false;
        this.decimalSeparatorAlwaysShown = false;
        this.isCurrencyFormat = false;
        this.useExponentialNotation = false;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        for (int i2 = 1; i2 >= 0 && n13 < string.length(); --i2) {
            int n14;
            int n15;
            boolean bl4 = false;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            int n16 = -1;
            int n17 = 1;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            int n21 = -1;
            int n22 = 0;
            StringBuffer stringBuffer3 = stringBuffer;
            block5: for (n15 = n13; n15 < string.length(); ++n15) {
                n14 = string.charAt(n15);
                switch (n22) {
                    case 0: 
                    case 2: {
                        if (bl4) {
                            if (n14 == 39) {
                                if (n15 + 1 < string.length() && string.charAt(n15 + 1) == '\'') {
                                    ++n15;
                                    stringBuffer3.append("''");
                                    continue block5;
                                }
                                bl4 = false;
                                continue block5;
                            }
                        } else {
                            if (n14 == n7 || n14 == n2 || n14 == n3 || n14 == n4) {
                                n22 = 1;
                                if (i2 == 1) {
                                    n11 = n15;
                                }
                                --n15;
                                continue block5;
                            }
                            if (n14 == 164) {
                                boolean bl5;
                                boolean bl6 = bl5 = n15 + 1 < string.length() && string.charAt(n15 + 1) == '\u00a4';
                                if (bl5) {
                                    ++n15;
                                }
                                this.isCurrencyFormat = true;
                                stringBuffer3.append(bl5 ? "'\u00a4\u00a4" : "'\u00a4");
                                continue block5;
                            }
                            if (n14 == 39) {
                                if (n14 == 39) {
                                    if (n15 + 1 < string.length() && string.charAt(n15 + 1) == '\'') {
                                        ++n15;
                                        stringBuffer3.append("''");
                                        continue block5;
                                    }
                                    bl4 = true;
                                    continue block5;
                                }
                            } else {
                                if (n14 == n8) {
                                    if (n22 == 0 || i2 == 0) {
                                        throw new IllegalArgumentException("Unquoted special character '" + (char)n14 + "' in pattern \"" + string + '\"');
                                    }
                                    n13 = n15 + 1;
                                    n15 = string.length();
                                    continue block5;
                                }
                                if (n14 == n5) {
                                    if (n17 != 1) {
                                        throw new IllegalArgumentException("Too many percent/per mille characters in pattern \"" + string + '\"');
                                    }
                                    n17 = 100;
                                    stringBuffer3.append("'%");
                                    continue block5;
                                }
                                if (n14 == n6) {
                                    if (n17 != 1) {
                                        throw new IllegalArgumentException("Too many percent/per mille characters in pattern \"" + string + '\"');
                                    }
                                    n17 = 1000;
                                    stringBuffer3.append("'\u2030");
                                    continue block5;
                                }
                                if (n14 == n10) {
                                    stringBuffer3.append("'-");
                                    continue block5;
                                }
                            }
                        }
                        stringBuffer3.append((char)n14);
                        continue block5;
                    }
                    case 1: {
                        if (i2 == 1) {
                            ++n12;
                        } else {
                            if (--n12 != 0) continue block5;
                            n22 = 2;
                            stringBuffer3 = stringBuffer2;
                            continue block5;
                        }
                        if (n14 == n7) {
                            if (n19 > 0) {
                                ++n20;
                            } else {
                                ++n18;
                            }
                            if (n21 < 0 || n16 >= 0) continue block5;
                            n21 = (byte)(n21 + 1);
                            continue block5;
                        }
                        if (n14 == n2) {
                            if (n20 > 0) {
                                throw new IllegalArgumentException("Unexpected '0' in pattern \"" + string + '\"');
                            }
                            ++n19;
                            if (n21 < 0 || n16 >= 0) continue block5;
                            n21 = (byte)(n21 + 1);
                            continue block5;
                        }
                        if (n14 == n3) {
                            n21 = 0;
                            continue block5;
                        }
                        if (n14 == n4) {
                            if (n16 >= 0) {
                                throw new IllegalArgumentException("Multiple decimal separators in pattern \"" + string + '\"');
                            }
                            n16 = n18 + n19 + n20;
                            continue block5;
                        }
                        if (n14 == n9) {
                            if (this.useExponentialNotation) {
                                throw new IllegalArgumentException("Multiple exponential symbols in pattern \"" + string + '\"');
                            }
                            this.useExponentialNotation = true;
                            this.minExponentDigits = 0;
                            while (++n15 < string.length() && string.charAt(n15) == n2) {
                                this.minExponentDigits = (byte)(this.minExponentDigits + 1);
                                ++n12;
                            }
                            if (n18 + n19 < 1 || this.minExponentDigits < 1) {
                                throw new IllegalArgumentException("Malformed exponential pattern \"" + string + '\"');
                            }
                            n22 = 2;
                            stringBuffer3 = stringBuffer2;
                            --n15;
                            continue block5;
                        }
                        n22 = 2;
                        stringBuffer3 = stringBuffer2;
                        --n15;
                        --n12;
                        continue block5;
                    }
                }
            }
            if (n19 == 0 && n18 > 0 && n16 >= 0) {
                n15 = n16;
                if (n15 == 0) {
                    ++n15;
                }
                n20 = n18 - n15;
                n18 = n15 - 1;
                n19 = 1;
            }
            if (n16 < 0 && n20 > 0 || n16 >= 0 && (n16 < n18 || n16 > n18 + n19) || n21 == 0 || bl4) {
                throw new IllegalArgumentException("Malformed pattern \"" + string + '\"');
            }
            if (i2 == 1) {
                this.posPrefixPattern = stringBuffer.toString();
                this.posSuffixPattern = stringBuffer2.toString();
                this.negPrefixPattern = this.posPrefixPattern;
                this.negSuffixPattern = this.posSuffixPattern;
                n15 = n18 + n19 + n20;
                n14 = n16 >= 0 ? n16 : n15;
                this.setMinimumIntegerDigits(n14 - n18);
                this.setMaximumIntegerDigits(this.useExponentialNotation ? n18 + this.getMinimumIntegerDigits() : Integer.MAX_VALUE);
                this.setMaximumFractionDigits(n16 >= 0 ? n15 - n16 : 0);
                this.setMinimumFractionDigits(n16 >= 0 ? n18 + n19 - n16 : 0);
                this.setGroupingUsed(n21 > 0);
                this.groupingSize = (byte)(n21 > 0 ? n21 : 0);
                this.multiplier = n17;
                this.setDecimalSeparatorAlwaysShown(n16 == 0 || n16 == n15);
                continue;
            }
            this.negPrefixPattern = stringBuffer.toString();
            this.negSuffixPattern = stringBuffer2.toString();
            bl3 = true;
        }
        if (string.length() == 0) {
            this.posSuffixPattern = "";
            this.posPrefixPattern = "";
            this.setMinimumIntegerDigits(0);
            this.setMaximumIntegerDigits(Integer.MAX_VALUE);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(Integer.MAX_VALUE);
        }
        if (!bl3 || this.negPrefixPattern.equals(this.posPrefixPattern) && this.negSuffixPattern.equals(this.posSuffixPattern)) {
            this.negSuffixPattern = this.posSuffixPattern;
            this.negPrefixPattern = "'-" + this.posPrefixPattern;
        }
        this.expandAffixes();
    }

    public void setMaximumIntegerDigits(int n2) {
        this.maximumIntegerDigits = Math.min(Math.max(0, n2), Integer.MAX_VALUE);
        super.setMaximumIntegerDigits(this.maximumIntegerDigits > 309 ? 309 : this.maximumIntegerDigits);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.minimumIntegerDigits = this.maximumIntegerDigits;
            super.setMinimumIntegerDigits(this.minimumIntegerDigits > 309 ? 309 : this.minimumIntegerDigits);
        }
    }

    public void setMinimumIntegerDigits(int n2) {
        this.minimumIntegerDigits = Math.min(Math.max(0, n2), Integer.MAX_VALUE);
        super.setMinimumIntegerDigits(this.minimumIntegerDigits > 309 ? 309 : this.minimumIntegerDigits);
        if (this.minimumIntegerDigits > this.maximumIntegerDigits) {
            this.maximumIntegerDigits = this.minimumIntegerDigits;
            super.setMaximumIntegerDigits(this.maximumIntegerDigits > 309 ? 309 : this.maximumIntegerDigits);
        }
    }

    public void setMaximumFractionDigits(int n2) {
        this.maximumFractionDigits = Math.min(Math.max(0, n2), Integer.MAX_VALUE);
        super.setMaximumFractionDigits(this.maximumFractionDigits > 340 ? 340 : this.maximumFractionDigits);
        if (this.minimumFractionDigits > this.maximumFractionDigits) {
            this.minimumFractionDigits = this.maximumFractionDigits;
            super.setMinimumFractionDigits(this.minimumFractionDigits > 340 ? 340 : this.minimumFractionDigits);
        }
    }

    public void setMinimumFractionDigits(int n2) {
        this.minimumFractionDigits = Math.min(Math.max(0, n2), Integer.MAX_VALUE);
        super.setMinimumFractionDigits(this.minimumFractionDigits > 340 ? 340 : this.minimumFractionDigits);
        if (this.minimumFractionDigits > this.maximumFractionDigits) {
            this.maximumFractionDigits = this.minimumFractionDigits;
            super.setMaximumFractionDigits(this.maximumFractionDigits > 340 ? 340 : this.maximumFractionDigits);
        }
    }

    public int getMaximumIntegerDigits() {
        return this.maximumIntegerDigits;
    }

    public int getMinimumIntegerDigits() {
        return this.minimumIntegerDigits;
    }

    public int getMaximumFractionDigits() {
        return this.maximumFractionDigits;
    }

    public int getMinimumFractionDigits() {
        return this.minimumFractionDigits;
    }

    public Currency getCurrency() {
        return this.symbols.getCurrency();
    }

    public void setCurrency(Currency currency) {
        if (currency != this.symbols.getCurrency()) {
            this.symbols.setCurrency(currency);
            if (this.isCurrencyFormat) {
                this.expandAffixes();
            }
        }
    }

    void adjustForCurrencyDefaultFractionDigits() {
        int n2;
        Currency currency = this.symbols.getCurrency();
        if (currency == null) {
            try {
                currency = Currency.getInstance(this.symbols.getInternationalCurrencySymbol());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (currency != null && (n2 = currency.getDefaultFractionDigits()) != -1) {
            int n3 = this.getMinimumFractionDigits();
            if (n3 == this.getMaximumFractionDigits()) {
                this.setMinimumFractionDigits(n2);
                this.setMaximumFractionDigits(n2);
            } else {
                this.setMinimumFractionDigits(Math.min(n2, n3));
                this.setMaximumFractionDigits(n2);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (super.getMaximumIntegerDigits() > 309 || super.getMaximumFractionDigits() > 340) {
            throw new InvalidObjectException("Digit count out of range");
        }
        if (this.serialVersionOnStream < 3) {
            this.setMaximumIntegerDigits(super.getMaximumIntegerDigits());
            this.setMinimumIntegerDigits(super.getMinimumIntegerDigits());
            this.setMaximumFractionDigits(super.getMaximumFractionDigits());
            this.setMinimumFractionDigits(super.getMinimumFractionDigits());
        }
        if (this.serialVersionOnStream < 1) {
            this.useExponentialNotation = false;
        }
        this.serialVersionOnStream = 3;
        this.digitList = new DigitList();
    }
}

