/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimal
extends Number
implements Comparable<BigDecimal> {
    private BigInteger intVal;
    private int scale = 0;
    private volatile transient int precision = 0;
    private static final long serialVersionUID = 6108874887143696463L;
    public static final BigDecimal ZERO = new BigDecimal(BigInteger.ZERO, 0);
    public static final BigDecimal ONE = new BigDecimal(BigInteger.ONE, 0);
    public static final BigDecimal TEN = new BigDecimal(BigInteger.TEN, 0);
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static BigInteger LONGMIN = null;
    private static BigInteger LONGMAX = null;
    private static BigInteger[] TENPOWERS = new BigInteger[]{BigInteger.ONE, BigInteger.valueOf(10L), BigInteger.valueOf(100L), BigInteger.valueOf(1000L), BigInteger.valueOf(10000L), BigInteger.valueOf(100000L), BigInteger.valueOf(1000000L), BigInteger.valueOf(10000000L), BigInteger.valueOf(100000000L), BigInteger.valueOf(1000000000L)};

    public BigDecimal(char[] cArray, int n2, int n3) {
        try {
            char[] cArray2;
            int n4;
            boolean bl2 = false;
            if (cArray[n2] == '-') {
                bl2 = true;
                ++n2;
                --n3;
            } else if (cArray[n2] == '+') {
                ++n2;
                --n3;
            }
            int n5 = -1;
            int n6 = n2;
            long l2 = 0L;
            if (n3 > cArray.length) {
                throw new NumberFormatException();
            }
            char[] cArray3 = new char[n3];
            while (n3 > 0) {
                char c2 = cArray[n2];
                if (c2 >= '0' && c2 <= '9' || Character.isDigit(c2)) {
                    cArray3[this.precision] = c2;
                    ++this.precision;
                } else if (c2 == '.') {
                    if (n5 >= 0) {
                        throw new NumberFormatException();
                    }
                    n5 = n2;
                } else {
                    if (c2 != 'e' && c2 != 'E') {
                        throw new NumberFormatException();
                    }
                    c2 = cArray[++n2];
                    --n3;
                    n4 = 0;
                    if (c2 == '-' || c2 == '+') {
                        n4 = c2 == '-' ? 1 : 0;
                        c2 = cArray[++n2];
                        --n3;
                    }
                    if (n3 <= 0 || n3 > 10) {
                        throw new NumberFormatException();
                    }
                    while (true) {
                        int n7;
                        if (c2 >= '0' && c2 <= '9') {
                            n7 = c2 - 48;
                        } else {
                            n7 = Character.digit(c2, 10);
                            if (n7 < 0) {
                                throw new NumberFormatException();
                            }
                        }
                        l2 = l2 * 10L + (long)n7;
                        if (n3 == 1) break;
                        c2 = cArray[++n2];
                        --n3;
                    }
                    if (n4 != 0) {
                        l2 = -l2;
                    }
                    if ((long)((int)l2) == l2) break;
                    throw new NumberFormatException();
                }
                ++n2;
                --n3;
            }
            if (this.precision == 0) {
                throw new NumberFormatException();
            }
            if (n5 >= 0) {
                this.scale = this.precision - (n5 - n6);
            }
            if (l2 != 0L) {
                try {
                    this.scale = this.checkScale(-l2 + (long)this.scale);
                }
                catch (ArithmeticException arithmeticException) {
                    throw new NumberFormatException("Scale out of range.");
                }
            }
            n4 = 0;
            while (cArray3[n4] == '0' && this.precision > 1) {
                --this.precision;
                ++n4;
            }
            if (!bl2) {
                cArray2 = new char[this.precision];
                System.arraycopy(cArray3, n4, cArray2, 0, this.precision);
            } else {
                cArray2 = new char[this.precision + 1];
                cArray2[0] = 45;
                System.arraycopy(cArray3, n4, cArray2, 1, this.precision);
            }
            this.intVal = new BigInteger(cArray2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new NumberFormatException();
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new NumberFormatException();
        }
    }

    public BigDecimal(char[] cArray, int n2, int n3, MathContext mathContext) {
        this(cArray, n2, n3);
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public BigDecimal(char[] cArray, MathContext mathContext) {
        this(cArray, 0, cArray.length, mathContext);
    }

    public BigDecimal(String string) {
        this(string.toCharArray(), 0, string.length());
    }

    public BigDecimal(String string, MathContext mathContext) {
        this(string.toCharArray(), 0, string.length());
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        long l2 = Double.doubleToLongBits(d2);
        int n2 = l2 >> 63 == 0L ? 1 : -1;
        int n3 = (int)(l2 >> 52 & 0x7FFL);
        long l3 = n3 == 0 ? (l2 & 0xFFFFFFFFFFFFFL) << 1 : l2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        n3 -= 1075;
        if (l3 == 0L) {
            this.intVal = BigInteger.ZERO;
            this.precision = 1;
            return;
        }
        while ((l3 & 1L) == 0L) {
            l3 >>= 1;
            ++n3;
        }
        this.intVal = BigInteger.valueOf((long)n2 * l3);
        if (n3 < 0) {
            this.intVal = this.intVal.multiply(BigInteger.valueOf(5L).pow(-n3));
            this.scale = -n3;
        } else if (n3 > 0) {
            this.intVal = this.intVal.multiply(BigInteger.valueOf(2L).pow(n3));
        }
    }

    public BigDecimal(double d2, MathContext mathContext) {
        this(d2);
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(BigInteger bigInteger) {
        this.intVal = bigInteger;
    }

    public BigDecimal(BigInteger bigInteger, MathContext mathContext) {
        this.intVal = bigInteger;
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(BigInteger bigInteger, int n2) {
        this.intVal = bigInteger;
        this.scale = n2;
    }

    public BigDecimal(BigInteger bigInteger, int n2, MathContext mathContext) {
        this.intVal = bigInteger;
        this.scale = n2;
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(int n2) {
        this.intVal = BigInteger.valueOf(n2);
    }

    public BigDecimal(int n2, MathContext mathContext) {
        this.intVal = BigInteger.valueOf(n2);
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public BigDecimal(long l2) {
        this.intVal = BigInteger.valueOf(l2);
    }

    public BigDecimal(long l2, MathContext mathContext) {
        this.intVal = BigInteger.valueOf(l2);
        if (mathContext.precision > 0) {
            this.roundThis(mathContext);
        }
    }

    public static BigDecimal valueOf(long l2, int n2) {
        if (n2 == 0) {
            if (l2 == 0L) {
                return ZERO;
            }
            if (l2 == 1L) {
                return ONE;
            }
            if (l2 == 10L) {
                return TEN;
            }
        }
        return new BigDecimal(BigInteger.valueOf(l2), n2);
    }

    public static BigDecimal valueOf(long l2) {
        return BigDecimal.valueOf(l2, 0);
    }

    public static BigDecimal valueOf(double d2) {
        return new BigDecimal(Double.toString(d2));
    }

    public BigDecimal add(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this, bigDecimal};
        BigDecimal.matchScale(bigDecimalArray);
        return new BigDecimal(bigDecimalArray[0].intVal.add(bigDecimalArray[1].intVal), bigDecimalArray[0].scale);
    }

    public BigDecimal add(BigDecimal bigDecimal, MathContext mathContext) {
        int n2;
        if (mathContext.precision == 0) {
            return this.add(bigDecimal);
        }
        BigDecimal bigDecimal2 = this;
        int n3 = bigDecimal2.signum() == 0 ? 1 : 0;
        int n4 = n2 = bigDecimal.signum() == 0 ? 1 : 0;
        if (n3 != 0 || n2 != 0) {
            int n5;
            BigDecimal bigDecimal3;
            int n6 = Math.max(bigDecimal2.scale(), bigDecimal.scale());
            if (n3 != 0 && n2 != 0) {
                return new BigDecimal(BigInteger.ZERO, n6);
            }
            BigDecimal bigDecimal4 = bigDecimal3 = n3 != 0 ? bigDecimal.doRound(mathContext) : bigDecimal2.doRound(mathContext);
            if (bigDecimal3.scale() == n6) {
                return bigDecimal3;
            }
            if (bigDecimal3.scale() > n6) {
                return bigDecimal3.stripZerosToMatchScale(n6);
            }
            int n7 = mathContext.precision - bigDecimal3.precision();
            if (n7 >= (n5 = n6 - bigDecimal3.scale())) {
                return bigDecimal3.setScale(n6);
            }
            return bigDecimal3.setScale(bigDecimal3.scale() + n7);
        }
        n3 = this.checkScale((long)bigDecimal2.scale - (long)bigDecimal.scale);
        if (n3 != 0) {
            if (n3 < 0) {
                n2 = bigDecimal2.scale - bigDecimal2.precision + mathContext.precision;
                if (bigDecimal.scale - bigDecimal.precision() > n2 + 1) {
                    bigDecimal = BigDecimal.valueOf(bigDecimal.signum(), n2 + 3);
                }
            } else {
                n2 = bigDecimal.scale - bigDecimal.precision + mathContext.precision;
                if (bigDecimal2.scale - bigDecimal2.precision() > n2 + 1) {
                    bigDecimal2 = BigDecimal.valueOf(bigDecimal2.signum(), n2 + 3);
                }
            }
            BigDecimal[] bigDecimalArray = new BigDecimal[]{bigDecimal2, bigDecimal};
            BigDecimal.matchScale(bigDecimalArray);
            bigDecimal2 = bigDecimalArray[0];
            bigDecimal = bigDecimalArray[1];
        }
        return new BigDecimal(bigDecimal2.intVal.add(bigDecimal.intVal), bigDecimal2.scale).doRound(mathContext);
    }

    public BigDecimal subtract(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this, bigDecimal};
        BigDecimal.matchScale(bigDecimalArray);
        return new BigDecimal(bigDecimalArray[0].intVal.subtract(bigDecimalArray[1].intVal), bigDecimalArray[0].scale);
    }

    public BigDecimal subtract(BigDecimal bigDecimal, MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this.subtract(bigDecimal);
        }
        BigDecimal bigDecimal2 = new BigDecimal(bigDecimal.intVal.negate(), bigDecimal.scale);
        bigDecimal2.precision = bigDecimal.precision;
        return this.add(bigDecimal2, mathContext);
    }

    public BigDecimal multiply(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = new BigDecimal(this.intVal.multiply(bigDecimal.intVal), 0);
        bigDecimal2.scale = this.checkScale((long)this.scale + (long)bigDecimal.scale);
        return bigDecimal2;
    }

    public BigDecimal multiply(BigDecimal bigDecimal, MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this.multiply(bigDecimal);
        }
        BigDecimal bigDecimal2 = this;
        return bigDecimal2.multiply(bigDecimal).doRound(mathContext);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n2, int n3) {
        int n4;
        BigDecimal bigDecimal2;
        if (n3 < 0 || n3 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        if (this.checkScale((long)n2 + (long)bigDecimal.scale) >= this.scale) {
            bigDecimal2 = this.setScale(n2 + bigDecimal.scale);
        } else {
            bigDecimal2 = this;
            bigDecimal = bigDecimal.setScale(this.checkScale((long)this.scale - (long)n2));
        }
        BigInteger[] bigIntegerArray = bigDecimal2.intVal.divideAndRemainder(bigDecimal.intVal);
        BigInteger bigInteger = bigIntegerArray[0];
        BigInteger bigInteger2 = bigIntegerArray[1];
        if (bigInteger2.signum() == 0) {
            return new BigDecimal(bigInteger, n2);
        }
        if (n3 == 7) {
            throw new ArithmeticException("Rounding necessary");
        }
        int n5 = bigDecimal2.signum() * bigDecimal.signum();
        boolean bl2 = n3 == 0 ? true : (n3 == 1 ? false : (n3 == 2 ? n5 > 0 : (n3 == 3 ? n5 < 0 : ((n4 = bigInteger2.add(bigInteger2).abs().compareTo(bigDecimal.intVal.abs())) < 0 ? false : (n4 > 0 ? true : (n3 == 4 ? true : (n3 == 5 ? false : bigInteger.testBit(0))))))));
        return bl2 ? new BigDecimal(bigInteger.add(BigInteger.valueOf(n5)), n2) : new BigDecimal(bigInteger, n2);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n2, RoundingMode roundingMode) {
        return this.divide(bigDecimal, n2, roundingMode.oldMode);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n2) {
        return this.divide(bigDecimal, this.scale, n2);
    }

    public BigDecimal divide(BigDecimal bigDecimal, RoundingMode roundingMode) {
        return this.divide(bigDecimal, this.scale, roundingMode.oldMode);
    }

    public BigDecimal divide(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2;
        if (bigDecimal.intVal.signum() == 0) {
            if (this.intVal.signum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        int n2 = (int)Math.max(Math.min((long)this.scale() - (long)bigDecimal.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
        if (this.intVal.signum() == 0) {
            return BigDecimal.valueOf(0L, n2);
        }
        MathContext mathContext = new MathContext((int)Math.min((long)this.precision() + (long)Math.ceil(10.0 * (double)bigDecimal.precision() / 3.0), Integer.MAX_VALUE), RoundingMode.UNNECESSARY);
        try {
            bigDecimal2 = this.divide(bigDecimal, mathContext);
        }
        catch (ArithmeticException arithmeticException) {
            throw new ArithmeticException("Non-terminating decimal expansion; no exact representable decimal result.");
        }
        int n3 = bigDecimal2.scale();
        if (n2 > n3) {
            return bigDecimal2.setScale(n2);
        }
        return bigDecimal2;
    }

    public BigDecimal divide(BigDecimal bigDecimal, MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this.divide(bigDecimal);
        }
        BigDecimal bigDecimal2 = this;
        BigDecimal bigDecimal3 = bigDecimal;
        long l2 = (long)bigDecimal2.scale() - (long)bigDecimal3.scale();
        if (bigDecimal3.intVal.signum() == 0) {
            if (bigDecimal2.intVal.signum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        if (bigDecimal2.intVal.signum() == 0) {
            return new BigDecimal(BigInteger.ZERO, (int)Math.max(Math.min(l2, Integer.MAX_VALUE), Integer.MIN_VALUE));
        }
        BigDecimal bigDecimal4 = new BigDecimal(bigDecimal2.intVal.abs(), bigDecimal2.precision());
        BigDecimal bigDecimal5 = new BigDecimal(bigDecimal3.intVal.abs(), bigDecimal3.precision());
        if ((mathContext.roundingMode == RoundingMode.CEILING || mathContext.roundingMode == RoundingMode.FLOOR) && bigDecimal4.signum() != bigDecimal2.signum() ^ bigDecimal5.signum() != bigDecimal3.signum()) {
            mathContext = new MathContext(mathContext.precision, mathContext.roundingMode == RoundingMode.CEILING ? RoundingMode.FLOOR : RoundingMode.CEILING);
        }
        if (bigDecimal4.compareTo(bigDecimal5) > 0) {
            --bigDecimal5.scale;
        }
        BigDecimal bigDecimal6 = bigDecimal4.divide(bigDecimal5, mathContext.precision, mathContext.roundingMode.oldMode);
        bigDecimal6.scale = this.checkScale((long)bigDecimal5.scale - (long)bigDecimal4.scale - (long)(bigDecimal3.scale - bigDecimal2.scale) + (long)mathContext.precision);
        if (bigDecimal2.intVal.signum() != bigDecimal3.intVal.signum()) {
            bigDecimal6 = bigDecimal6.negate();
        }
        if ((bigDecimal6 = bigDecimal6.doRound(mathContext)).multiply(bigDecimal).compareTo(this) == 0) {
            return bigDecimal6.stripZerosToMatchScale(l2);
        }
        return bigDecimal6;
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal) {
        int n2 = (int)Math.max(Math.min((long)this.scale() - (long)bigDecimal.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
        if (this.abs().compareTo(bigDecimal.abs()) < 0) {
            return BigDecimal.valueOf(0L, n2);
        }
        if (this.signum() == 0 && bigDecimal.signum() != 0) {
            return this.setScale(n2);
        }
        int n3 = (int)Math.min((long)this.precision() + (long)Math.ceil(10.0 * (double)bigDecimal.precision() / 3.0) + Math.abs((long)this.scale() - (long)bigDecimal.scale()) + 2L, Integer.MAX_VALUE);
        BigDecimal bigDecimal2 = this.divide(bigDecimal, new MathContext(n3, RoundingMode.DOWN));
        if (bigDecimal2.scale > 0) {
            bigDecimal2 = bigDecimal2.setScale(0, RoundingMode.DOWN).stripZerosToMatchScale(n2);
        }
        if (bigDecimal2.scale < n2) {
            bigDecimal2 = bigDecimal2.setScale(n2);
        }
        return bigDecimal2;
    }

    public BigDecimal divideToIntegralValue(BigDecimal bigDecimal, MathContext mathContext) {
        int n2;
        if (mathContext.precision == 0 || this.abs().compareTo(bigDecimal.abs()) < 0) {
            return this.divideToIntegralValue(bigDecimal);
        }
        int n3 = (int)Math.max(Math.min((long)this.scale() - (long)bigDecimal.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
        BigDecimal bigDecimal2 = this.divide(bigDecimal, new MathContext(mathContext.precision, RoundingMode.DOWN));
        int n4 = bigDecimal2.scale();
        if (bigDecimal2.scale() < 0) {
            BigDecimal bigDecimal3 = bigDecimal2.multiply(bigDecimal);
            if (this.subtract(bigDecimal3).abs().compareTo(bigDecimal.abs()) > 0) {
                throw new ArithmeticException("Division impossible");
            }
        } else if (bigDecimal2.scale() > 0) {
            bigDecimal2 = bigDecimal2.setScale(0, RoundingMode.DOWN);
        }
        if (n3 > bigDecimal2.scale() && (n2 = mathContext.precision - bigDecimal2.precision()) > 0) {
            return bigDecimal2.setScale(bigDecimal2.scale() + Math.min(n2, n3 - bigDecimal2.scale));
        }
        return bigDecimal2.stripZerosToMatchScale(n3);
    }

    public BigDecimal remainder(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray = this.divideAndRemainder(bigDecimal);
        return bigDecimalArray[1];
    }

    public BigDecimal remainder(BigDecimal bigDecimal, MathContext mathContext) {
        BigDecimal[] bigDecimalArray = this.divideAndRemainder(bigDecimal, mathContext);
        return bigDecimalArray[1];
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal) {
        BigDecimal[] bigDecimalArray;
        bigDecimalArray = new BigDecimal[]{this.divideToIntegralValue(bigDecimal), this.subtract(bigDecimalArray[0].multiply(bigDecimal))};
        return bigDecimalArray;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal bigDecimal, MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this.divideAndRemainder(bigDecimal);
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[2];
        BigDecimal bigDecimal2 = this;
        bigDecimalArray[0] = bigDecimal2.divideToIntegralValue(bigDecimal, mathContext);
        bigDecimalArray[1] = bigDecimal2.subtract(bigDecimalArray[0].multiply(bigDecimal));
        return bigDecimalArray;
    }

    public BigDecimal pow(int n2) {
        if (n2 < 0 || n2 > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        int n3 = this.checkScale((long)this.scale * (long)n2);
        return new BigDecimal(this.intVal.pow(n2), n3);
    }

    public BigDecimal pow(int n2, MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this.pow(n2);
        }
        if (n2 < -999999999 || n2 > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        if (n2 == 0) {
            return ONE;
        }
        BigDecimal bigDecimal = this;
        MathContext mathContext2 = mathContext;
        int n3 = Math.abs(n2);
        if (mathContext.precision > 0) {
            int n4 = this.intLength(n3);
            if (n4 > mathContext.precision) {
                throw new ArithmeticException("Invalid operation");
            }
            mathContext2 = new MathContext(mathContext.precision + n4 + 1, mathContext.roundingMode);
        }
        BigDecimal bigDecimal2 = ONE;
        boolean bl2 = false;
        int n5 = 1;
        while (true) {
            if ((n3 += n3) < 0) {
                bl2 = true;
                bigDecimal2 = bigDecimal2.multiply(bigDecimal, mathContext2);
            }
            if (n5 == 31) break;
            if (bl2) {
                bigDecimal2 = bigDecimal2.multiply(bigDecimal2, mathContext2);
            }
            ++n5;
        }
        if (n2 < 0) {
            bigDecimal2 = ONE.divide(bigDecimal2, mathContext2);
        }
        return bigDecimal2.doRound(mathContext);
    }

    public BigDecimal abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public BigDecimal abs(MathContext mathContext) {
        return this.signum() < 0 ? this.negate(mathContext) : this.plus(mathContext);
    }

    public BigDecimal negate() {
        BigDecimal bigDecimal = new BigDecimal(this.intVal.negate(), this.scale);
        bigDecimal.precision = this.precision;
        return bigDecimal;
    }

    public BigDecimal negate(MathContext mathContext) {
        return this.plus(mathContext).negate();
    }

    public BigDecimal plus() {
        return this;
    }

    public BigDecimal plus(MathContext mathContext) {
        if (mathContext.precision == 0) {
            return this;
        }
        BigDecimal bigDecimal = this;
        return bigDecimal.doRound(mathContext);
    }

    public int signum() {
        return this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public int precision() {
        int n2 = this.precision;
        if (n2 == 0) {
            this.precision = n2 = this.digitLength();
        }
        return n2;
    }

    public BigInteger unscaledValue() {
        return this.intVal;
    }

    public BigDecimal round(MathContext mathContext) {
        return this.plus(mathContext);
    }

    public BigDecimal setScale(int n2, RoundingMode roundingMode) {
        return this.setScale(n2, roundingMode.oldMode);
    }

    public BigDecimal setScale(int n2, int n3) {
        if (n3 < 0 || n3 > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        if (n2 == this.scale) {
            return this;
        }
        if (this.signum() == 0) {
            return new BigDecimal(BigInteger.ZERO, n2);
        }
        if (n2 > this.scale) {
            int n4 = this.checkScale((long)n2 - (long)this.scale);
            BigDecimal bigDecimal = new BigDecimal(this.intVal.multiply(BigDecimal.tenToThe(n4)), n2);
            if (this.precision > 0) {
                bigDecimal.precision = this.precision + n2 - this.scale;
            }
            return bigDecimal;
        }
        return this.divide(ONE, n2, n3);
    }

    public BigDecimal setScale(int n2) {
        return this.setScale(n2, 7);
    }

    public BigDecimal movePointLeft(int n2) {
        BigDecimal bigDecimal = new BigDecimal(this.intVal, this.checkScale((long)this.scale + (long)n2));
        return bigDecimal.scale < 0 ? bigDecimal.setScale(0) : bigDecimal;
    }

    public BigDecimal movePointRight(int n2) {
        BigDecimal bigDecimal = new BigDecimal(this.intVal, this.checkScale((long)this.scale - (long)n2));
        return bigDecimal.scale < 0 ? bigDecimal.setScale(0) : bigDecimal;
    }

    public BigDecimal scaleByPowerOfTen(int n2) {
        BigDecimal bigDecimal = new BigDecimal(this.intVal, this.checkScale((long)this.scale - (long)n2));
        bigDecimal.precision = this.precision;
        return bigDecimal;
    }

    public BigDecimal stripTrailingZeros() {
        return new BigDecimal(this.intVal, this.scale).stripZerosToMatchScale(Long.MIN_VALUE);
    }

    @Override
    public int compareTo(BigDecimal bigDecimal) {
        int n2;
        int n3 = this.signum() - bigDecimal.signum();
        if (n3 != 0) {
            return n3 > 0 ? 1 : -1;
        }
        int n4 = this.precision() - this.scale;
        if (n4 < (n2 = bigDecimal.precision() - bigDecimal.scale)) {
            return -this.signum();
        }
        if (n4 > n2) {
            return this.signum();
        }
        BigDecimal[] bigDecimalArray = new BigDecimal[]{this, bigDecimal};
        BigDecimal.matchScale(bigDecimalArray);
        return bigDecimalArray[0].intVal.compareTo(bigDecimalArray[1].intVal);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigDecimal)) {
            return false;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        return this.scale == bigDecimal.scale && this.intVal.equals(bigDecimal.intVal);
    }

    public BigDecimal min(BigDecimal bigDecimal) {
        return this.compareTo(bigDecimal) <= 0 ? this : bigDecimal;
    }

    public BigDecimal max(BigDecimal bigDecimal) {
        return this.compareTo(bigDecimal) >= 0 ? this : bigDecimal;
    }

    public int hashCode() {
        return 31 * this.intVal.hashCode() + this.scale;
    }

    public String toString() {
        return new String(this.layoutChars(true));
    }

    public String toEngineeringString() {
        return new String(this.layoutChars(false));
    }

    public String toPlainString() {
        BigDecimal bigDecimal = this;
        if (bigDecimal.scale < 0) {
            bigDecimal = bigDecimal.setScale(0);
        }
        if (bigDecimal.scale == 0) {
            return bigDecimal.intVal.toString();
        }
        return bigDecimal.getValueString(bigDecimal.signum(), bigDecimal.intVal.abs().toString(), bigDecimal.scale);
    }

    private String getValueString(int n2, String string, int n3) {
        StringBuilder stringBuilder;
        int n4 = string.length() - n3;
        if (n4 == 0) {
            return (n2 < 0 ? "-0." : "0.") + string;
        }
        if (n4 > 0) {
            stringBuilder = new StringBuilder(string);
            stringBuilder.insert(n4, '.');
            if (n2 < 0) {
                stringBuilder.insert(0, '-');
            }
        } else {
            stringBuilder = new StringBuilder(3 - n4 + string.length());
            stringBuilder.append(n2 < 0 ? "-0." : "0.");
            for (int i2 = 0; i2 < -n4; ++i2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    char[] toCharArray() {
        return this.layoutChars(true);
    }

    public BigInteger toBigInteger() {
        return this.setScale((int)0, (int)1).intVal;
    }

    public BigInteger toBigIntegerExact() {
        return this.setScale((int)0, (int)7).intVal;
    }

    @Override
    public long longValue() {
        return this.toBigInteger().longValue();
    }

    public long longValueExact() {
        if (this.precision() - this.scale > 19) {
            throw new ArithmeticException("Overflow");
        }
        if (this.intVal.signum() == 0) {
            return 0L;
        }
        if (this.precision() - this.scale <= 0) {
            throw new ArithmeticException("Rounding necessary");
        }
        BigDecimal bigDecimal = this.setScale(0, 7);
        if (bigDecimal.precision() >= 19) {
            if (LONGMIN == null) {
                LONGMIN = BigInteger.valueOf(Long.MIN_VALUE);
                LONGMAX = BigInteger.valueOf(Long.MAX_VALUE);
            }
            if (bigDecimal.intVal.compareTo(LONGMIN) < 0 || bigDecimal.intVal.compareTo(LONGMAX) > 0) {
                throw new ArithmeticException("Overflow");
            }
        }
        return bigDecimal.intVal.longValue();
    }

    @Override
    public int intValue() {
        return this.toBigInteger().intValue();
    }

    public int intValueExact() {
        long l2 = this.longValueExact();
        if ((long)((int)l2) != l2) {
            throw new ArithmeticException("Overflow");
        }
        return (int)l2;
    }

    public short shortValueExact() {
        long l2 = this.longValueExact();
        if ((long)((short)l2) != l2) {
            throw new ArithmeticException("Overflow");
        }
        return (short)l2;
    }

    public byte byteValueExact() {
        long l2 = this.longValueExact();
        if ((long)((byte)l2) != l2) {
            throw new ArithmeticException("Overflow");
        }
        return (byte)l2;
    }

    @Override
    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    @Override
    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    public BigDecimal ulp() {
        return new BigDecimal(BigInteger.ONE, this.scale());
    }

    private char[] layoutChars(boolean bl2) {
        StringBuilder stringBuilder;
        block18: {
            long l2;
            block20: {
                int n2;
                char[] cArray;
                block21: {
                    block19: {
                        block17: {
                            if (this.scale == 0) {
                                return this.intVal.toString().toCharArray();
                            }
                            cArray = this.intVal.abs().toString().toCharArray();
                            stringBuilder = new StringBuilder(cArray.length + 14);
                            if (this.intVal.signum() < 0) {
                                stringBuilder.append('-');
                            }
                            l2 = -((long)this.scale) + (long)(cArray.length - 1);
                            if (this.scale < 0 || l2 < -6L) break block17;
                            n2 = this.scale - cArray.length;
                            if (n2 >= 0) {
                                stringBuilder.append('0');
                                stringBuilder.append('.');
                                while (n2 > 0) {
                                    stringBuilder.append('0');
                                    --n2;
                                }
                                stringBuilder.append(cArray);
                            } else {
                                stringBuilder.append(cArray, 0, -n2);
                                stringBuilder.append('.');
                                stringBuilder.append(cArray, -n2, this.scale);
                            }
                            break block18;
                        }
                        if (!bl2) break block19;
                        stringBuilder.append(cArray[0]);
                        if (cArray.length > 1) {
                            stringBuilder.append('.');
                            stringBuilder.append(cArray, 1, cArray.length - 1);
                        }
                        break block20;
                    }
                    n2 = (int)(l2 % 3L);
                    if (n2 < 0) {
                        n2 += 3;
                    }
                    l2 -= (long)n2;
                    ++n2;
                    if (this.intVal.signum() != 0) break block21;
                    switch (n2) {
                        case 1: {
                            stringBuilder.append('0');
                            break block20;
                        }
                        case 2: {
                            stringBuilder.append("0.00");
                            l2 += 3L;
                            break block20;
                        }
                        case 3: {
                            stringBuilder.append("0.0");
                            l2 += 3L;
                            break block20;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected sig value " + n2));
                        }
                    }
                }
                if (n2 >= cArray.length) {
                    stringBuilder.append(cArray, 0, cArray.length);
                    for (int i2 = n2 - cArray.length; i2 > 0; --i2) {
                        stringBuilder.append('0');
                    }
                } else {
                    stringBuilder.append(cArray, 0, n2);
                    stringBuilder.append('.');
                    stringBuilder.append(cArray, n2, cArray.length - n2);
                }
            }
            if (l2 != 0L) {
                stringBuilder.append('E');
                if (l2 > 0L) {
                    stringBuilder.append('+');
                }
                stringBuilder.append(l2);
            }
        }
        char[] cArray = new char[stringBuilder.length()];
        stringBuilder.getChars(0, cArray.length, cArray, 0);
        return cArray;
    }

    private static BigInteger tenToThe(int n2) {
        if (n2 < TENPOWERS.length) {
            return TENPOWERS[n2];
        }
        char[] cArray = new char[n2 + 1];
        cArray[0] = 49;
        for (int i2 = 1; i2 <= n2; ++i2) {
            cArray[i2] = 48;
        }
        return new BigInteger(cArray);
    }

    private static void matchScale(BigDecimal[] bigDecimalArray) {
        if (bigDecimalArray[0].scale < bigDecimalArray[1].scale) {
            bigDecimalArray[0] = bigDecimalArray[0].setScale(bigDecimalArray[1].scale);
        } else if (bigDecimalArray[1].scale < bigDecimalArray[0].scale) {
            bigDecimalArray[1] = bigDecimalArray[1].setScale(bigDecimalArray[0].scale);
        }
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.intVal == null) {
            String string = "BigDecimal: null intVal in stream";
            throw new StreamCorruptedException(string);
        }
    }

    private int digitLength() {
        if (this.intVal.signum() == 0) {
            return 1;
        }
        BigInteger bigInteger = this.intVal;
        int n2 = 0;
        while (bigInteger.mag.length > 1) {
            bigInteger = bigInteger.divide(TENPOWERS[9]);
            n2 += 9;
            if (bigInteger.signum() != 0) continue;
            return n2;
        }
        return n2 += this.intLength(bigInteger.mag[0]);
    }

    private int intLength(int n2) {
        int n3 = n2 < 0 ? 10 : (n2 < 10000 ? (n2 < 100 ? (n2 < 10 ? 1 : 2) : (n2 < 1000 ? 3 : 4)) : (n2 < 1000000 ? (n2 < 100000 ? 5 : 6) : (n2 < 100000000 ? (n2 < 10000000 ? 7 : 8) : (n2 < 1000000000 ? 9 : 10))));
        return n3;
    }

    private BigDecimal stripZerosToMatchScale(long l2) {
        BigInteger[] bigIntegerArray;
        while (this.intVal.abs().compareTo(BigInteger.TEN) >= 0 && (long)this.scale > l2 && !this.intVal.testBit(0) && (bigIntegerArray = this.intVal.divideAndRemainder(BigInteger.TEN))[1].signum() == 0) {
            this.intVal = bigIntegerArray[0];
            this.scale = this.checkScale((long)this.scale - 1L);
            if (this.precision <= 0) continue;
            --this.precision;
        }
        return this;
    }

    private int checkScale(long l2) {
        if ((long)((int)l2) != l2) {
            if (this.intVal != null && this.signum() != 0 || this.intVal == null) {
                if (l2 > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Underflow");
                }
                if (l2 < Integer.MIN_VALUE) {
                    throw new ArithmeticException("Overflow");
                }
            } else {
                return l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            }
        }
        return (int)l2;
    }

    private BigDecimal roundOp(MathContext mathContext) {
        BigDecimal bigDecimal = this.doRound(mathContext);
        return bigDecimal;
    }

    private void roundThis(MathContext mathContext) {
        BigDecimal bigDecimal = this.doRound(mathContext);
        if (bigDecimal == this) {
            return;
        }
        this.intVal = bigDecimal.intVal;
        this.scale = bigDecimal.scale;
        this.precision = bigDecimal.precision;
    }

    private BigDecimal doRound(MathContext mathContext) {
        int n2;
        if (this.precision == 0) {
            if (mathContext.roundingMax != null && this.intVal.compareTo(mathContext.roundingMax) < 0 && this.intVal.compareTo(mathContext.roundingMin) > 0) {
                return this;
            }
            this.precision();
        }
        if ((n2 = this.precision - mathContext.precision) <= 0) {
            return this;
        }
        BigDecimal bigDecimal = this.dropDigits(mathContext, n2);
        return bigDecimal.doRound(mathContext);
    }

    private BigDecimal dropDigits(MathContext mathContext, int n2) {
        BigDecimal bigDecimal = new BigDecimal(BigDecimal.tenToThe(n2), 0);
        BigDecimal bigDecimal2 = this.divide(bigDecimal, this.scale, mathContext.roundingMode.oldMode);
        bigDecimal2.scale -= n2;
        return bigDecimal2;
    }
}

