/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.CheckboxPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checkbox
extends Component
implements ItemSelectable,
Accessible {
    String label;
    boolean state;
    CheckboxGroup group;
    transient ItemListener itemListener;
    private static final String base = "checkbox";
    private static int nameCounter;
    private static final long serialVersionUID = 7270714317450821763L;
    private int checkboxSerializedDataVersion = 1;

    void setStateInternal(boolean bl2) {
        this.state = bl2;
        CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
        if (checkboxPeer != null) {
            checkboxPeer.setState(bl2);
        }
    }

    public Checkbox() throws HeadlessException {
        this("", false, null);
    }

    public Checkbox(String string) throws HeadlessException {
        this(string, false, null);
    }

    public Checkbox(String string, boolean bl2) throws HeadlessException {
        this(string, bl2, null);
    }

    public Checkbox(String string, boolean bl2, CheckboxGroup checkboxGroup) throws HeadlessException {
        GraphicsEnvironment.checkHeadless();
        this.label = string;
        this.state = bl2;
        this.group = checkboxGroup;
        if (bl2 && checkboxGroup != null) {
            checkboxGroup.setSelectedCheckbox(this);
        }
    }

    public Checkbox(String string, CheckboxGroup checkboxGroup, boolean bl2) throws HeadlessException {
        this(string, bl2, checkboxGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<? extends Object> clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createCheckbox(this);
            }
            super.addNotify();
        }
    }

    public String getLabel() {
        return this.label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLabel(String string) {
        boolean bl2 = false;
        Checkbox checkbox = this;
        synchronized (checkbox) {
            if (!(string == this.label || this.label != null && this.label.equals(string))) {
                this.label = string;
                CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
                if (checkboxPeer != null) {
                    checkboxPeer.setLabel(string);
                }
                bl2 = true;
            }
        }
        if (bl2 && this.valid) {
            this.invalidate();
        }
    }

    public boolean getState() {
        return this.state;
    }

    public void setState(boolean bl2) {
        CheckboxGroup checkboxGroup = this.group;
        if (checkboxGroup != null) {
            if (bl2) {
                checkboxGroup.setSelectedCheckbox(this);
            } else if (checkboxGroup.getSelectedCheckbox() == this) {
                bl2 = true;
            }
        }
        this.setStateInternal(bl2);
    }

    @Override
    public Object[] getSelectedObjects() {
        if (this.state) {
            Object[] objectArray = new Object[]{this.label};
            return objectArray;
        }
        return null;
    }

    public CheckboxGroup getCheckboxGroup() {
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCheckboxGroup(CheckboxGroup checkboxGroup) {
        boolean bl2;
        CheckboxGroup checkboxGroup2;
        if (this.group == checkboxGroup) {
            return;
        }
        Checkbox checkbox = this;
        synchronized (checkbox) {
            checkboxGroup2 = this.group;
            bl2 = this.getState();
            this.group = checkboxGroup;
            CheckboxPeer checkboxPeer = (CheckboxPeer)this.peer;
            if (checkboxPeer != null) {
                checkboxPeer.setCheckboxGroup(checkboxGroup);
            }
            if (this.group != null && this.getState()) {
                if (this.group.getSelectedCheckbox() != null) {
                    this.setState(false);
                } else {
                    this.group.setSelectedCheckbox(this);
                }
            }
        }
        if (checkboxGroup2 != null && bl2) {
            checkboxGroup2.setSelectedCheckbox(null);
        }
    }

    @Override
    public synchronized void addItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
        this.newEventsOnly = true;
    }

    @Override
    public synchronized void removeItemListener(ItemListener itemListener) {
        if (itemListener == null) {
            return;
        }
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public synchronized ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(ItemListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        ItemListener itemListener = null;
        if (clazz != ItemListener.class) {
            return super.getListeners(clazz);
        }
        itemListener = this.itemListener;
        return AWTEventMulticaster.getListeners((EventListener)itemListener, clazz);
    }

    @Override
    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 701) {
            return (this.eventMask & 0x200L) != 0L || this.itemListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    @Override
    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processItemEvent(ItemEvent itemEvent) {
        ItemListener itemListener = this.itemListener;
        if (itemListener != null) {
            itemListener.itemStateChanged(itemEvent);
        }
    }

    @Override
    protected String paramString() {
        String string = super.paramString();
        String string2 = this.label;
        if (string2 != null) {
            string = string + ",label=" + string2;
        }
        return string + ",state=" + this.state;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "itemL", this.itemListener);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        Object object;
        GraphicsEnvironment.checkHeadless();
        objectInputStream.defaultReadObject();
        while (null != (object = objectInputStream.readObject())) {
            String string = ((String)object).intern();
            if ("itemL" == string) {
                this.addItemListener((ItemListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    private static native void initIDs();

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTCheckbox();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            Checkbox.initIDs();
        }
        nameCounter = 0;
    }

    protected class AccessibleAWTCheckbox
    extends Component.AccessibleAWTComponent
    implements ItemListener,
    AccessibleAction,
    AccessibleValue {
        private static final long serialVersionUID = 7881579233144754107L;

        public AccessibleAWTCheckbox() {
            super(Checkbox.this);
            Checkbox.this.addItemListener(this);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            Checkbox checkbox = (Checkbox)itemEvent.getSource();
            if (Checkbox.this.accessibleContext != null) {
                if (checkbox.getState()) {
                    Checkbox.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.CHECKED);
                } else {
                    Checkbox.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.CHECKED, null);
                }
            }
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public String getAccessibleActionDescription(int n2) {
            return null;
        }

        public boolean doAccessibleAction(int n2) {
            return false;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number number) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (Checkbox.this.getState()) {
                accessibleStateSet.add(AccessibleState.CHECKED);
            }
            return accessibleStateSet;
        }
    }
}

