/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.internal.BaseRow;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;

public class Row
extends BaseRow
implements Serializable,
Cloneable {
    private Object[] currentVals;
    private BitSet colsChanged;
    private boolean deleted;
    private boolean updated;
    private boolean inserted;
    private int numCols;

    public Row(int n2) {
        this.origVals = new Object[n2];
        this.currentVals = new Object[n2];
        this.colsChanged = new BitSet(n2);
        this.numCols = n2;
    }

    public Row(int n2, Object[] objectArray) {
        this.origVals = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.origVals[i2] = objectArray[i2];
        }
        this.currentVals = new Object[n2];
        this.colsChanged = new BitSet(n2);
        this.numCols = n2;
    }

    public void initColumnObject(int n2, Object object) {
        this.origVals[n2 - 1] = object;
    }

    public void setColumnObject(int n2, Object object) {
        this.currentVals[n2 - 1] = object;
        this.setColUpdated(n2 - 1);
    }

    public Object getColumnObject(int n2) throws SQLException {
        if (this.getColUpdated(n2 - 1)) {
            return this.currentVals[n2 - 1];
        }
        return this.origVals[n2 - 1];
    }

    public boolean getColUpdated(int n2) {
        return this.colsChanged.get(n2);
    }

    public void setDeleted() {
        this.deleted = true;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void clearDeleted() {
        this.deleted = false;
    }

    public void setInserted() {
        this.inserted = true;
    }

    public boolean getInserted() {
        return this.inserted;
    }

    public void clearInserted() {
        this.inserted = false;
    }

    public boolean getUpdated() {
        return this.updated;
    }

    public void setUpdated() {
        for (int i2 = 0; i2 < this.numCols; ++i2) {
            if (!this.getColUpdated(i2)) continue;
            this.updated = true;
            return;
        }
    }

    private void setColUpdated(int n2) {
        this.colsChanged.set(n2);
    }

    public void clearUpdated() {
        this.updated = false;
        for (int i2 = 0; i2 < this.numCols; ++i2) {
            this.currentVals[i2] = null;
            this.colsChanged.clear(i2);
        }
    }

    public void moveCurrentToOrig() {
        for (int i2 = 0; i2 < this.numCols; ++i2) {
            if (!this.getColUpdated(i2)) continue;
            this.origVals[i2] = this.currentVals[i2];
            this.currentVals[i2] = null;
            this.colsChanged.clear(i2);
        }
        this.updated = false;
    }

    public BaseRow getCurrentRow() {
        return null;
    }
}

