/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp;

import com.sun.org.apache.xerces.internal.jaxp.DefaultValidationErrorHandler;
import com.sun.org.apache.xerces.internal.jaxp.JAXPConstants;
import com.sun.org.apache.xerces.internal.parsers.AbstractSAXParser;
import com.sun.org.apache.xerces.internal.parsers.JAXPConfiguration;
import com.sun.org.apache.xerces.internal.util.SAXMessageFormatter;
import com.sun.org.apache.xerces.internal.util.SecurityManager;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class SAXParserImpl
extends SAXParser
implements JAXPConstants {
    private final JAXPConfiguration parserConfiguration;
    private final AbstractSAXParser xmlReader;
    private String schemaLanguage = null;
    private final Schema grammar;
    private final SecurityManager secureProcessing;
    private boolean isXIncludeAware;
    private boolean enableSecureProcessing = true;
    private Hashtable features;
    private SAXParserFactory spf;
    private Hashtable parserFeatures = new Hashtable();

    public boolean isXIncludeAware() {
        return this.isXIncludeAware;
    }

    SAXParserImpl(SAXParserFactory sAXParserFactory, Hashtable hashtable) throws SAXException {
        this.spf = sAXParserFactory;
        this.features = hashtable;
        this.secureProcessing = new SecurityManager();
        this.grammar = this.spf.getSchema();
        this.parserConfiguration = new JAXPConfiguration(this.grammar);
        this.xmlReader = new com.sun.org.apache.xerces.internal.parsers.SAXParser(this.parserConfiguration);
        this.init();
    }

    void init() throws SAXNotSupportedException, SAXNotRecognizedException {
        String string;
        Enumeration enumeration = this.parserFeatures.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            Object v2 = this.parserFeatures.get(string);
            if (v2 instanceof Boolean) {
                this.xmlReader.setFeature(string, this.parserConfiguration.getFeatureDefaultValue(string));
                continue;
            }
            this.xmlReader.setProperty(string, null);
        }
        this.parserFeatures.clear();
        this.schemaLanguage = null;
        this.isXIncludeAware = this.spf.isXIncludeAware();
        if (this.features != null && (string = this.features.get("http://javax.xml.XMLConstants/feature/secure-processing")) != null) {
            this.enableSecureProcessing = (Boolean)((Object)string);
        }
        if (this.enableSecureProcessing) {
            try {
                this.setProperty("http://apache.org/xml/properties/security-manager", this.secureProcessing);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                sAXNotRecognizedException.printStackTrace();
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {
                sAXNotSupportedException.printStackTrace();
            }
        }
        this.xmlReader.setFeature("http://apache.org/xml/features/xinclude-aware", this.isXIncludeAware);
        if (this.spf.isValidating()) {
            this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.xmlReader.setFeature("http://xml.org/sax/features/validation", this.spf.isValidating());
        this.xmlReader.setFeature("http://xml.org/sax/features/namespaces", this.spf.isNamespaceAware());
        this.xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", !this.spf.isNamespaceAware());
        this.setFeatures(this.features);
    }

    private void setFeatures(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl2 = (Boolean)hashtable.get(string);
                if (string.equals("http://javax.xml.XMLConstants/feature/secure-processing")) continue;
                this.xmlReader.setFeature(string, bl2);
            }
        }
    }

    public Parser getParser() throws SAXException {
        return this.xmlReader;
    }

    public void reset() {
        if (this.xmlReader != null) {
            try {
                this.xmlReader.reset();
                this.init();
            }
            catch (XNIException xNIException) {
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        try {
            return this.xmlReader.getFeature("http://xml.org/sax/features/namespaces");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    public boolean isValidating() {
        try {
            return this.xmlReader.getFeature("http://xml.org/sax/features/validation");
        }
        catch (SAXException sAXException) {
            throw new IllegalStateException(sAXException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.grammar != null && ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string) || "http://java.sun.com/xml/jaxp/properties/schemaSource".equals(string))) {
            throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(null, "schema-already-specified", null));
        }
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string)) {
            if ("http://www.w3.org/2001/XMLSchema".equals(object)) {
                if (!this.isValidating()) return;
                this.schemaLanguage = "http://www.w3.org/2001/XMLSchema";
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
                this.parserFeatures.put("http://apache.org/xml/features/validation/schema", new Boolean(true));
                this.parserFeatures.put("http://apache.org/xml/features/validation/schema-full-checking", new Boolean(true));
                this.xmlReader.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                this.parserFeatures.put("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                return;
            } else {
                if (object != null) throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(null, "schema-not-supported", null));
                this.schemaLanguage = null;
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", false);
                this.parserFeatures.put("http://apache.org/xml/features/validation/schema", new Boolean(false));
            }
            return;
        } else if ("http://java.sun.com/xml/jaxp/properties/schemaSource".equals(string)) {
            String string2 = (String)this.getProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage");
            if (string2 == null || !"http://www.w3.org/2001/XMLSchema".equals(string2)) throw new SAXNotSupportedException(SAXMessageFormatter.formatMessage(null, "jaxp-order-not-supported", new Object[]{"http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://java.sun.com/xml/jaxp/properties/schemaSource"}));
            this.xmlReader.setProperty(string, object);
            this.parserFeatures.put(string, object);
            return;
        } else if (object instanceof Boolean) {
            this.xmlReader.setFeature(string, (Boolean)object);
            this.parserFeatures.put(string, object);
            return;
        } else {
            this.xmlReader.setProperty(string, object);
            this.parserFeatures.put(string, object);
        }
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(string)) {
            return this.schemaLanguage;
        }
        return this.xmlReader.getProperty(string);
    }

    public Schema getSchema() {
        return this.grammar;
    }

    public boolean isSecureProcessing() {
        return this.secureProcessing != null;
    }
}

